/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.ErrorCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

@SquirrelJMEVendorApi
public class ASCII85Decoder
extends InputStream {
    private static final int _DIVISOR = 85;
    protected final Reader in;
    private final byte[] _single = new byte[1];
    private volatile int _buffer;
    private volatile int _index;
    private volatile int _leftBits;
    private volatile int _leftStop;
    private volatile boolean _eof;

    @SquirrelJMEVendorApi
    public ASCII85Decoder(Reader __in) throws NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        this.in = __in;
    }

    @Override
    public int read() throws IOException {
        int rc;
        byte[] single = this._single;
        do {
            if ((rc = this.read(single, 0, 1)) >= 0) continue;
            return -1;
        } while (rc != 1);
        return single[0] & 0xFF;
    }

    @Override
    public int read(byte[] __b) throws IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        return this.read(__b, 0, __b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l > __b.length || __o + __l < 0) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        if (__l == 0) {
            return 0;
        }
        Reader in = this.in;
        int buffer = this._buffer;
        int index = this._index;
        int leftBits = this._leftBits;
        int leftStop = this._leftStop;
        boolean eof = this._eof;
        try {
            int n2;
            int fillCount = 0;
            while (fillCount < __l) {
                if (leftBits > leftStop) {
                    __b[__o + fillCount++] = (byte)(buffer >>> leftBits - 8);
                    if ((leftBits -= 8) > leftStop) continue;
                    buffer = 0;
                    index = 0;
                    leftBits = 0;
                    leftStop = 0;
                }
                if (eof) break;
                int c2 = in.read();
                if (c2 < 0) {
                    if (index > 0) {
                        int was = index;
                        while (index < 5) {
                            buffer = buffer * 85 + 84;
                            ++index;
                        }
                        leftBits = 32;
                        leftStop = 8 * (5 - was);
                    }
                    eof = true;
                    continue;
                }
                if (c2 <= 32) continue;
                if (c2 == 122) {
                    if (index != 0) {
                        throw new IOException(ErrorCode.__error__("BD09 %d", index));
                    }
                    buffer = 0;
                    leftBits = 32;
                    continue;
                }
                buffer = buffer * 85 + (c2 - 33);
                if (++index != 5) continue;
                leftBits = 32;
            }
            if (fillCount == 0 && eof) {
                n2 = -1;
                return n2;
            }
            n2 = fillCount;
            return n2;
        }
        finally {
            this._buffer = buffer;
            this._index = index;
            this._leftBits = leftBits;
            this._leftStop = leftStop;
            this._eof = eof;
        }
    }
}

