/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.multiphasicapps.io.Base64Alphabet;
import net.multiphasicapps.io.StringReader;

@SquirrelJMEVendorApi
public final class Base64Decoder
extends InputStream {
    @SquirrelJMEVendorApi
    protected final Reader in;
    @SquirrelJMEVendorApi
    protected final boolean ignorepadding;
    private final char[] _alphabet;
    private final byte[] _ascii;
    private final byte[] _drain = new byte[3];
    private volatile int _buffer;
    private volatile int _bits;
    private volatile boolean _readeof;
    private volatile int _drained = -1;
    private volatile int _drainedmax = -1;

    @SquirrelJMEVendorApi
    public Base64Decoder(Reader __in) {
        this(__in, Base64Alphabet.BASIC);
    }

    @SquirrelJMEVendorApi
    public Base64Decoder(Reader __in, Base64Alphabet __chars) throws NullPointerException {
        this(__in, __chars._alphabet, false);
    }

    @SquirrelJMEVendorApi
    public Base64Decoder(Reader __in, String __chars) throws IllegalArgumentException, NullPointerException {
        this(__in, __chars.toCharArray(), false);
    }

    @SquirrelJMEVendorApi
    public Base64Decoder(Reader __in, char[] __chars) throws IllegalArgumentException, NullPointerException {
        this(__in, __chars, false);
    }

    @SquirrelJMEVendorApi
    public Base64Decoder(Reader __in, Base64Alphabet __chars, boolean __ip) throws NullPointerException {
        this(__in, __chars._alphabet, __ip);
    }

    @SquirrelJMEVendorApi
    public Base64Decoder(Reader __in, String __chars, boolean __ip) throws IllegalArgumentException, NullPointerException {
        this(__in, __chars.toCharArray(), __ip);
    }

    @SquirrelJMEVendorApi
    public Base64Decoder(Reader __in, char[] __chars, boolean __ip) throws IllegalArgumentException, NullPointerException {
        int i2;
        if (__in == null || __chars == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __chars.length;
        if (n2 != 65) {
            throw new IllegalArgumentException(String.format("BD0g %d", n2));
        }
        this.in = __in;
        this.ignorepadding = __ip;
        __chars = (char[])__chars.clone();
        this._alphabet = __chars;
        byte[] ascii = new byte[128];
        for (i2 = 0; i2 < 128; ++i2) {
            ascii[i2] = -1;
        }
        for (i2 = 0; i2 < 65; ++i2) {
            char dx = __chars[i2];
            if (dx >= '\u0080') continue;
            ascii[dx] = (byte)i2;
        }
        this._ascii = ascii;
    }

    @Override
    public final int available() throws IOException {
        int drained = this._drained;
        if (drained != -1) {
            return this._drainedmax - drained;
        }
        return 0;
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
    }

    @Override
    public final int read() throws IOException {
        int rc;
        int drained = this._drained;
        if (drained != -1) {
            int rv = this._drain[drained++] & 0xFF;
            if (drained == this._drainedmax) {
                this._drained = -1;
                this._drainedmax = -1;
            } else {
                this._drained = drained;
            }
            return rv;
        }
        if (this._readeof) {
            return -1;
        }
        byte[] next = new byte[1];
        do {
            if ((rc = this.read(next, 0, 1)) >= 0) continue;
            return -1;
        } while (rc == 0);
        return next[0] & 0xFF;
    }

    @Override
    public final int read(byte[] __b) throws IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        return this.read(__b, 0, __b.length);
    }

    @Override
    public final int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        boolean readeof = this._readeof;
        Reader in = this.in;
        boolean ignorepadding = this.ignorepadding;
        char[] alphabet = this._alphabet;
        byte[] ascii = this._ascii;
        byte[] drain = this._drain;
        int buffer = this._buffer;
        int bits = this._bits;
        int drained = this._drained;
        int drainedmax = this._drainedmax;
        int rv = 0;
        while (rv < __l) {
            if (drained != -1 && drained < drainedmax) {
                __b[__o++] = drain[drained++];
                ++rv;
                if (drained != drainedmax) continue;
                drainedmax = -1;
                drained = -1;
            }
            if (readeof) break;
            int ch2 = in.read();
            if (ch2 < 0) {
                if (bits != 0) {
                    throw new IOException("BD01 " + bits);
                }
                readeof = true;
                break;
            }
            if (ch2 < 128) {
                ch2 = ascii[ch2];
            } else {
                ch2 = -1;
                for (int i2 = 0; i2 < 65; ++i2) {
                    if (i2 != alphabet[i2]) continue;
                    ch2 = i2;
                    break;
                }
            }
            if (ch2 == -1 || ignorepadding && ch2 == 64) continue;
            if (ch2 == 64) {
                if (bits == 0 || bits == 24) {
                    throw new IOException("BD02 " + bits);
                }
                if (bits < 16) {
                    if (in.read() != alphabet[64]) {
                        throw new IOException("BD03");
                    }
                    drain[0] = (byte)(buffer >>> 4);
                    drainedmax = 1;
                } else {
                    drain[0] = (byte)(buffer >>> 10);
                    drain[1] = (byte)(buffer >>> 2);
                    drainedmax = 2;
                }
                drained = 0;
                bits = 0;
                buffer = 0;
                readeof = true;
                continue;
            }
            buffer <<= 6;
            buffer |= ch2;
            if ((bits += 6) != 24) continue;
            drain[0] = (byte)(buffer >>> 16);
            drain[1] = (byte)(buffer >>> 8);
            drain[2] = (byte)buffer;
            drained = 0;
            drainedmax = 3;
            bits = 0;
            buffer = 0;
        }
        this._buffer = buffer;
        this._bits = bits;
        this._readeof = readeof;
        this._drained = drained;
        this._drainedmax = drainedmax;
        if (readeof && rv == 0) {
            return -1;
        }
        return rv;
    }

    @SquirrelJMEVendorApi
    public static final byte[] decode(String __in, Base64Alphabet __ab) throws IllegalArgumentException, NullPointerException {
        return Base64Decoder.decode(__in, __ab, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SquirrelJMEVendorApi
    public static byte[] decode(String __in, Base64Alphabet __ab, boolean __ip) throws IllegalArgumentException, NullPointerException {
        if (__in == null) throw new NullPointerException("NARG");
        if (__ab == null) {
            throw new NullPointerException("NARG");
        }
        try (Base64Decoder in = new Base64Decoder((Reader)new StringReader(__in), __ab, __ip);){
            byte[] byArray = StreamUtils.readAll(in);
            return byArray;
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("BD04", e2);
        }
    }
}

