/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.multiphasicapps.io.Base64Alphabet;

@SquirrelJMEVendorApi
public final class Base64Encoder
extends Reader {
    private static final int _CHAR_MASK = 63;
    private static final int _BIT_COUNT = 6;
    @SquirrelJMEVendorApi
    protected final InputStream in;
    private final char[] _alphabet;
    int _bitStream;
    byte _count;
    boolean _hitEof;
    byte _paddingLeft = (byte)-1;
    int _totalBytes = 0;

    @SquirrelJMEVendorApi
    public Base64Encoder(InputStream __in) throws NullPointerException {
        this(__in, Base64Alphabet.BASIC);
    }

    @SquirrelJMEVendorApi
    public Base64Encoder(InputStream __in, Base64Alphabet __alphabet) throws NullPointerException {
        if (__in == null || __alphabet == null) {
            throw new NullPointerException("NARG");
        }
        this.in = __in;
        this._alphabet = __alphabet._alphabet;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] __c, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__c == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __c.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        InputStream in = this.in;
        char[] alphabet = this._alphabet;
        int bitStream = this._bitStream;
        int count = this._count;
        boolean hitEof = this._hitEof;
        int paddingLeft = this._paddingLeft;
        int totalBytes = this._totalBytes;
        try {
            int converted = 0;
            while (converted < __l) {
                if (count >= 6 || hitEof && count > 0) {
                    int downShift = Math.max(0, count - 6);
                    int value = bitStream >>> downShift & 0x3F;
                    if (hitEof && count < 6) {
                        value <<= 6 - count;
                    }
                    __c[__o + converted++] = alphabet[value];
                    count = Math.max(0, count - 6);
                    bitStream &= ~(-1 << downShift);
                } else {
                    if (paddingLeft == 0) break;
                    if (paddingLeft > 0) {
                        __c[__o + converted++] = 61;
                        --paddingLeft;
                        continue;
                    }
                }
                if (count + 8 > 24 || hitEof) continue;
                int read = in.read();
                if (read < 0) {
                    hitEof = true;
                    switch (totalBytes % 3) {
                        case 0: {
                            paddingLeft = 0;
                            break;
                        }
                        case 1: {
                            paddingLeft = 2;
                            break;
                        }
                        case 2: {
                            paddingLeft = 1;
                        }
                    }
                    continue;
                }
                bitStream <<= 8;
                bitStream |= read & 0xFF;
                count += 8;
                ++totalBytes;
            }
            int n2 = hitEof && paddingLeft == 0 && converted == 0 ? -1 : converted;
            return n2;
        }
        finally {
            this._bitStream = bitStream;
            this._count = (byte)count;
            this._hitEof = hitEof;
            this._paddingLeft = (byte)paddingLeft;
            this._totalBytes = totalBytes;
        }
    }

    @SquirrelJMEVendorApi
    public static String encode(byte[] __buf) throws IOException, NullPointerException {
        if (__buf == null) {
            throw new NullPointerException("NARG");
        }
        return Base64Encoder.encode(new StringBuffer(__buf.length * 3), __buf).toString();
    }

    @SquirrelJMEVendorApi
    public static <A extends Appendable> A encode(A __into, byte[] __buf) throws IOException, NullPointerException {
        if (__into == null || __buf == null) {
            throw new NullPointerException("NARG");
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(__buf);){
            A a2 = Base64Encoder.encode(__into, in);
            return a2;
        }
    }

    @SquirrelJMEVendorApi
    public static <A extends Appendable> A encode(A __into, InputStream __in) throws IOException, NullPointerException {
        if (__into == null || __in == null) {
            throw new NullPointerException("NARG");
        }
        try (Base64Encoder encoder = new Base64Encoder(__in);){
            int c2;
            while ((c2 = encoder.read()) >= 0) {
                if (c2 <= 32) continue;
                __into.append((char)c2);
            }
        }
        return __into;
    }
}

