/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@SquirrelJMEVendorApi
public class ByteDeque {
    private static final int _BLOCK_SIZE = Math.max(8, Integer.getInteger("net.multiphasicapps.util.datadeque.blocksize", ByteDeque.__dequeSliceSize()));
    private static final int _BLOCK_MASK = _BLOCK_SIZE - 1;
    private static final int _BLOCK_SHIFT = Integer.numberOfTrailingZeros(_BLOCK_SIZE);
    @SquirrelJMEVendorApi
    protected final int capacity;
    private final LinkedList<byte[]> _blocks = new LinkedList();
    private final byte[] _solo = new byte[1];
    private volatile int _total;
    private volatile int _head;
    private volatile int _tail;

    @SquirrelJMEVendorApi
    public ByteDeque() {
        this(Integer.MAX_VALUE);
    }

    @SquirrelJMEVendorApi
    public ByteDeque(int __cap) throws IllegalArgumentException {
        if (__cap < 0) {
            throw new IllegalArgumentException("BD22");
        }
        this.capacity = __cap;
    }

    @SquirrelJMEVendorApi
    public final void addFirst(byte __b) throws IllegalStateException {
        byte[] solo = this._solo;
        solo[0] = __b;
        this.addFirst(solo, 0, 1);
    }

    @SquirrelJMEVendorApi
    public final void addFirst(byte[] __b) throws IllegalStateException, NullPointerException {
        this.addFirst(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final void addFirst(byte[] __b, int __o, int __l) throws IllegalStateException, IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        if (__l == 0) {
            return;
        }
        int total = this._total;
        int newtotal = total + __l;
        if (newtotal < 0 || newtotal > this.capacity) {
            throw new IllegalStateException("BD23");
        }
        LinkedList<byte[]> blocks = this._blocks;
        int nb = blocks.size();
        int head = this._head;
        int tail = this._tail;
        throw Debugging.todo();
    }

    @SquirrelJMEVendorApi
    public final void addLast(byte __b) throws IllegalStateException {
        byte[] solo = this._solo;
        solo[0] = __b;
        this.addLast(solo, 0, 1);
    }

    @SquirrelJMEVendorApi
    public final void addLast(byte[] __b) throws IllegalStateException, NullPointerException {
        this.addLast(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final void addLast(byte[] __b, int __o, int __l) throws IllegalStateException, IndexOutOfBoundsException, NullPointerException {
        int limit;
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        if (__l == 0) {
            return;
        }
        int total = this._total;
        int newtotal = total + __l;
        if (newtotal < 0 || newtotal > this.capacity) {
            throw new IllegalStateException("BD24");
        }
        LinkedList<byte[]> blocks = this._blocks;
        int nb = blocks.size();
        int head = this._head;
        int tail = this._tail;
        int bs2 = _BLOCK_SIZE;
        int bm2 = _BLOCK_MASK;
        int at2 = __o;
        for (int left = __l; left > 0; left -= limit) {
            byte[] bl2;
            if (tail == 0) {
                bl2 = new byte[bs2];
                blocks.addLast(bl2);
            } else {
                bl2 = blocks.getLast();
            }
            limit = bs2 - tail;
            if (left < limit) {
                limit = left;
            }
            ObjectShelf.arrayCopy(__b, at2, bl2, tail, limit);
            tail += limit;
            at2 += limit;
            tail &= bm2;
        }
        this._total = newtotal;
        this._tail = tail;
    }

    @SquirrelJMEVendorApi
    public final int available() {
        return this._total;
    }

    @SquirrelJMEVendorApi
    public final void clear() {
        this._total = 0;
        this._head = 0;
        this._tail = 0;
        LinkedList<byte[]> blocks = this._blocks;
        for (byte[] bl2 : blocks) {
            Arrays.fill(bl2, (byte)0);
        }
        blocks.clear();
    }

    @SquirrelJMEVendorApi
    public final int deleteFirst(int __l) throws IndexOutOfBoundsException {
        int rc;
        if (__l < 0) {
            throw new IndexOutOfBoundsException("BD25");
        }
        if (__l == 0) {
            return 0;
        }
        int total = this._total;
        if (total == 0) {
            return 0;
        }
        int limit = Math.min(__l, total);
        int newtotal = total - limit;
        LinkedList<byte[]> blocks = this._blocks;
        int nb = blocks.size();
        int head = this._head;
        int tail = this._tail;
        int bs2 = _BLOCK_SIZE;
        int bm2 = _BLOCK_MASK;
        for (int left = limit; left > 0; left -= rc) {
            boolean lastbl;
            byte[] bl2 = blocks.getFirst();
            boolean bl3 = lastbl = nb == 1;
            int n2 = lastbl ? (tail == 0 ? bs2 : tail) - head : (rc = bs2 - head);
            if (left < rc) {
                rc = left;
            }
            if (rc < 0) {
                throw Debugging.oops();
            }
            for (int i2 = 0; i2 < rc; ++i2) {
                bl2[head++] = 0;
            }
            if ((head &= bm2) != 0 && (!lastbl || head != tail)) continue;
            blocks.removeFirst();
            --nb;
        }
        if (newtotal == 0) {
            tail = 0;
            head = 0;
        }
        this._total = newtotal;
        this._head = head;
        this._tail = tail;
        return limit;
    }

    @SquirrelJMEVendorApi
    public final byte get(int __a) throws IndexOutOfBoundsException {
        if (__a < 0) {
            throw new IndexOutOfBoundsException("BD26");
        }
        byte[] solo = this._solo;
        int rv = this.get(__a, solo, 0, 1);
        if (rv == 1) {
            return solo[0];
        }
        throw new IndexOutOfBoundsException(String.format("BD27 %d", __a));
    }

    @SquirrelJMEVendorApi
    public final int get(int __a, byte[] __b) throws IndexOutOfBoundsException, NullPointerException {
        return this.get(__a, __b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final int get(int __a, byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__a < 0) {
            throw new IndexOutOfBoundsException("BD28");
        }
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        int total = this._total;
        if (total <= 0) {
            return 0;
        }
        if (__a >= total) {
            throw new IndexOutOfBoundsException(String.format("BD29 %d %d", __a, total));
        }
        return this.__getOrSetVia(__a < total >> 1, __a, __b, __o, __l, false);
    }

    @SquirrelJMEVendorApi
    public final byte getFirst() throws NoSuchElementException {
        byte[] solo = this._solo;
        int rv = this.getFirst(solo, 0, 1);
        if (rv == 1) {
            return solo[0];
        }
        throw new NoSuchElementException("BD2a");
    }

    @SquirrelJMEVendorApi
    public final int getFirst(byte[] __b) throws NullPointerException {
        return this.getFirst(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final int getFirst(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        return this.get(0, __b, __o, __l);
    }

    @SquirrelJMEVendorApi
    public final byte getLast() throws NoSuchElementException {
        byte[] solo = this._solo;
        int rv = this.getLast(solo, 0, 1);
        if (rv == 0) {
            return solo[0];
        }
        throw new NoSuchElementException("BD2b");
    }

    @SquirrelJMEVendorApi
    public final int getLast(byte[] __b) throws NullPointerException {
        return this.getLast(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final int getLast(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__l < 0) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        int total = this._total;
        return this.get(Math.max(0, total - __l), __b, __o, __l);
    }

    @SquirrelJMEVendorApi
    public final boolean isEmpty() {
        return this.available() == 0;
    }

    @SquirrelJMEVendorApi
    public final boolean offerFirst(byte __b) {
        try {
            this.addFirst(__b);
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    @SquirrelJMEVendorApi
    public final boolean offerFirst(byte[] __b) throws NullPointerException {
        return this.offerFirst(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final boolean offerFirst(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException {
        try {
            this.addFirst(__b, __o, __l);
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    @SquirrelJMEVendorApi
    public final boolean offerLast(byte __b) {
        try {
            this.addLast(__b);
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    @SquirrelJMEVendorApi
    public final boolean offerLast(byte[] __b) throws NullPointerException {
        return this.offerLast(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final boolean offerLast(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException {
        try {
            this.addLast(__b, __o, __l);
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    @SquirrelJMEVendorApi
    public final int peekFirst() throws NoSuchElementException {
        try {
            return this.getFirst() & 0xFF;
        }
        catch (NoSuchElementException e2) {
            return -1;
        }
    }

    @SquirrelJMEVendorApi
    public final int peekLast() throws NoSuchElementException {
        try {
            return this.getLast() & 0xFF;
        }
        catch (NoSuchElementException e2) {
            return -1;
        }
    }

    @SquirrelJMEVendorApi
    public final byte removeFirst() throws NoSuchElementException {
        byte[] solo = this._solo;
        int rv = this.removeFirst(solo, 0, 1);
        if (rv == 1) {
            return solo[0];
        }
        throw new NoSuchElementException("BD2c");
    }

    @SquirrelJMEVendorApi
    public final int removeFirst(byte[] __b) throws NullPointerException {
        return this.removeFirst(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final int removeFirst(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        int rvb;
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        if (__l == 0) {
            return 0;
        }
        int total = this._total;
        if (total == 0) {
            return 0;
        }
        int rva = this.get(0, __b, __o, __l);
        if (rva != (rvb = this.deleteFirst(__l))) {
            throw Debugging.oops();
        }
        return rva;
    }

    @SquirrelJMEVendorApi
    public final byte removeLast() throws NoSuchElementException {
        byte[] solo = this._solo;
        int rv = this.removeLast(solo, 0, 1);
        if (rv == 1) {
            return solo[0];
        }
        throw new NoSuchElementException("BD2d");
    }

    @SquirrelJMEVendorApi
    public final int removeLast(byte[] __b) throws NullPointerException {
        return this.removeLast(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final int removeLast(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        throw Debugging.todo();
    }

    @SquirrelJMEVendorApi
    public final byte set(int __a) throws IndexOutOfBoundsException {
        if (__a < 0) {
            throw new IndexOutOfBoundsException("BD2e");
        }
        byte[] solo = this._solo;
        int rv = this.set(__a, solo, 0, 1);
        if (rv == 1) {
            return solo[0];
        }
        throw new IndexOutOfBoundsException(String.format("BD2f %d", __a));
    }

    @SquirrelJMEVendorApi
    public final int set(int __a, byte[] __b) throws IndexOutOfBoundsException, NullPointerException {
        return this.set(__a, __b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public final int set(int __a, byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__a < 0) {
            throw new IndexOutOfBoundsException("BD2g");
        }
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        int total = this._total;
        if (__a < 0 || __a >= total) {
            throw new IndexOutOfBoundsException(String.format("BD2h %d %d", __a, total));
        }
        if (total <= 0) {
            return 0;
        }
        return this.__getOrSetVia(__a < total >> 1, __a, __b, __o, __l, true);
    }

    @SquirrelJMEVendorApi
    public final int size() {
        return this._total;
    }

    @SquirrelJMEVendorApi
    public final byte[] toByteArray() {
        int sz = this.available();
        byte[] rv = new byte[sz];
        this.get(0, rv, 0, sz);
        return rv;
    }

    @SquirrelJMEVendorApi
    public final void writeTo(OutputStream __os) throws IOException, NullPointerException {
        if (__os == null) {
            throw new NullPointerException("NARG");
        }
        throw Debugging.todo();
    }

    private int __getOrSetVia(boolean __last, int __a, byte[] __b, int __o, int __l, boolean __set) {
        int rc;
        Iterator it;
        int total = this._total;
        LinkedList<byte[]> blocks = this._blocks;
        int nb = blocks.size();
        int head = this._head;
        int tail = this._tail;
        int bs2 = _BLOCK_SIZE;
        int bm2 = _BLOCK_MASK;
        int limit = total - __a;
        if (__l < limit) {
            limit = __l;
        }
        int blskip = head + __a >> _BLOCK_SHIFT;
        if (__last && nb > 1) {
            ListIterator<byte[]> lit = blocks.listIterator(nb);
            it = lit;
            int backskip = nb - blskip;
            for (int i2 = 0; i2 < backskip; ++i2) {
                lit.previous();
            }
        } else {
            it = blocks.iterator();
            for (int i3 = 0; i3 < blskip; ++i3) {
                it.next();
            }
        }
        int rhead = head + __a & bm2;
        int at2 = __o;
        for (int left = limit; left > 0; left -= rc) {
            byte[] bl2 = (byte[])it.next();
            boolean lastbl = !it.hasNext();
            rc = (lastbl && tail != 0 ? tail : bs2) - rhead;
            if (left < rc) {
                rc = left;
            }
            if (__set) {
                ObjectShelf.arrayCopy(__b, at2, bl2, rhead, rc);
            } else {
                ObjectShelf.arrayCopy(bl2, rhead, __b, at2, rc);
            }
            at2 += rc;
            rhead += rc;
            rhead = 0;
        }
        return limit;
    }

    private static int __dequeSliceSize() {
        return 512;
    }

    static {
        if (Integer.bitCount(_BLOCK_SIZE) != 1) {
            throw new RuntimeException(String.format("BD21 %d", _BLOCK_SIZE));
        }
    }
}

