/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import net.multiphasicapps.io.CRC32Table;
import net.multiphasicapps.io.Checksum;

@SquirrelJMEVendorApi
public class CRC32Calculator
implements Checksum {
    @SquirrelJMEVendorApi
    protected final int polynomial;
    @SquirrelJMEVendorApi
    protected final int finalXor;
    @SquirrelJMEVendorApi
    protected final boolean reflectData;
    @SquirrelJMEVendorApi
    protected final boolean reflectRemainder;
    @SquirrelJMEVendorApi
    protected final int initRemainder;
    final CRC32Table _table;
    private final byte[] _solo = new byte[1];
    private volatile int _remainder;

    @SquirrelJMEVendorApi
    public CRC32Calculator(boolean __rdata, boolean __rrem, int __poly, int __initrem, int __fxor) {
        this.reflectData = __rdata;
        this.reflectRemainder = __rrem;
        this.polynomial = __poly;
        this.finalXor = __fxor;
        this.initRemainder = __initrem;
        this._remainder = __initrem;
        this._table = CRC32Table.calculateTable(__poly);
    }

    @Override
    public final int checksum() {
        int rem = this._remainder;
        return (this.reflectRemainder ? Integer.reverse(rem) : rem) ^ this.finalXor;
    }

    @Override
    public final void offer(byte __b) {
        byte[] solo = this._solo;
        solo[0] = __b;
        this.offer(solo, 0, 1);
    }

    @Override
    public final void offer(byte[] __b) throws NullPointerException {
        this.offer(__b, 0, __b.length);
    }

    @Override
    public final void offer(byte[] __b, int __o, int __l) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new ArrayIndexOutOfBoundsException("BAOB");
        }
        boolean reflectData = this.reflectData;
        int remainder = this._remainder;
        int[] table = this._table._table;
        int end = __o + __l;
        for (int i2 = __o; i2 < end; ++i2) {
            int val2 = __b[i2] & 0xFF;
            if (reflectData) {
                val2 = Integer.reverse(val2) >>> 24;
            }
            int d2 = val2 ^ remainder >>> 24;
            remainder = table[d2] ^ remainder << 8;
        }
        this._remainder = remainder;
    }

    @Override
    public final void reset() {
        this._remainder = this.initRemainder;
    }

    @SquirrelJMEVendorApi
    public static final int calculate(boolean __rdata, boolean __rrem, int __poly, int __initrem, int __fxor, byte[] __b) throws NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        return CRC32Calculator.calculate(__rdata, __rrem, __poly, __initrem, __fxor, __b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public static final int calculate(boolean __rdata, boolean __rrem, int __poly, int __initrem, int __fxor, byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        CRC32Calculator calc = new CRC32Calculator(__rdata, __rrem, __poly, __initrem, __fxor);
        calc.offer(__b, __o, __l);
        return calc.checksum();
    }

    @SquirrelJMEVendorApi
    public static final int calculateZip(byte[] __b) throws NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        return CRC32Calculator.calculateZip(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public static final int calculateZip(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        return CRC32Calculator.calculate(true, true, 79764919, -1, -1, __b, __o, __l);
    }
}

