/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.multiphasicapps.io.ChunkDataType;
import net.multiphasicapps.io.ChunkFuture;
import net.multiphasicapps.io.ChunkFutureSection;
import net.multiphasicapps.io.ChunkFutureSectionKind;
import net.multiphasicapps.io.__Dirty__;
import net.multiphasicapps.io.__FuturePoint__;

@SquirrelJMEVendorApi
public final class ChunkSection
extends OutputStream
implements DataOutput {
    private static final int _BUFFER_SIZE = 512;
    @SquirrelJMEVendorApi
    protected final int fixedSize;
    @SquirrelJMEVendorApi
    protected final int alignment;
    @SquirrelJMEVendorApi
    protected final boolean isVariable;
    final List<__FuturePoint__> _futures = new LinkedList<__FuturePoint__>();
    final __Dirty__ _dirty;
    byte[] _data;
    int _size;
    int _writeAddr = -1;
    int _writeSize = -1;

    ChunkSection(int __size, int __align, __Dirty__ __d) throws IllegalArgumentException, NullPointerException {
        if (__d == null) {
            throw new NullPointerException("NARG");
        }
        if (__size != Integer.MIN_VALUE && __size <= 0) {
            throw new IllegalArgumentException("BD3l " + __size);
        }
        this.fixedSize = __size;
        this.alignment = Math.max(__align, 1);
        this.isVariable = __size == Integer.MIN_VALUE;
        this._dirty = __d;
        this._data = __size != Integer.MIN_VALUE ? new byte[__size] : new byte[512];
    }

    @Override
    public final void close() {
    }

    @SquirrelJMEVendorApi
    public byte[] currentBytes() {
        return Arrays.copyOf(this._data, this._size);
    }

    @SquirrelJMEVendorApi
    public final InputStream currentStream() {
        return new ByteArrayInputStream(this._data, 0, this._size);
    }

    @Override
    public final void flush() {
    }

    @SquirrelJMEVendorApi
    public final ChunkFutureSection futureAddress() {
        return this.futureAddress(0);
    }

    @SquirrelJMEVendorApi
    public final ChunkFutureSection futureAddress(int __off) {
        return new ChunkFutureSection(ChunkFutureSectionKind.ADDRESS, this, __off);
    }

    @SquirrelJMEVendorApi
    public final ChunkFutureSection futureSize() {
        return this.futureSize(0);
    }

    @SquirrelJMEVendorApi
    public final ChunkFutureSection futureSize(int __off) {
        return new ChunkFutureSection(ChunkFutureSectionKind.SIZE, this, __off);
    }

    @SquirrelJMEVendorApi
    public final int size() {
        return this._size;
    }

    @Override
    public final void write(int __b) throws IOException {
        int size = this._size;
        if (!this.isVariable && size + 1 > this.fixedSize) {
            throw new IOException("BD3m " + size);
        }
        byte[] data = this._data;
        if (this.isVariable && size >= data.length) {
            this._data = data = Arrays.copyOf(data, size + 512);
        }
        data[size] = (byte)__b;
        this._size = size + 1;
        this._dirty._dirty = true;
    }

    @Override
    public final void write(byte[] __b) throws IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        this.write(__b, 0, __b.length);
    }

    @Override
    public final void write(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        int size = this._size;
        if (!this.isVariable && size + __l > this.fixedSize) {
            throw new IOException("BD3p");
        }
        byte[] data = this._data;
        if (this.isVariable && size + __l >= data.length) {
            this._data = data = Arrays.copyOf(data, size + Math.max(__l, 512));
        }
        for (int i2 = 0; i2 < __l; ++i2) {
            data[size++] = __b[__o++];
        }
        this._size = size;
        this._dirty._dirty = true;
    }

    @SquirrelJMEVendorApi
    public final int writeAlignment(int __n) throws IllegalArgumentException, IOException {
        if (__n < 1) {
            throw new IllegalArgumentException("BD3k " + __n);
        }
        if (__n == 1) {
            return 0;
        }
        throw Debugging.todo();
    }

    @Override
    public final void writeBoolean(boolean __v) throws IOException {
        throw Debugging.todo();
    }

    @Override
    public final void writeByte(int __v) throws IOException {
        this.write(__v);
    }

    @Override
    public final void writeBytes(String __v) throws IOException, NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __v.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write(__v.charAt(i2));
        }
    }

    @Override
    public final void writeChar(int __v) throws IOException {
        this.writeShort(__v);
    }

    @Override
    public final void writeChars(String __v) throws IOException, NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __v.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = __v.charAt(i2);
            this.write(c2 >> 8);
            this.write(c2);
        }
    }

    @Override
    public final void writeDouble(double __v) throws IOException {
        this.writeLong(Double.doubleToLongBits(__v));
    }

    @Override
    public final void writeFloat(float __v) throws IOException {
        this.writeInt(Float.floatToIntBits(__v));
    }

    @SquirrelJMEVendorApi
    public final void writeFuture(ChunkDataType __dt, ChunkFuture __val) throws IOException, NullPointerException {
        if (__dt == null || __val == null) {
            throw new NullPointerException("NARG");
        }
        this._futures.add(new __FuturePoint__(this._size, __dt, __val));
        this.writePadding(__dt.numBytes);
    }

    @Override
    public final void writeInt(int __v) throws IOException {
        this.write(__v >> 24);
        this.write(__v >> 16);
        this.write(__v >> 8);
        this.write(__v);
    }

    @Override
    public final void writeLong(long __v) throws IOException {
        this.write((int)(__v >> 56));
        this.write((int)(__v >> 48));
        this.write((int)(__v >> 40));
        this.write((int)(__v >> 32));
        this.write((int)(__v >> 24));
        this.write((int)(__v >> 16));
        this.write((int)(__v >> 8));
        this.write((int)__v);
    }

    @SquirrelJMEVendorApi
    public final void writePadding(int __n) throws IOException {
        this.writePadding(__n, 0);
    }

    @SquirrelJMEVendorApi
    public final void writePadding(int __n, int __v) throws IllegalArgumentException, IOException {
        if (__n < 0) {
            throw new IllegalArgumentException("BD3j " + __n);
        }
        if (__n == 0) {
            return;
        }
        for (int i2 = 0; i2 < __n; ++i2) {
            this.write(__v);
        }
    }

    @Override
    public final void writeShort(int __v) throws IOException {
        this.write(__v >> 8);
        this.write(__v);
    }

    @SquirrelJMEVendorApi
    public final void writeShortChecked(int __v) throws IOException {
        if (__v < Short.MIN_VALUE || __v > Short.MAX_VALUE) {
            throw new IOException("BD3o " + __v);
        }
        this.write(__v >> 8);
        this.write(__v);
    }

    @SquirrelJMEVendorApi
    public final void writeUnsignedShortChecked(int __v) throws IOException {
        if (__v < 0 || __v > 65535) {
            throw new IOException("BD3n " + __v);
        }
        this.write(__v >> 8);
        this.write(__v);
    }

    @Override
    public final void writeUTF(String __v) throws IOException, NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(2 + __v.length() * 2);
             DataOutputStream dos = new DataOutputStream(baos);){
            dos.writeUTF(__v);
            baos.writeTo(this);
        }
    }
}

