/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.multiphasicapps.io.ChunkFuture;
import net.multiphasicapps.io.ChunkFutureChunk;
import net.multiphasicapps.io.ChunkFutureLong;
import net.multiphasicapps.io.ChunkSection;
import net.multiphasicapps.io.__Dirty__;
import net.multiphasicapps.io.__FuturePoint__;

@SquirrelJMEVendorApi
public final class ChunkWriter {
    @SquirrelJMEVendorApi
    public static final int VARIABLE_SIZE = Integer.MIN_VALUE;
    private final List<ChunkSection> _sections = new LinkedList<ChunkSection>();
    private final __Dirty__ _dirty = new __Dirty__();
    private int _fileSize;

    @SquirrelJMEVendorApi
    public final ChunkSection addSection() {
        return this.addSection(Integer.MIN_VALUE, 1);
    }

    @SquirrelJMEVendorApi
    public final ChunkSection addSection(byte[] __bytes) throws IOException, NullPointerException {
        return this.addSection(__bytes, 1);
    }

    @SquirrelJMEVendorApi
    public final ChunkSection addSection(byte[] __bytes, int __align) throws IllegalArgumentException, IOException, NullPointerException {
        if (__bytes == null) {
            throw new NullPointerException("NARG");
        }
        ChunkSection rv = this.addSection(__bytes.length, __align);
        rv.write(__bytes);
        return rv;
    }

    @SquirrelJMEVendorApi
    public final ChunkSection addSection(int __size) throws IllegalArgumentException {
        return this.addSection(__size, 1);
    }

    @SquirrelJMEVendorApi
    public final ChunkSection addSection(int __size, int __align) throws IllegalArgumentException {
        if (__size != Integer.MIN_VALUE && __size <= 0) {
            throw new IllegalArgumentException("BD3h " + __size);
        }
        if (__align < 1) {
            throw new IllegalArgumentException("BD3q " + __align);
        }
        ChunkSection rv = new ChunkSection(__size, __align, this._dirty);
        this._sections.add(rv);
        this._dirty._dirty = true;
        return rv;
    }

    @SquirrelJMEVendorApi
    public final int fileSize() {
        this.undirty();
        return this._fileSize;
    }

    @SquirrelJMEVendorApi
    public final ChunkFutureChunk futureSize() {
        return new ChunkFutureChunk(this);
    }

    @SquirrelJMEVendorApi
    public final int sectionAddress(ChunkSection __s) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        this.undirty();
        return __s._writeAddr;
    }

    @SquirrelJMEVendorApi
    public final int sectionSize(ChunkSection __s) throws NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        this.undirty();
        return __s._writeSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SquirrelJMEVendorApi
    public final byte[] toByteArray() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(this.fileSize());){
            this.writeTo(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e2) {
            throw new RuntimeException("BD3i", e2);
        }
    }

    @SquirrelJMEVendorApi
    public void undirty() {
        __Dirty__ dirty = this._dirty;
        if (!dirty._dirty) {
            return;
        }
        int fileSize = 0;
        List<ChunkSection> sections = this._sections;
        int n2 = sections.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ChunkSection section = sections.get(i2);
            if (fileSize % section.alignment != 0) {
                fileSize += section.alignment - fileSize % section.alignment;
            }
            section._writeAddr = fileSize;
            int writeSize = section.isVariable ? section._size : section.fixedSize;
            fileSize += writeSize;
            section._writeSize = writeSize;
        }
        this._fileSize = fileSize;
        dirty._dirty = false;
    }

    @SquirrelJMEVendorApi
    public final void writeTo(OutputStream __os) throws IOException, NullPointerException {
        if (__os == null) {
            throw new NullPointerException("NARG");
        }
        int writePtr = 0;
        this.undirty();
        List<ChunkSection> sections = this._sections;
        int n2 = sections.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ChunkSection section = sections.get(i2);
            byte[] data = section._data;
            int curSize = section._size;
            int writeAddr = section._writeAddr;
            int writeSize = section._writeSize;
            int writeEndAddr = writeAddr + writeSize;
            int actualWrite = Math.min(curSize, writeSize);
            while (writePtr < writeAddr) {
                __os.write(0);
                ++writePtr;
            }
            for (__FuturePoint__ point : section._futures) {
                ChunkFuture pointVal = point.value;
                long value = pointVal instanceof ChunkFutureLong ? ((ChunkFutureLong)pointVal).getLong() : (long)pointVal.get() & 0xFFFFFFFFL;
                int pa = point.address;
                switch (point.type) {
                    case BYTE: {
                        data[pa] = (byte)value;
                        break;
                    }
                    case SHORT: {
                        data[pa] = (byte)(value >>> 8);
                        data[pa + 1] = (byte)value;
                        break;
                    }
                    case INTEGER: {
                        data[pa] = (byte)(value >>> 24);
                        data[pa + 1] = (byte)(value >>> 16);
                        data[pa + 2] = (byte)(value >>> 8);
                        data[pa + 3] = (byte)value;
                        break;
                    }
                    case LONG: {
                        data[pa] = (byte)(value >>> 56);
                        data[pa + 1] = (byte)(value >>> 48);
                        data[pa + 2] = (byte)(value >>> 40);
                        data[pa + 3] = (byte)(value >>> 32);
                        data[pa + 4] = (byte)(value >>> 24);
                        data[pa + 5] = (byte)(value >>> 16);
                        data[pa + 6] = (byte)(value >>> 8);
                        data[pa + 7] = (byte)value;
                    }
                }
            }
            __os.write(data, 0, actualWrite);
            writePtr += actualWrite;
            while (writePtr < writeEndAddr) {
                __os.write(0);
                ++writePtr;
            }
        }
    }
}

