/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.IOException;
import java.io.OutputStream;
import net.multiphasicapps.io.CompressionLevel;
import net.multiphasicapps.io.CompressionStream;

@SquirrelJMEVendorApi
public class DeflaterOutputStream
extends OutputStream
implements CompressionStream {
    @SquirrelJMEVendorApi
    protected final OutputStream out;
    private final int _blocksize;
    private final byte[] _fill;
    private int _fillbytes;
    private boolean _closed;
    private long _ncompressed;
    private long _nuncompressed;
    private int _wout;
    private int _wbits;

    @SquirrelJMEVendorApi
    public DeflaterOutputStream(OutputStream __os) throws NullPointerException {
        this(__os, CompressionLevel.DEFAULT);
    }

    @SquirrelJMEVendorApi
    public DeflaterOutputStream(OutputStream __os, CompressionLevel __cl) throws NullPointerException {
        if (__os == null || __cl == null) {
            throw new NullPointerException("NARG");
        }
        this.out = __os;
        int blocksize = __cl.blockSize();
        this._fill = new byte[blocksize];
        this._blocksize = blocksize;
        Debugging.todoNote("Implement fixed and dynamic huffman!", new Object[0]);
    }

    @Override
    public final void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            if (this._fillbytes > 0) {
                this.__processFill();
            }
            this.__bitOut(1, 1, false);
            this.__bitOut(1, 2, false);
            this.__bitOut(0, 7, true);
            this.__bitPad(8);
            this.__bitFlush();
            this.flush();
        }
        this.out.close();
    }

    @Override
    public final long compressedBytes() {
        return this._ncompressed;
    }

    @Override
    public final void flush() throws IOException {
        this.__bitFlush();
        this.out.flush();
    }

    @Override
    public final long uncompressedBytes() {
        return this._nuncompressed;
    }

    @Override
    public final void write(int __b) throws IOException {
        this.write(new byte[]{(byte)__b}, 0, 1);
    }

    @Override
    public final void write(byte[] __b) throws IOException, NullPointerException {
        this.write(__b, 0, __b.length);
    }

    @Override
    public final void write(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        byte[] fill = this._fill;
        int blocksize = this._blocksize;
        int fillbytes = this._fillbytes;
        boolean addedfill = false;
        while (__l > 0) {
            int leftinfill = blocksize - fillbytes;
            if (__l < leftinfill) {
                leftinfill = __l;
            }
            for (int i2 = 0; i2 < leftinfill; ++i2) {
                fill[fillbytes++] = __b[__o++];
            }
            __l -= leftinfill;
            if (fillbytes == blocksize) {
                this._fillbytes = fillbytes;
                this.__processFill();
                fillbytes = 0;
                continue;
            }
            addedfill = true;
        }
        this._nuncompressed += (long)__l;
        if (addedfill) {
            this._fillbytes = fillbytes;
        }
    }

    final void __bitFlush() throws IOException {
        int wbits = this._wbits;
        if (wbits >= 8) {
            OutputStream out = this.out;
            int wout = this._wout;
            long ncompressed = this._ncompressed;
            while (wbits >= 8) {
                out.write(wout & 0xFF);
                wout >>>= 8;
                wbits -= 8;
                ++ncompressed;
            }
            this._wbits = wbits;
            this._wout = wout;
            this._ncompressed = ncompressed;
        }
    }

    final void __bitOut(int __v, int __n, boolean __msb) throws IOException {
        if (__msb) {
            __v = Integer.reverse(__v) >>> 32 - __n;
        }
        int wout = this._wout;
        int wbits = this._wbits;
        int mask = (1 << __n) - 1;
        wout |= (__v & mask) << wbits;
        this._wout = wout;
        this._wbits = wbits += __n;
        if (wbits >= 24) {
            this.__bitFlush();
        }
    }

    final void __bitPad(int __n) throws IOException {
        int wbits = this._wbits;
        int rem = wbits % __n;
        this._wbits = wbits + (__n - rem);
    }

    final void __processFill() throws IOException {
        byte[] fill = this._fill;
        int fillbytes = this._fillbytes;
        int hufftype = 0;
        if (hufftype == 1) {
            throw Debugging.todo();
        }
        if (hufftype == 2) {
            throw Debugging.todo();
        }
        this.__bitOut(0, 1, false);
        this.__bitOut(0, 2, false);
        this.__bitPad(8);
        this.__bitOut(fillbytes, 16, false);
        this.__bitOut(fillbytes ^ 0xFFFF, 16, false);
        for (int i2 = 0; i2 < fillbytes; ++i2) {
            this.__bitOut(fill[i2], 8, false);
        }
        this._fillbytes = 0;
    }
}

