/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.IOException;
import java.io.InputStream;
import net.multiphasicapps.io.ByteDeque;

@SquirrelJMEVendorApi
public class DynamicHistoryInputStream
extends InputStream {
    @SquirrelJMEVendorApi
    protected final ByteDeque buffer;
    @SquirrelJMEVendorApi
    protected final InputStream input;
    private volatile boolean _closed;
    private volatile boolean _eof;

    @SquirrelJMEVendorApi
    public DynamicHistoryInputStream(InputStream __is) throws NullPointerException {
        if (__is == null) {
            throw new NullPointerException("NARG");
        }
        this.input = __is;
        this.buffer = new ByteDeque();
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
        this.buffer.clear();
        this.input.close();
    }

    @SquirrelJMEVendorApi
    public int grab(int __i) throws IndexOutOfBoundsException, IOException {
        int total;
        int rc;
        if (__i < 0) {
            throw new IndexOutOfBoundsException(String.format("BD0m %s", __i));
        }
        ByteDeque buffer = this.buffer;
        if (this._closed) {
            throw new IOException("BD0n");
        }
        int cursize = buffer.available();
        if (__i <= cursize) {
            return cursize;
        }
        int diff = __i - cursize;
        byte[] qq = new byte[diff];
        for (total = 0; total < diff && (rc = this.input.read(qq)) >= 0; total += rc) {
            buffer.addLast(qq, 0, rc);
        }
        return cursize + total;
    }

    @SquirrelJMEVendorApi
    public int peek(int __a) throws IndexOutOfBoundsException, IOException {
        if (__a < 0) {
            throw new IndexOutOfBoundsException(String.format("BD0o %d", __a));
        }
        ByteDeque buffer = this.buffer;
        if (this._closed) {
            throw new IOException("BD0p");
        }
        int avail = this.grab(__a + 1);
        if (avail < __a) {
            return -1;
        }
        throw Debugging.todo();
    }

    @SquirrelJMEVendorApi
    public int peek(int __a, byte[] __b) throws IndexOutOfBoundsException, IOException, NullPointerException {
        return this.peek(__a, __b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public int peek(int __a, byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__a < 0) {
            throw new IndexOutOfBoundsException(String.format("BD0q %d", __a));
        }
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __b.length;
        if (__o < 0 || __l < 0 || __o + __l > n2) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        ByteDeque buffer = this.buffer;
        if (this._closed) {
            throw new IOException("BD0r");
        }
        int avail = this.grab(__a + __l);
        if (avail < __a) {
            return -1;
        }
        int rc = Math.min(__l, avail);
        if (rc < 0) {
            return 0;
        }
        buffer.get(__a, __b, __o, rc);
        return rc;
    }

    @Override
    public int read() throws IOException {
        if (this._closed) {
            throw new IOException("BD0s");
        }
        int gc = this.grab(1);
        if (gc <= 0) {
            return -1;
        }
        return this.buffer.removeFirst() & 0xFF;
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __b.length;
        if (__o < 0 || __l < 0 || __o + __l > n2) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        ByteDeque buffer = this.buffer;
        if (this._closed) {
            throw new IOException("BI08");
        }
        int gc = this.grab(__l);
        if (gc <= 0) {
            return -1;
        }
        int dc2 = Math.min(gc, __l);
        if (dc2 <= 0) {
            return 0;
        }
        buffer.removeFirst(__b, __o, dc2);
        return dc2;
    }
}

