/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.multiphasicapps.io.DataEndianess;
import net.multiphasicapps.io.SettableEndianess;
import net.multiphasicapps.io.SizedStream;

@SquirrelJMEVendorApi
public class ExtendedDataInputStream
extends InputStream
implements DataInput,
SettableEndianess,
SizedStream {
    protected final DataInputStream input;
    @SquirrelJMEVendorApi
    protected final boolean canmark;
    private volatile DataEndianess _endian;
    private volatile long _count;
    private volatile long _markstart = -1L;
    private volatile long _markend = -1L;

    @SquirrelJMEVendorApi
    public ExtendedDataInputStream(InputStream __is) throws NullPointerException {
        this(__is, DataEndianess.BIG);
    }

    @SquirrelJMEVendorApi
    public ExtendedDataInputStream(InputStream __is, DataEndianess __endian) throws NullPointerException {
        if (__is == null || __endian == null) {
            throw new NullPointerException("NARG");
        }
        DataInputStream w2 = __is instanceof DataInputStream ? (DataInputStream)__is : new DataInputStream(__is);
        this.input = w2;
        this._endian = __endian;
        this.canmark = w2.markSupported();
    }

    @Override
    public int available() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public DataEndianess getEndianess() {
        return this._endian;
    }

    @Override
    public void mark(int __rl) {
        long count;
        if (__rl <= 0 || !this.canmark) {
            return;
        }
        this.input.mark(__rl);
        this._markstart = count = this._count;
        this._markend = count + (long)__rl;
    }

    @Override
    public boolean markSupported() {
        return this.canmark;
    }

    @Override
    public int read() throws IOException {
        int rv = this.input.read();
        if (rv >= 0) {
            ++this._count;
        }
        return rv;
    }

    @Override
    public int read(byte[] __b) throws IOException {
        throw Debugging.todo();
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws IOException {
        throw Debugging.todo();
    }

    @Override
    public boolean readBoolean() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public byte readByte() throws IOException {
        int rv = this.read();
        if (rv < 0) {
            throw new EOFException("BD0t");
        }
        return (byte)rv;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] __b) throws IOException {
        this.readFully(__b, 0, __b.length);
    }

    @Override
    public void readFully(byte[] __b, int __o, int __l) throws IOException {
        this.input.readFully(__b, __o, __l);
    }

    @Override
    public int readInt() throws IOException {
        int val2 = this.input.readInt();
        this._count += 4L;
        switch (this._endian) {
            case BIG: {
                return val2;
            }
            case LITTLE: {
                return Integer.reverseBytes(val2);
            }
        }
        throw Debugging.oops();
    }

    public String readLine() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public long readLong() throws IOException {
        long val2 = this.input.readLong();
        this._count += 8L;
        switch (this._endian) {
            case BIG: {
                return val2;
            }
            case LITTLE: {
                return Long.reverseBytes(val2);
            }
        }
        throw Debugging.oops();
    }

    @Override
    public short readShort() throws IOException {
        short val2 = this.input.readShort();
        this._count += 2L;
        switch (this._endian) {
            case BIG: {
                return val2;
            }
            case LITTLE: {
                return Short.reverseBytes(val2);
            }
        }
        throw Debugging.oops();
    }

    @SquirrelJMEVendorApi
    public int readThree() throws IOException {
        return ExtendedDataInputStream.__signExtendThree(this.readUnsignedThree());
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @SquirrelJMEVendorApi
    public int readUnsignedThree() throws IOException {
        DataInputStream in = this.input;
        int a2 = in.readUnsignedByte();
        int b2 = in.readUnsignedByte();
        int c2 = in.readUnsignedByte();
        switch (this._endian) {
            case LITTLE: {
                return a2 | b2 << 8 | c2 << 16;
            }
            case BIG: {
                return a2 << 16 | b2 << 8 | c2;
            }
        }
        throw Debugging.oops();
    }

    @Override
    public String readUTF() throws IOException {
        throw Debugging.todo();
    }

    @Override
    public void reset() throws IOException {
        long markstart = this._markstart;
        if (markstart < 0L) {
            throw new IOException("BD0u");
        }
        long count = this._count;
        long markend = this._markend;
        if (count > markend) {
            throw new IOException("BD0v");
        }
        this.input.reset();
        this._count = markstart;
    }

    @Override
    public DataEndianess setEndianess(DataEndianess __end) {
        if (__end == null) {
            throw new NullPointerException("NARG");
        }
        DataEndianess rv = this._endian;
        this._endian = __end;
        return rv;
    }

    @Override
    public long size() {
        return this._count;
    }

    @Override
    public long skip(long __n) throws IOException {
        throw Debugging.todo();
    }

    @Override
    public int skipBytes(int __n) throws IOException {
        DataInputStream in = this.input;
        for (int i2 = 0; i2 < __n; ++i2) {
            if (((InputStream)in).read() >= 0) continue;
            return i2;
        }
        return __n;
    }

    private static int __signExtendThree(int __v) {
        if ((__v & 0x800000) != 0) {
            return __v | 0xFF000000;
        }
        return __v;
    }
}

