/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.debug.ErrorCode;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.multiphasicapps.io.DataEndianess;
import net.multiphasicapps.io.SettableEndianess;
import net.multiphasicapps.io.SizedStream;

@SquirrelJMEVendorApi
public class ExtendedDataOutputStream
extends OutputStream
implements DataOutput,
SettableEndianess,
SizedStream {
    protected final DataOutputStream output;
    private volatile DataEndianess _endian = DataEndianess.BIG;
    private volatile long _size;

    @SquirrelJMEVendorApi
    public ExtendedDataOutputStream(OutputStream __os) throws NullPointerException {
        if (__os == null) {
            throw new NullPointerException("NARG");
        }
        this.output = __os instanceof DataOutputStream ? (DataOutputStream)__os : new DataOutputStream(__os);
    }

    @SquirrelJMEVendorApi
    public void align(int __n) throws IndexOutOfBoundsException, IOException {
        if (__n <= 0) {
            throw new IndexOutOfBoundsException(ErrorCode.__error__(1234));
        }
        while (this.size() % (long)__n != 0L) {
            this.write(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public final DataEndianess getEndianess() {
        return this._endian;
    }

    @Override
    public final DataEndianess setEndianess(DataEndianess __end) throws NullPointerException {
        if (__end == null) {
            throw new NullPointerException("NARG");
        }
        DataEndianess rv = this._endian;
        this._endian = __end;
        return rv;
    }

    @Override
    public final long size() {
        return this._size;
    }

    @Override
    public final void write(byte[] __b) throws IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        this.write(__b, 0, __b.length);
    }

    @Override
    public final void write(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __b.length;
        if (__o < 0 || __l < 0 || __o + __l > n2) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        this.output.write(__b, __o, __l);
        this._size += (long)__l;
    }

    @Override
    public final void write(int __b) throws IOException {
        this.output.write(__b);
        ++this._size;
    }

    @Override
    public final void writeBoolean(boolean __v) throws IOException {
        this.writeByte(__v ? 1 : 0);
    }

    @Override
    public final void writeByte(int __v) throws IOException {
        this.output.write(__v);
        ++this._size;
    }

    @SquirrelJMEVendorApi
    public final void writeByteExact(int __v) throws IOException {
        if (__v < -128 || __v > 127) {
            throw new IOException("BD0y");
        }
        this.writeByte(__v);
    }

    @Override
    public final void writeBytes(String __s) throws IOException {
        throw Debugging.todo();
    }

    @Override
    public final void writeChar(int __v) throws IOException {
        this.writeShort(__v);
    }

    @Override
    public final void writeChars(String __s) throws IOException, NullPointerException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __s.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeShort(__s.charAt(i2));
        }
    }

    @Override
    public final void writeDouble(double __v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(__v));
    }

    @Override
    public final void writeFloat(float __v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(__v));
    }

    @Override
    public final void writeInt(int __v) throws IOException {
        DataOutputStream output = this.output;
        DataEndianess endian = this._endian;
        switch (endian) {
            case BIG: {
                output.writeInt(__v);
                break;
            }
            case LITTLE: {
                output.writeInt(Integer.reverseBytes(__v));
                break;
            }
            default: {
                throw new IOException(String.format("BD04 %s", new Object[]{endian}));
            }
        }
        this._size += 4L;
    }

    @Override
    public final void writeLong(long __v) throws IOException {
        DataEndianess endian = this._endian;
        DataOutputStream output = this.output;
        switch (endian) {
            case BIG: {
                output.writeLong(__v);
                break;
            }
            case LITTLE: {
                output.writeLong(Long.reverseBytes(__v));
                break;
            }
            default: {
                throw new IOException(String.format("BD04 %s", new Object[]{endian}));
            }
        }
        this._size += 8L;
    }

    @Override
    public final void writeShort(int __v) throws IOException {
        DataEndianess endian = this._endian;
        DataOutputStream output = this.output;
        switch (endian) {
            case BIG: {
                output.writeShort(__v);
                break;
            }
            case LITTLE: {
                output.writeShort(Short.reverseBytes((short)__v));
                break;
            }
            default: {
                throw new IOException(String.format("BD04 %s", new Object[]{endian}));
            }
        }
        this._size += 2L;
    }

    @SquirrelJMEVendorApi
    public final void writeShortExact(int __v) throws IOException {
        if (__v < Short.MIN_VALUE || __v > Short.MAX_VALUE) {
            throw new IOException("BD0z");
        }
        this.writeShort(__v);
    }

    @SquirrelJMEVendorApi
    public final void writeUnsignedByteExact(int __v) throws IOException {
        if (__v < 0 || __v > 255) {
            throw new IOException("BD10");
        }
        this.writeByte(__v);
    }

    @SquirrelJMEVendorApi
    public final void writeUnsignedShortExact(int __v) throws IOException {
        if (__v < 0 || __v > 65535) {
            throw new IOException("BD11");
        }
        this.writeShort(__v);
    }

    @Override
    public final void writeUTF(String __s) throws IOException {
        throw Debugging.todo();
    }
}

