/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.jvm.mle.ObjectShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.IOException;
import java.util.NoSuchElementException;
import net.multiphasicapps.io.BitSource;

@SquirrelJMEVendorApi
public class HuffmanTreeInt {
    private volatile int[] _table;
    private volatile int[] _values;
    private volatile int _modcount;
    private volatile int _maxbits;

    @SquirrelJMEVendorApi
    public HuffmanTreeInt() {
        this.__addTableSpace();
    }

    @SquirrelJMEVendorApi
    public final int add(int __v, int __sym, int __mask) throws IllegalArgumentException {
        int ibm = Integer.bitCount(__mask);
        if ((__sym & ~__mask) != 0) {
            throw new IllegalArgumentException(String.format("BD13 %x %x", __sym, __mask));
        }
        if (ibm != 32 - Integer.numberOfLeadingZeros(__mask) || (__mask & 1) == 0) {
            throw new IllegalArgumentException(String.format("BD14 %x %x", __sym, __mask));
        }
        int[] table = this._table;
        int n2 = table.length;
        this._maxbits = Math.max(this._maxbits, ibm);
        int at2 = 0;
        for (int sh = 1 << ibm - 1; sh != 0; sh >>>= 1) {
            int vat;
            boolean last = sh == 1;
            int q2 = (__sym & sh) != 0 ? 1 : 0;
            int jump = table[at2 + q2];
            if (!last && jump < 0) {
                table[at2 + q2] = jump = Integer.MAX_VALUE;
            }
            if (jump == Integer.MAX_VALUE) {
                if (last) {
                    vat = this.__addValueSpace();
                    this._values[vat] = __v;
                    table[at2 + q2] = -(vat + 1);
                    ++this._modcount;
                    return 0;
                }
                int jat = this.__addTableSpace();
                table = this._table;
                n2 = table.length;
                table[at2 + q2] = at2 = jat;
                continue;
            }
            if (jump < 0) {
                vat = -jump - 1;
                int[] vals = this._values;
                int old = vals[vat];
                vals[vat] = __v;
                ++this._modcount;
                return old;
            }
            at2 = jump;
        }
        throw Debugging.oops();
    }

    @SquirrelJMEVendorApi
    public void clear() {
        this._table = null;
        this._values = null;
        this._modcount = 0;
        this._maxbits = 0;
        this.__addTableSpace();
    }

    @SquirrelJMEVendorApi
    public final long findSequence(int __i) throws NoSuchElementException {
        int[] vals = this._values;
        if (vals == null) {
            throw new NoSuchElementException("NSEE");
        }
        int n2 = vals.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (vals[i2] != __i) continue;
            return this.__recursiveMatch(0, 0, 0, -(i2 + 1));
        }
        throw new NoSuchElementException("NSEE");
    }

    @SquirrelJMEVendorApi
    public final int getValue(BitSource __bs) throws IOException, NoSuchElementException, NullPointerException {
        if (__bs == null) {
            throw new NullPointerException("NARG");
        }
        int[] table = this._table;
        if (table == null) {
            throw new NoSuchElementException("NSEE");
        }
        int at2 = 0;
        while (at2 >= 0) {
            if (at2 == Integer.MAX_VALUE) {
                throw new NoSuchElementException("BD15");
            }
            at2 = table[at2 + (__bs.nextBit() ? 1 : 0)];
        }
        return this._values[-at2 - 1];
    }

    @SquirrelJMEVendorApi
    public final int maximumBits() {
        return this._maxbits;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("[");
        int[] vals = this._values;
        if (vals != null) {
            int n2 = vals.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append('<');
                int v2 = vals[i2];
                int seq = -1;
                if ((long)seq == -1L) {
                    sb.append('?');
                } else {
                    int msk = seq >>> 32;
                    int val2 = seq;
                    int hib = Integer.bitCount(msk);
                    for (int b2 = hib - 1; b2 >= 0; --b2) {
                        sb.append(0 == (val2 & 1 << b2) ? (char)'0' : '1');
                    }
                }
                sb.append(">=");
                sb.append(v2);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private int __addTableSpace() {
        int[] table = this._table;
        int rv = table == null ? 0 : table.length;
        int[] becomes = new int[rv + 2];
        if (table != null) {
            ObjectShelf.arrayCopy(table, 0, becomes, 0, rv);
        }
        becomes[rv] = Integer.MAX_VALUE;
        becomes[rv + 1] = Integer.MAX_VALUE;
        this._table = becomes;
        return rv;
    }

    private int __addValueSpace() {
        int[] values = this._values;
        int rv = values == null ? 0 : values.length;
        int[] becomes = new int[rv + 1];
        if (values != null) {
            ObjectShelf.arrayCopy(values, 0, becomes, 0, rv);
        }
        this._values = becomes;
        return rv;
    }

    private long __recursiveMatch(int __at, int __huf, int __mask, int __match) {
        long rv;
        boolean left;
        int[] table = this._table;
        int jl = table[__at];
        int jr = table[__at + 1];
        boolean bl2 = left = jl == __match;
        if (left || jr == __match) {
            return (long)(__mask << 1 | 1) << 32 | (long)(__huf << 1 | (left ? 0 : 1));
        }
        if (jl >= 0 && jl != Integer.MAX_VALUE && (rv = this.__recursiveMatch(jl, __huf << 1, __mask << 1 | 1, __match)) != -1L) {
            return rv;
        }
        if (jr >= 0 && jr != Integer.MAX_VALUE && (rv = this.__recursiveMatch(jr, __huf << 1 | 1, __mask << 1 | 1, __match)) != 1L) {
            return rv;
        }
        return -1L;
    }
}

