/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.multiphasicapps.io.BitSource;
import net.multiphasicapps.io.ByteDeque;
import net.multiphasicapps.io.Checksum;
import net.multiphasicapps.io.DecompressionInputStream;
import net.multiphasicapps.io.HuffmanTreeInt;
import net.multiphasicapps.io.SlidingByteWindow;

@SquirrelJMEVendorApi
public class InflaterInputStream
extends DecompressionInputStream {
    private static final int _DEFAULT_SLIDING_WINDOW_SIZE = 32768;
    static final byte _TYPE_NO_COMPRESSION = 0;
    static final byte _TYPE_FIXED_HUFFMAN = 1;
    static final byte _TYPE_DYNAMIC_HUFFMAN = 2;
    static final byte _TYPE_ERROR = 3;
    private static final byte _MAX_BITS = 15;
    private static final byte[] _SHUFFLE_BITS = new byte[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    @SquirrelJMEVendorApi
    protected final InputStream in;
    @SquirrelJMEVendorApi
    protected final SlidingByteWindow window;
    @SquirrelJMEVendorApi
    protected final ByteDeque overflow = new ByteDeque();
    @SquirrelJMEVendorApi
    protected final Checksum checksum;
    private final byte[] _solo = new byte[1];
    private final byte[] _readin = new byte[4];
    private final BitSource _bitsource = new __BitSource__();
    private final int[] _rawcodelens = new int[19];
    private final int[] _rawlitdistlens = new int[322];
    private final int[] _blcount = new int[16];
    private final int[] _nextcode = new int[16];
    private long _compressedsize;
    private long _uncompressedsize;
    private Reference<HuffmanTreeInt> _codelentree;
    private Reference<HuffmanTreeInt> _literaltree;
    private Reference<HuffmanTreeInt> _distancetree;
    private Reference<byte[]> _readwindow;
    private int _miniwindow;
    private int _minisize;
    private int _writewindow;
    private int _writesize;
    private boolean _eof;
    private byte[] _targ;
    private int _targoff;
    private int _targend;

    @SquirrelJMEVendorApi
    public InflaterInputStream(InputStream __in) throws NullPointerException {
        this(__in, 32768);
    }

    @SquirrelJMEVendorApi
    public InflaterInputStream(InputStream __in, Checksum __cs) throws NullPointerException {
        this(__in, 32768, __cs);
    }

    @SquirrelJMEVendorApi
    public InflaterInputStream(InputStream __in, int __sls) {
        this(__in, __sls, null);
    }

    @SquirrelJMEVendorApi
    public InflaterInputStream(InputStream __in, int __sls, Checksum __checksum) {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        this.in = __in;
        this.window = new SlidingByteWindow(__sls);
        this.checksum = __checksum;
    }

    @Override
    public int available() throws IOException {
        return this.overflow.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long compressedBytes() {
        return this._compressedsize;
    }

    @Override
    public boolean detectsEOF() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int rv;
        byte[] solo = this._solo;
        do {
            if ((rv = this.read(solo, 0, 1)) >= 0) continue;
            return rv;
        } while (rv == 0);
        return solo[0] & 0xFF;
    }

    @Override
    public int read(byte[] __b) throws IOException, NullPointerException {
        return this.read(__b, 0, __b.length);
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws ArrayIndexOutOfBoundsException, IOException, NullPointerException {
        Checksum checksum;
        int c2;
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        int bl2 = __b.length;
        if (__o < 0 || __l < 0 || __o + __l > bl2) {
            throw new ArrayIndexOutOfBoundsException("AIOB");
        }
        ByteDeque overflow = this.overflow;
        int ovn = overflow.available();
        int ovr = Math.min(ovn, __l);
        boolean eof = this._eof;
        if (!eof && c2 < __l) {
            int rv;
            this._targ = __b;
            for (c2 = overflow.removeFirst(__b, __o, __l); c2 < __l; c2 += rv) {
                int base;
                this._targoff = base = __o + c2;
                this._targend = base + (__l - c2);
                rv = this.__decompress();
                if (rv >= 0) continue;
                this._eof = true;
                break;
            }
        }
        if ((checksum = this.checksum) != null) {
            checksum.offer(__b, __o, c2);
        }
        if (c2 > 0) {
            this._uncompressedsize += (long)c2;
        }
        return c2 == 0 && eof && overflow.isEmpty() ? -1 : c2;
    }

    @Override
    public long uncompressedBytes() {
        return this._uncompressedsize;
    }

    private int __decompress() throws IOException {
        if (this._eof) {
            return -1;
        }
        int enteroff = this._targoff;
        int finalhit = this.__readBits(1, false);
        int type = this.__readBits(2, false);
        switch (type) {
            case 0: {
                this.__decompressNone();
                break;
            }
            case 1: {
                this.__decompressFixed();
                break;
            }
            case 2: {
                this.__decompressDynamic();
                break;
            }
            default: {
                throw new IOException(String.format("BD17 %d", type));
            }
        }
        int rv = this._targoff - enteroff;
        if (finalhit != 0) {
            this._eof = true;
            return rv == 0 ? -1 : rv;
        }
        return rv;
    }

    private void __decompressDynamic() throws IOException {
        int code;
        int dhlit = this.__readBits(5, false) + 257;
        int dhdist = this.__readBits(5, false) + 1;
        int dhclen = this.__readBits(4, false) + 4;
        HuffmanTreeInt codelentree = this.__decompressDynamicLoadLenTree(dhclen);
        HuffmanTreeInt literaltree = this.__obtainLiteralTree();
        HuffmanTreeInt distancetree = this.__obtainDistanceTree();
        this.__decompressDynamicLoadLitDistTree(codelentree, dhlit, dhdist, literaltree, distancetree);
        while (true) {
            if ((code = literaltree.getValue(this._bitsource)) >= 0 && code <= 255) {
                this.__write(code, 8, false);
                continue;
            }
            if (code == 256) {
                return;
            }
            if (code < 257 || code > 285) break;
            this.__decompressWindow(this.__handleLength(code), distancetree.getValue(this._bitsource));
        }
        throw new IOException(String.format("BD18 %d", code));
    }

    private void __decompressDynamicLoadLitDistTree(HuffmanTreeInt __cltree, int __dhlit, int __dhdist, HuffmanTreeInt __ltree, HuffmanTreeInt __dtree) throws IOException {
        int total = __dhlit + __dhdist;
        int[] rawlitdistlens = this._rawlitdistlens;
        Arrays.fill(rawlitdistlens, 0);
        try {
            for (int next = 0; next < total; next += this.__readCodeBits(__cltree, rawlitdistlens, next)) {
            }
        }
        catch (NoSuchElementException e2) {
            throw new IOException("BD19", e2);
        }
        this.__thunkCodeLengthTree(__ltree, rawlitdistlens, 0, __dhlit);
        this.__thunkCodeLengthTree(__dtree, rawlitdistlens, __dhlit, __dhdist);
    }

    private HuffmanTreeInt __decompressDynamicLoadLenTree(int __dhclen) throws IOException {
        HuffmanTreeInt codelentree = this.__obtainCodeLenTree();
        if (__dhclen > 19) {
            throw new IOException(String.format("BD1a %d", __dhclen));
        }
        int[] rawcodelens = this._rawcodelens;
        Arrays.fill(rawcodelens, 0);
        byte[] hsbits = _SHUFFLE_BITS;
        for (int next = 0; next < __dhclen; ++next) {
            rawcodelens[hsbits[next]] = this.__readBits(3, false);
        }
        return this.__thunkCodeLengthTree(codelentree, rawcodelens, 0, rawcodelens.length);
    }

    private void __decompressFixed() throws IOException {
        int code;
        while (true) {
            if ((code = this.__readFixedHuffman()) >= 0 && code <= 255) {
                this.__write(code, 8, false);
                continue;
            }
            if (code == 256) {
                return;
            }
            if (code < 257 || code > 285) break;
            this.__decompressWindow(this.__handleLength(code), Integer.MIN_VALUE);
        }
        throw new IOException(String.format("BD1b %d", code));
    }

    private void __decompressNone() throws IOException {
        int com;
        int len;
        int minisub = this._minisize & 7;
        if (minisub > 0) {
            this.__readBits(minisub, false);
        }
        if (((len = this.__readBits(16, false)) ^ 0xFFFF) != (com = this.__readBits(16, false))) {
            throw new IOException(String.format("BD1c %04x %04x %04x %04x", len, com, len ^ 0xFFFF, com ^ 0xFFFF));
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this.__write(this.__readBits(8, false), 8, false);
        }
    }

    private void __decompressWindow(int __len, int __dist) throws IOException {
        __dist = this.__handleDistance(__dist);
        int maxlen = Math.min(__dist, __len);
        byte[] winb = new byte[maxlen];
        try {
            this.window.get(__dist, winb, 0, maxlen);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IOException(String.format("BD1d %d %d", __dist, __len), ioobe);
        }
        int v2 = 0;
        for (int i2 = 0; i2 < __len; ++i2) {
            this.__write(winb[v2], 8, false);
            if (++v2 < maxlen) continue;
            v2 = 0;
        }
    }

    private int __handleDistance(int __code) throws IOException {
        if (__code == Integer.MIN_VALUE) {
            __code = this.__readBits(5, true);
        }
        if (__code > 29) {
            throw new IOException(String.format("BD1e %d", __code));
        }
        int rv = 1;
        for (int i2 = 0; i2 < __code; ++i2) {
            int v2 = i2 / 2 - 1;
            if (v2 >= 0) {
                rv += 1 << v2;
                continue;
            }
            ++rv;
        }
        int extrabits = __code / 2 - 1;
        if (extrabits > 0) {
            rv += this.__readBits(extrabits, false);
        }
        return rv;
    }

    private int __handleLength(int __c) throws IOException {
        if (__c == 285) {
            return 258;
        }
        int base = __c - 257;
        if (base < 0) {
            throw new IOException(String.format("BD1f %d", __c));
        }
        int rv = 3;
        for (int i2 = 0; i2 < base; ++i2) {
            int v2 = i2 / 4 - 1;
            if (v2 > 0) {
                rv += 1 << v2;
                continue;
            }
            ++rv;
        }
        int extrabits = base / 4 - 1;
        if (extrabits > 0) {
            extrabits = this.__readBits(extrabits, false);
            rv += extrabits;
        }
        return rv;
    }

    private HuffmanTreeInt __obtainCodeLenTree() {
        HuffmanTreeInt rv;
        Reference<HuffmanTreeInt> ref = this._codelentree;
        if (ref == null || null == (rv = ref.get())) {
            rv = new HuffmanTreeInt();
            this._codelentree = new WeakReference<HuffmanTreeInt>(rv);
        }
        rv.clear();
        return rv;
    }

    private HuffmanTreeInt __obtainDistanceTree() {
        HuffmanTreeInt rv;
        Reference<HuffmanTreeInt> ref = this._distancetree;
        if (ref == null || null == (rv = ref.get())) {
            rv = new HuffmanTreeInt();
            this._distancetree = new WeakReference<HuffmanTreeInt>(rv);
        }
        rv.clear();
        return rv;
    }

    private HuffmanTreeInt __obtainLiteralTree() {
        HuffmanTreeInt rv;
        Reference<HuffmanTreeInt> ref = this._literaltree;
        if (ref == null || null == (rv = ref.get())) {
            rv = new HuffmanTreeInt();
            this._literaltree = new WeakReference<HuffmanTreeInt>(rv);
        }
        rv.clear();
        return rv;
    }

    private byte[] __obtainReadWindow() {
        byte[] rv;
        Reference<byte[]> ref = this._readwindow;
        if (ref == null || null == (rv = ref.get())) {
            rv = new byte[128];
            this._readwindow = new WeakReference<byte[]>(rv);
        }
        return rv;
    }

    int __readBits(int __n, boolean __msb) throws IOException {
        if (__n == 0) {
            return 0;
        }
        int miniwindow = this._miniwindow;
        int minisize = this._minisize;
        while (minisize < __n) {
            byte[] readin;
            int rc;
            int bc2 = (__n - minisize) / 8;
            if (bc2 == 0) {
                bc2 = 1;
            }
            if ((rc = this.in.read(readin = this._readin, 0, bc2)) < 0) {
                throw new IOException(String.format("BD1g %d %d", minisize, __n));
            }
            for (int i2 = 0; i2 < rc; ++i2) {
                miniwindow |= (readin[i2] & 0xFF) << minisize;
                minisize += 8;
            }
            this._compressedsize += (long)rc;
        }
        int rv = miniwindow & (1 << __n) - 1;
        this._miniwindow = miniwindow >>>= __n;
        this._minisize = minisize -= __n;
        if (__msb) {
            return Integer.reverse(rv) >>> 32 - __n;
        }
        return rv;
    }

    private int __readCodeBits(HuffmanTreeInt __codes, int[] __out, int __next) throws IOException, NullPointerException {
        if (__codes == null || __out == null) {
            throw new NullPointerException("NARG");
        }
        int basenext = __next;
        int code = __codes.getValue(this._bitsource);
        if (code >= 0 && code < 16) {
            __out[__next++] = code;
        } else {
            int repfor;
            int repval;
            if (code == 16) {
                int lastlendx = __next - 1;
                if (lastlendx < 0) {
                    throw new IOException(String.format("BD1h %d", lastlendx));
                }
                repval = __out[lastlendx];
                repfor = 3 + this.__readBits(2, false);
            } else if (code == 17) {
                repval = 0;
                repfor = 3 + this.__readBits(3, false);
            } else if (code == 18) {
                repval = 0;
                repfor = 11 + this.__readBits(7, false);
            } else {
                throw new IOException(String.format("BD1i %d", code));
            }
            try {
                for (int i2 = 0; i2 < repfor; ++i2) {
                    __out[__next++] = repval;
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new IOException("BD1j", ioobe);
            }
        }
        return __next - basenext;
    }

    private int __readFixedHuffman() throws IOException {
        if (this.__readBits(1, true) != 0) {
            if (this.__readBits(1, true) != 0) {
                if (this.__readBits(1, true) != 0) {
                    return 192 + this.__readBits(6, true);
                }
                if (this.__readBits(1, true) != 0) {
                    return 160 + this.__readBits(5, true);
                }
                if (this.__readBits(1, true) != 0) {
                    return 144 + this.__readBits(4, true);
                }
                return 280 + this.__readBits(3, true);
            }
            return 80 + this.__readBits(6, true);
        }
        if (this.__readBits(1, true) != 0) {
            return 16 + this.__readBits(6, true);
        }
        if (this.__readBits(1, true) != 0) {
            if (this.__readBits(1, true) != 0) {
                return 0 + this.__readBits(4, true);
            }
            return 272 + this.__readBits(3, true);
        }
        return 256 + this.__readBits(4, true);
    }

    private HuffmanTreeInt __thunkCodeLengthTree(HuffmanTreeInt __tree, int[] __lens, int __o, int __l) throws NullPointerException {
        if (__lens == null) {
            throw new NullPointerException("NARG");
        }
        int[] bl_count = this._blcount;
        int[] next_code = this._nextcode;
        Arrays.fill(bl_count, 0);
        Arrays.fill(next_code, 0);
        int i2 = 0;
        int p2 = __o;
        while (i2 < __l) {
            int n2 = __lens[p2];
            bl_count[n2] = bl_count[n2] + 1;
            ++i2;
            ++p2;
        }
        bl_count[0] = 0;
        int code = 0;
        for (int bits = 1; bits <= 15; ++bits) {
            next_code[bits] = code = code + bl_count[bits - 1] << 1;
        }
        __tree.clear();
        int q2 = 0;
        int p3 = __o;
        while (q2 < __l) {
            int len = __lens[p3];
            if (len != 0) {
                int n3 = len;
                int n4 = next_code[n3];
                next_code[n3] = n4 + 1;
                __tree.add(q2, n4, (1 << len) - 1);
            }
            ++q2;
            ++p3;
        }
        return __tree;
    }

    private void __write(int __v, int __bits, boolean __msb) throws IOException {
        int mask = (1 << __bits) - 1;
        __v &= mask;
        if (__msb) {
            __v = Integer.reverse(__v) >>> 32 - __bits;
        }
        int writewindow = this._writewindow;
        int writesize = this._writesize;
        writewindow |= (__v & mask) << writesize;
        if ((writesize += __bits) >= 8) {
            byte[] targ = this._targ;
            int targoff = this._targoff;
            int targend = this._targend;
            ByteDeque overflow = this.overflow;
            SlidingByteWindow window = this.window;
            do {
                byte b2 = (byte)writewindow;
                writewindow >>>= 8;
                writesize -= 8;
                if (targoff < targend) {
                    targ[targoff++] = b2;
                } else {
                    overflow.offerLast(b2);
                }
                window.append(b2);
            } while (writesize >= 8);
            this._targoff = targoff;
        }
        this._writewindow = writewindow;
        this._writesize = writesize;
    }

    private final class __BitSource__
    implements BitSource {
        private __BitSource__() {
        }

        @Override
        public boolean nextBit() throws IOException {
            return 0 != InflaterInputStream.this.__readBits(1, true);
        }
    }
}

