/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineColumnReader
extends BufferedReader {
    public static final int DEFAULT = Integer.MIN_VALUE;
    private static final int _DEFAULT_TAB_SIZE = 8;
    protected int column;
    protected int line;
    protected int tabsize;
    private int _mkdcol = -1;

    public LineColumnReader(Reader __r) {
        this(__r, Integer.MIN_VALUE);
    }

    public LineColumnReader(Reader __r, int __ts) {
        super(__r);
        this.setTabSize(__ts);
    }

    public LineColumnReader(Reader __r, int __ts, int __sz) {
        super(__r, __sz);
        this.setTabSize(__ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.tabsize < 0) {
                return;
            }
            this.tabsize = -1;
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnNumber() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tabsize < 0) {
                throw new IllegalStateException("Stream has been closed.");
            }
            return this.column;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tabsize < 0) {
                throw new IllegalStateException("CLOS");
            }
            return this.line;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTabSize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.tabsize < 0) {
                throw new IllegalStateException("Stream has been closed.");
            }
            return this.tabsize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int __ral) throws IOException {
        if (__ral < 0) {
            throw new IllegalArgumentException(String.format("Negative read-ahead of %1$d.", __ral));
        }
        Object object = this.lock;
        synchronized (object) {
            this._mkdcol = this.column;
            super.mark(__ral);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] __b, int __o, int __l) throws IOException {
        if (__b == null) {
            throw new NullPointerException("Null arguments");
        }
        if (__o < 0 || __l < 0 || __o + __l > __b.length) {
            throw new IllegalArgumentException("Invalid offset or length.");
        }
        Object object = this.lock;
        synchronized (object) {
            int i2;
            if (this.tabsize < 0) {
                throw new IllegalStateException("Stream has been closed.");
            }
            char[] nb = new char[__l];
            int rc = super.read(nb, 0, nb.length);
            if (rc <= 0) {
                return rc;
            }
            for (i2 = 0; i2 < rc; ++i2) {
                char c2 = nb[i2];
                if (c2 == '\t') {
                    this.column = this.column - this.column % this.tabsize + this.tabsize;
                    continue;
                }
                if (c2 == '\n') {
                    this.column = 0;
                    ++this.line;
                    continue;
                }
                ++this.column;
            }
            for (i2 = 0; i2 < rc; ++i2) {
                __b[__o + i2] = nb[i2];
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] b2 = new char[1];
            if (this.read(b2, 0, 1) == 1) {
                return b2[0];
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this._mkdcol < 0) {
                throw new IOException("Stream was never marked.");
            }
            this.column = this._mkdcol;
            super.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnNumber(int __cn) {
        if (__cn < 0) {
            throw new IllegalArgumentException(String.format("Negative column number %1$d.", __cn));
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.tabsize < 0) {
                throw new IllegalStateException("Stream has been closed.");
            }
            this.column = __cn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabSize(int __ts) {
        if (__ts <= 0 && __ts != Integer.MIN_VALUE) {
            throw new IllegalArgumentException(String.format("Zero or negative tab size (%1$d).", __ts));
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.tabsize < 0) {
                return;
            }
            if (__ts != Integer.MIN_VALUE) {
                this.tabsize = __ts;
            } else {
                try {
                    String swts = System.getProperty("tab.size");
                    this.tabsize = swts == null ? 8 : Integer.parseInt(swts, 10);
                }
                catch (NumberFormatException | SecurityException e2) {
                    this.tabsize = 8;
                }
            }
        }
    }
}

