/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import net.multiphasicapps.io.Base64Decoder;

@SquirrelJMEVendorApi
public final class MIMEFileDecoder
extends InputStream {
    @SquirrelJMEVendorApi
    protected Base64Decoder mime;
    private int _mode = Integer.MIN_VALUE;
    private String _filename;

    @SquirrelJMEVendorApi
    public MIMEFileDecoder(InputStream __in) throws NullPointerException {
        this(new InputStreamReader(__in));
    }

    @SquirrelJMEVendorApi
    public MIMEFileDecoder(InputStream __in, String __enc) throws NullPointerException, UnsupportedEncodingException {
        this(new InputStreamReader(__in, __enc));
    }

    @SquirrelJMEVendorApi
    public MIMEFileDecoder(Reader __in) throws NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        this.mime = new Base64Decoder(new __SubReader__(__in));
    }

    @Override
    public final int available() throws IOException {
        return this.mime.available();
    }

    @Override
    public final void close() throws IOException {
        this.mime.close();
    }

    @SquirrelJMEVendorApi
    public final String filename() {
        return this._filename;
    }

    @SquirrelJMEVendorApi
    public final int mode() {
        return this._mode;
    }

    @Override
    public final int read() throws IOException {
        return this.mime.read();
    }

    @Override
    public final int read(byte[] __b) throws IOException {
        return this.mime.read(__b);
    }

    @Override
    public final int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        return this.mime.read(__b, __o, __l);
    }

    private final class __SubReader__
    extends Reader {
        protected final BufferedReader in;
        private final StringBuilder _sb = new StringBuilder(80);
        private int _at;
        private int _limit;
        private boolean _didheader;
        private boolean _didfooter;

        __SubReader__(Reader __in) throws NullPointerException {
            if (__in == null) {
                throw new NullPointerException("NARG");
            }
            this.in = new BufferedReader(__in, 80);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int read() throws IOException {
            if (!this._didheader) {
                this.__readHeader();
            }
            if (this._didfooter) {
                return -1;
            }
            int at2 = this._at;
            int limit = this._limit;
            if (at2 >= limit) {
                if (!this.__readNext()) {
                    return -1;
                }
                at2 = this._at;
                limit = this._limit;
            }
            char rv = this._sb.charAt(at2);
            this._at = at2 + 1;
            return rv;
        }

        @Override
        public int read(char[] __c) throws IOException {
            if (__c == null) {
                throw new NullPointerException("NARG");
            }
            return this.read(__c, 0, __c.length);
        }

        @Override
        public int read(char[] __c, int __o, int __l) throws IOException {
            if (__c == null) {
                throw new NullPointerException("NARG");
            }
            if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __c.length) {
                throw new IndexOutOfBoundsException("IOOB");
            }
            if (!this._didheader) {
                this.__readHeader();
            }
            if (this._didfooter) {
                return -1;
            }
            StringBuilder sb = this._sb;
            int at2 = this._at;
            int limit = this._limit;
            int rv = 0;
            while (rv < __l) {
                if (at2 >= limit) {
                    if (!this.__readNext()) {
                        return rv == 0 ? -1 : rv;
                    }
                    at2 = this._at;
                    limit = this._limit;
                }
                __c[__o++] = sb.charAt(at2++);
            }
            this._at = at2;
            return rv;
        }

        private void __readHeader() throws IOException {
            BufferedReader in = this.in;
            String ln = in.readLine();
            if (ln == null) {
                throw new IOException("BD1k");
            }
            if (!ln.startsWith("begin-base64")) {
                throw new IOException("BD1l");
            }
            int fs = ln.indexOf(32);
            if (fs >= 0) {
                int ss = ln.indexOf(32, fs + 1);
                MIMEFileDecoder.this._mode = Integer.parseInt(ln.substring(fs + 1, ss < 0 ? ln.length() : ss), 8);
                if (ss >= 0) {
                    MIMEFileDecoder.this._filename = ln.substring(ss + 1);
                }
            }
            this._didheader = true;
        }

        private boolean __readNext() throws IOException {
            String ln = this.in.readLine();
            if (ln == null) {
                throw new IOException("BD1m");
            }
            if (ln.equals("====")) {
                this._didfooter = true;
                return false;
            }
            StringBuilder sb = this._sb;
            sb.setLength(0);
            sb.append(ln);
            this._at = 0;
            this._limit = ln.length();
            return true;
        }
    }
}

