/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.IOException;
import java.io.InputStream;

@SquirrelJMEVendorApi
public class SizeLimitedInputStream
extends InputStream {
    @SquirrelJMEVendorApi
    protected final InputStream wrapped;
    @SquirrelJMEVendorApi
    protected final boolean exact;
    @SquirrelJMEVendorApi
    protected final long limit;
    @SquirrelJMEVendorApi
    protected final boolean propagate;
    @SquirrelJMEVendorApi
    private volatile long _current;
    @SquirrelJMEVendorApi
    private volatile boolean _closed;

    @SquirrelJMEVendorApi
    public SizeLimitedInputStream(InputStream __is, long __li, boolean __ex) throws IllegalArgumentException, NullPointerException {
        this(__is, __li, __ex, true);
    }

    @SquirrelJMEVendorApi
    public SizeLimitedInputStream(InputStream __is, long __li, boolean __ex, boolean __prop) throws IllegalArgumentException, NullPointerException {
        if (__is == null) {
            throw new NullPointerException("NARG");
        }
        if (__li < 0L) {
            throw new IllegalArgumentException(String.format("BD1o %d", __li));
        }
        this.wrapped = __is;
        this.limit = __li;
        this.exact = __ex;
        this.propagate = __prop;
    }

    @Override
    public int available() throws IOException {
        long wav = this.wrapped.available();
        return (int)Math.min(Integer.MAX_VALUE, Math.min(wav, this.limit - this._current));
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            if (this.exact) {
                long at2;
                long limit = this.limit;
                while ((at2 = this._current) < limit) {
                    if (this.read() >= 0) continue;
                    throw new IOException(String.format("BD1p %d %d", at2, limit));
                }
            }
        }
        if (this.propagate) {
            this.wrapped.close();
        }
    }

    @Override
    public int read() throws IOException {
        long cur = this._current;
        long limit = this.limit;
        if (cur >= limit) {
            return -1;
        }
        int next = this.wrapped.read();
        if (next < 0) {
            if (this.exact && cur != limit) {
                throw new IOException(String.format("BD1q %d %d", limit, cur));
            }
            return next;
        }
        this._current = cur + 1L;
        return next;
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        long current = this._current;
        long limit = this.limit;
        if (current >= limit) {
            if (this.exact && current != limit) {
                throw new IOException(String.format("BD1r %d %d", limit, current));
            }
            return -1;
        }
        InputStream wrapped = this.wrapped;
        int cc2 = (int)Math.min(limit - current, (long)__l);
        int rc = wrapped.read(__b, __o, cc2);
        if (rc < 0) {
            if (this.exact && current != limit) {
                throw new IOException(String.format("BD1s %d %d", limit, current));
            }
            return -1;
        }
        this._current = current + (long)rc;
        return rc;
    }
}

