/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import net.multiphasicapps.io.ByteDeque;

@SquirrelJMEVendorApi
public class SlidingByteWindow {
    @SquirrelJMEVendorApi
    protected final ByteDeque deque;
    @SquirrelJMEVendorApi
    protected final int windowsize;
    private final byte[] _solo = new byte[1];
    private volatile int _total;

    @SquirrelJMEVendorApi
    public SlidingByteWindow(int __wsz) throws IllegalArgumentException {
        if (__wsz <= 0) {
            throw new IllegalArgumentException(String.format("BD1t %d", __wsz));
        }
        this.windowsize = __wsz;
        this.deque = new ByteDeque(__wsz);
    }

    @SquirrelJMEVendorApi
    public void append(byte __b) {
        byte[] solo = this._solo;
        solo[0] = __b;
        this.append(solo, 0, 1);
    }

    @SquirrelJMEVendorApi
    public void append(byte[] __b) throws NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        this.append(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public void append(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        ByteDeque deque = this.deque;
        int windowsize = this.windowsize;
        int total = this._total;
        int newtotal = total + __l;
        int overflow = 0;
        if (newtotal < 0 || newtotal > windowsize) {
            overflow = newtotal - windowsize;
            newtotal = windowsize;
        }
        if (overflow > 0) {
            deque.deleteFirst(overflow);
        }
        deque.addLast(__b, __o, __l);
        this._total = newtotal;
    }

    @SquirrelJMEVendorApi
    public byte get(int __ago) throws IndexOutOfBoundsException {
        byte[] solo = this._solo;
        this.get(__ago, solo, 0, 1);
        return solo[0];
    }

    @SquirrelJMEVendorApi
    public void get(int __ago, byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        int windowsize = this.windowsize;
        int total = this._total;
        if (__ago <= 0 || total - __ago + __l > total) {
            throw new IndexOutOfBoundsException(String.format("BD1u %d %d %d", __ago, __l, total));
        }
        int rv = this.deque.get(total - __ago, __b, __o, __l);
        if (rv != __l) {
            throw new IndexOutOfBoundsException(String.format("BD1v %d %d", __l, rv));
        }
    }

    @SquirrelJMEVendorApi
    public int size() {
        return this._total;
    }
}

