/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.io;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.multiphasicapps.io.Adler32Calculator;
import net.multiphasicapps.io.DecompressionInputStream;
import net.multiphasicapps.io.InflaterInputStream;

@SquirrelJMEVendorApi
public class ZLibDecompressor
extends DecompressionInputStream {
    private static final int _CMF_COMPRESSION_METHOD_MASK = 15;
    private static final int _CMF_COMPRESSION_INFO_MASK = 240;
    private static final int _CMF_COMPRESSION_INFO_SHIFT = 4;
    private static final int _CMF_METHOD_DEFLATE = 8;
    private static final int _FLAG_PRESET_DICTIONARY = 32;
    protected final DataInputStream in;
    private final byte[] _solo = new byte[1];
    private final Adler32Calculator _checksum = new Adler32Calculator();
    private volatile DecompressionInputStream _current;
    private volatile boolean _eof;
    private volatile long _uncomp;
    private volatile long _basecomp;

    @SquirrelJMEVendorApi
    public ZLibDecompressor(InputStream __in) throws NullPointerException {
        if (__in == null) {
            throw new NullPointerException("NARG");
        }
        this.in = new DataInputStream(__in);
    }

    @Override
    public int available() throws IOException {
        DecompressionInputStream current = this._current;
        if (current != null) {
            return current.available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        DecompressionInputStream current = this._current;
        if (current != null) {
            current.close();
        }
    }

    @Override
    public long compressedBytes() {
        long basecomp = this._basecomp;
        DecompressionInputStream current = this._current;
        if (current != null) {
            return basecomp + current.compressedBytes();
        }
        return basecomp;
    }

    @Override
    public boolean detectsEOF() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int rv;
        byte[] solo = this._solo;
        do {
            if ((rv = this.read(solo, 0, 1)) >= 0) continue;
            return rv;
        } while (rv == 0);
        return solo[0] & 0xFF;
    }

    @Override
    public int read(byte[] __b) throws IOException, NullPointerException {
        return this.read(__b, 0, __b.length);
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new IndexOutOfBoundsException("BAOB");
        }
        if (this._eof) {
            return -1;
        }
        int rv = 0;
        boolean eof = false;
        DataInputStream in = this.in;
        DecompressionInputStream current = this._current;
        Adler32Calculator checksum = this._checksum;
        int at2 = __o;
        int rest = __l;
        while (rv < __l) {
            if (current != null) {
                int rc = current.read(__b, at2, rest);
                if (rc < 0) {
                    int was;
                    this._basecomp += current.compressedBytes();
                    int want = in.readInt();
                    if (want != (was = checksum.checksum())) {
                        throw new IOException(String.format("BD1w %08x %08x", want, was));
                    }
                    this._basecomp += 4L;
                    current = null;
                    this._current = null;
                    continue;
                }
                at2 += rc;
                rv += rc;
                rest -= rc;
                this._uncomp += (long)rc;
                continue;
            }
            int cmf = in.read();
            if (cmf < 0) {
                eof = true;
                this._eof = true;
                break;
            }
            ++this._basecomp;
            int method = cmf & 0xF;
            if (8 != method) {
                throw new IOException(String.format("BD1x %d", method));
            }
            int slwin = ((cmf & 0xF0) >>> 4) + 8;
            if (slwin < 0 || slwin > 30) {
                throw new IOException(String.format("BD1y %d", slwin));
            }
            slwin = 1 << slwin;
            int mf = in.readUnsignedByte();
            ++this._basecomp;
            int was = (cmf * 256 + mf) % 31;
            if (was != 0) {
                throw new IOException(String.format("BD1z %d", was));
            }
            if ((mf & 0x20) != 0) {
                throw new IOException("BD20");
            }
            checksum.reset();
            this._current = current = new InflaterInputStream(in, slwin, checksum);
        }
        return eof && rv == 0 ? -1 : rv;
    }

    @Override
    public long uncompressedBytes() {
        return this._uncomp;
    }
}

