/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.jsr353;

import com.oracle.json.JsonValue;
import com.oracle.json.stream.JsonParsingException;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Deque;
import net.multiphasicapps.jsr353.BaseDecoderBit;
import net.multiphasicapps.jsr353.BaseDecoderData;
import net.multiphasicapps.jsr353.BaseDecoderInput;
import net.multiphasicapps.jsr353.BaseDecoderKind;
import net.multiphasicapps.jsr353.BaseDecoderType;
import net.multiphasicapps.jsr353.ImplValueNumber;
import net.multiphasicapps.jsr353.ImplValueString;
import net.multiphasicapps.jsr353.__Exp__;
import net.multiphasicapps.jsr353.__Scope__;

public abstract class BaseDecoder
implements Closeable {
    protected final BaseDecoderInput input;
    protected final Object lock = new Object();
    private final Deque<BaseDecoderBit> _flush = new ArrayDeque<BaseDecoderBit>();
    private final Deque<__Scope__> _scopes = new ArrayDeque<__Scope__>();
    private boolean _closed;
    private int _emptied;

    protected BaseDecoder(BaseDecoderInput __i) {
        if (__i == null) {
            throw new NullPointerException("noinp");
        }
        this.input = __i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this.input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BaseDecoderBit nextBit() {
        Object object = this.lock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("Decoder has been closed.");
            }
            if (this._flush.isEmpty()) {
                this.__internalGet();
            }
            if (!this._flush.isEmpty()) {
                return this._flush.removeFirst();
            }
            return null;
        }
    }

    private final JsonParsingException __fail(Throwable __t, String __lstr, Object ... __args) {
        return new JsonParsingException(String.format(__lstr, __args) + " (" + this._scopes + ")", __t, this.input.getLocation());
    }

    private final void __internalGet() {
        BaseDecoderType dt2;
        String ds2;
        BaseDecoderData d2 = this.input.next();
        if (d2 != null) {
            ds2 = d2.toString();
            dt2 = d2.getType();
        } else {
            ds2 = null;
            dt2 = BaseDecoderType.END_OF_STREAM;
        }
        switch (dt2) {
            case START_OBJECT: {
                if (this._emptied == 0 && this._scopes.isEmpty() || this.__top().want(__Exp__.VALUE) || this.__top().want(__Exp__.VALUE_OR_END)) {
                    this._scopes.addLast(new __Scope__(dt2));
                    this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.PUSH_OBJECT, new Object[0]));
                    break;
                }
                throw this.__fail(null, "mpso", new Object[0]);
            }
            case END_OBJECT: {
                if (this.__top().want(__Exp__.VALUE_OR_END) || this.__top().want(__Exp__.KEY_OR_END) || this.__top().want(__Exp__.COMMA_OR_END)) {
                    if (!this.__top().isObject()) {
                        throw this.__fail(null, "eonotobj", new Object[0]);
                    }
                    this._scopes.pollLast();
                    if (this._scopes.isEmpty()) {
                        ++this._emptied;
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.FINISHED_OBJECT, new Object[0]));
                        break;
                    }
                    if (this.__top().isObject()) {
                        this.__top().need(__Exp__.COMMA_OR_END);
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.POP_OBJECT_ADD_OBJECT_KEYVAL, new Object[0]));
                        break;
                    }
                    if (this.__top().isArray()) {
                        this.__top().need(__Exp__.COMMA_OR_END);
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.POP_ARRAY_ADD_ARRAY, new Object[0]));
                        break;
                    }
                    throw new RuntimeException("eounss");
                }
                throw this.__fail(null, "mpeo", new Object[0]);
            }
            case START_ARRAY: {
                if (this._emptied == 0 && this._scopes.isEmpty() || this.__top().want(__Exp__.VALUE) || this.__top().want(__Exp__.VALUE_OR_END)) {
                    this._scopes.addLast(new __Scope__(dt2));
                    this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.PUSH_ARRAY, new Object[0]));
                    break;
                }
                throw this.__fail(null, "mpsa", new Object[0]);
            }
            case END_ARRAY: {
                if (this.__top().want(__Exp__.VALUE_OR_END) || this.__top().want(__Exp__.COMMA_OR_END)) {
                    if (!this.__top().isArray()) {
                        throw this.__fail(null, "eonotarr", new Object[0]);
                    }
                    this._scopes.pollLast();
                    if (this._scopes.isEmpty()) {
                        ++this._emptied;
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.FINISHED_ARRAY, new Object[0]));
                        break;
                    }
                    if (this.__top().isObject()) {
                        this.__top().need(__Exp__.COMMA_OR_END);
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.POP_ARRAY_ADD_OBJECT_KEYVAL, new Object[0]));
                        break;
                    }
                    if (this.__top().isArray()) {
                        this.__top().need(__Exp__.COMMA_OR_END);
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.POP_ARRAY_ADD_ARRAY, new Object[0]));
                        break;
                    }
                    throw new RuntimeException("eaunss");
                }
                throw this.__fail(null, "mpea", new Object[0]);
            }
            case LITERAL: {
                if (this.__top().want(__Exp__.VALUE) || this.__top().want(__Exp__.VALUE_OR_END)) {
                    JsonValue vv;
                    char cz2 = ds2.charAt(0);
                    try {
                        vv = cz2 == 't' ? JsonValue.TRUE : (cz2 == 'f' ? JsonValue.FALSE : (cz2 == 'n' ? JsonValue.NULL : new ImplValueNumber(ds2)));
                    }
                    catch (NumberFormatException nfe) {
                        throw this.__fail(nfe, "litnan", ds2);
                    }
                    if (this.__top().isObject()) {
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.ADD_OBJECT_KEYVAL, vv));
                    } else if (this.__top().isArray()) {
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.ADD_ARRAY_VALUE, vv));
                    } else {
                        throw new RuntimeException("unklitv");
                    }
                    this.__top().need(__Exp__.COMMA_OR_END);
                    break;
                }
                throw this.__fail(null, "mpliteral", ds2);
            }
            case STRING: {
                if (this.__top().want(__Exp__.KEY_OR_END) || this.__top().want(__Exp__.KEY)) {
                    if (!this.__top().isObject()) {
                        throw new RuntimeException("incknoto");
                    }
                    this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.DECLARE_KEY, ds2));
                    this.__top().need(__Exp__.COLON);
                    break;
                }
                if (this.__top().want(__Exp__.VALUE) || this.__top().want(__Exp__.VALUE_OR_END)) {
                    if (this.__top().isObject()) {
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.ADD_OBJECT_KEYVAL, new ImplValueString(ds2)));
                    } else if (this.__top().isArray()) {
                        this._flush.addLast(new BaseDecoderBit(BaseDecoderKind.ADD_ARRAY_VALUE, new ImplValueString(ds2)));
                    } else {
                        throw new RuntimeException("unkvalv");
                    }
                    this.__top().need(__Exp__.COMMA_OR_END);
                    break;
                }
                throw this.__fail(null, "mpstring", new Object[0]);
            }
            case COLON: {
                if (this.__top().want(__Exp__.COLON)) {
                    if (!this.__top().isObject()) {
                        if (this.__top().isArray()) {
                            throw this.__fail(null, "colinarr", new Object[0]);
                        }
                        throw new RuntimeException("unkcolao");
                    }
                    this.__top().need(__Exp__.VALUE);
                    this.__internalGet();
                    break;
                }
                throw this.__fail(null, "mpcolon", new Object[0]);
            }
            case COMMA: {
                if (this.__top().want(__Exp__.COMMA_OR_END)) {
                    if (this.__top().isObject()) {
                        this.__top().need(__Exp__.KEY);
                    } else if (this.__top().isArray()) {
                        this.__top().need(__Exp__.VALUE);
                    } else {
                        throw new RuntimeException("unkcomao");
                    }
                    this.__internalGet();
                    break;
                }
                throw this.__fail(null, "mpcomma", new Object[0]);
            }
            default: {
                if (dt2 != null && dt2 != BaseDecoderType.END_OF_STREAM) {
                    throw new RuntimeException(String.format("unkt", dt2.name()));
                }
                if (this._emptied == 0) {
                    throw this.__fail(null, "blankeof", new Object[0]);
                }
                if (!this._scopes.isEmpty()) {
                    throw this.__fail(null, "scopeeof", new Object[0]);
                }
                throw new RuntimeException("TODO -- null");
            }
        }
        if (this._flush.isEmpty()) {
            throw new IllegalStateException("stillempty");
        }
    }

    private final __Scope__ __top() {
        if (this._scopes.isEmpty()) {
            throw this.__fail(null, "emptyscopestack", new Object[0]);
        }
        return this._scopes.peekLast();
    }
}

