/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.jsr353;

import com.oracle.json.JsonArray;
import com.oracle.json.JsonException;
import com.oracle.json.JsonNumber;
import com.oracle.json.JsonObject;
import com.oracle.json.JsonString;
import com.oracle.json.JsonValue;
import com.oracle.json.stream.JsonGenerationException;
import com.oracle.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.multiphasicapps.io.IndentedWriter;
import net.multiphasicapps.jsr353.GeneratorScope;
import net.multiphasicapps.jsr353.ImplValueNumber;
import net.multiphasicapps.jsr353.ImplValueString;

public class ImplGenerator
implements JsonGenerator {
    public static final int INDENT = 2;
    private final IndentedWriter _iw;
    private final Object _lock;
    private final Writer _pw;
    private boolean _closed;
    private volatile boolean _didFail;
    private boolean _done;
    private List<Integer> _sc;
    private List<GeneratorScope> _ss;

    public ImplGenerator(Writer __w, boolean __pretty) {
        if (__w == null) {
            throw new NullPointerException("No output stream specified.");
        }
        this._iw = __pretty ? new IndentedWriter(__w, ' ', 0) : null;
        this._pw = this._iw == null ? __w : this._iw;
        this._lock = new Object();
        this._ss = new LinkedList<GeneratorScope>();
        this._sc = new LinkedList<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            try {
                this._pw.close();
            }
            catch (IOException ignored) {
                this._didFail = true;
            }
            if (this._didFail) {
                throw new JsonException("There were Writer errors.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                throw new JsonException("Generator has been closed.");
            }
            this.__flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(boolean __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(__v ? JsonValue.TRUE : JsonValue.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(double __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(new ImplValueNumber(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(int __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(new ImplValueNumber(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(JsonValue __v) {
        Object object = this._lock;
        synchronized (object) {
            if (__v == null) {
                throw new NullPointerException("No value specified.");
            }
            if (!this.checkState(false, __v)) {
                throw new JsonGenerationException("Invoked in incorrect context.");
            }
            this.doCommaCount();
            this.statelessWriteVal(__v);
            return this.__check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(long __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(new ImplValueNumber(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(String __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(new ImplValueString(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(String __n, boolean __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(__n, __v ? JsonValue.TRUE : JsonValue.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(String __n, double __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(__n, new ImplValueNumber(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(String __n, int __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(__n, new ImplValueNumber(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(String __n, JsonValue __v) {
        Object object = this._lock;
        synchronized (object) {
            if (__n == null) {
                throw new NullPointerException("No key name specified.");
            }
            if (__v == null) {
                throw new NullPointerException("No value specified.");
            }
            if (!this.checkState(true, __v)) {
                throw new JsonGenerationException("Invoked in incorrect context.");
            }
            this.doCommaCount();
            this.putKeyName(__n);
            this.statelessWriteVal(__v);
            return this.__check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(String __n, long __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(__n, new ImplValueNumber(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator write(String __n, String __v) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(__n, new ImplValueString(__v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator writeEnd() {
        Object object = this._lock;
        synchronized (object) {
            char e2;
            if (this._done || this._ss.isEmpty()) {
                throw new JsonGenerationException("Not within a context.");
            }
            char c2 = e2 = this._ss.get(0) == GeneratorScope.ARRAY ? (char)']' : '}';
            if (this._iw != null) {
                this._iw.addIndent(-2);
                this.__printLn();
            }
            this.__print(Character.valueOf(e2));
            this._ss.remove(0);
            this._sc.remove(0);
            if (this._ss.isEmpty()) {
                this._done = true;
                if (this._iw != null) {
                    this.__printLn();
                }
            }
            this.__flush();
            return this.__check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator writeNull() {
        Object object = this._lock;
        synchronized (object) {
            return this.write(JsonValue.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator writeNull(String __n) {
        Object object = this._lock;
        synchronized (object) {
            return this.write(__n, JsonValue.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator writeStartArray() {
        Object object = this._lock;
        synchronized (object) {
            return this.writeStartX(GeneratorScope.ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator writeStartArray(String __n) {
        Object object = this._lock;
        synchronized (object) {
            if (__n == null) {
                throw new NullPointerException("No key name specified.");
            }
            return this.writeStartKeyedX(__n, GeneratorScope.ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator writeStartObject() {
        Object object = this._lock;
        synchronized (object) {
            return this.writeStartX(GeneratorScope.OBJECT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonGenerator writeStartObject(String __n) {
        Object object = this._lock;
        synchronized (object) {
            if (__n == null) {
                throw new NullPointerException("No key name specified.");
            }
            return this.writeStartKeyedX(__n, GeneratorScope.OBJECT);
        }
    }

    private JsonGenerator __check() {
        if (this._didFail) {
            throw new JsonException("pwerr");
        }
        return this;
    }

    private void __flush() {
        try {
            this._pw.flush();
        }
        catch (IOException ignored) {
            this._didFail = true;
        }
    }

    private void __print(Object __v) throws NullPointerException {
        if (__v == null) {
            throw new NullPointerException("NARG");
        }
        try {
            this._pw.append(__v.toString());
        }
        catch (IOException ignored) {
            this._didFail = true;
        }
    }

    private void __printLn() {
        try {
            this._pw.append(System.getProperty("line.ending"));
        }
        catch (IOException ignored) {
            this._didFail = true;
        }
    }

    private void __printf(String __fmt, Object ... __args) throws NullPointerException {
        this.__print(String.format(__fmt, __args));
    }

    private boolean checkState(boolean __obj, JsonValue __v) {
        if (__v == null) {
            throw new NullPointerException("No value specified.");
        }
        if (this._done) {
            return false;
        }
        if (this._ss.isEmpty()) {
            if (__obj) {
                return false;
            }
            return __v instanceof JsonObject || __v instanceof JsonArray;
        }
        return this._ss.get(0) == GeneratorScope.OBJECT == __obj;
    }

    private JsonGenerator doCommaCount() {
        if (!this._sc.isEmpty()) {
            if (this._sc.get(0) > 0) {
                this.__print(Character.valueOf(','));
                if (this._iw != null) {
                    this.__printLn();
                }
            }
            this._sc.set(0, this._sc.get(0) + 1);
        }
        return this.__check();
    }

    private void putKeyName(String __n) {
        if (__n == null) {
            throw new NullPointerException("No key name specified.");
        }
        this.__printf("\"%s\":", ImplValueString.escapedForm(__n));
    }

    private JsonGenerator statelessStartX(String __n, GeneratorScope __s) {
        if (__s == null) {
            throw new NullPointerException("No scope specified.");
        }
        if (__n != null) {
            this.putKeyName(__n);
        }
        this.__print(Character.valueOf(__s == GeneratorScope.ARRAY ? (char)'[' : '{'));
        if (this._iw != null) {
            this._iw.addIndent(2);
            this.__printLn();
        }
        this._ss.add(0, __s);
        this._sc.add(0, 0);
        if (this._didFail) {
            throw new JsonException("Error in output stream.");
        }
        return this.__check();
    }

    private void statelessWriteVal(JsonValue __v) {
        if (__v == null) {
            throw new NullPointerException("No value to write.");
        }
        if (__v == JsonValue.TRUE) {
            this.__print("true");
        } else if (__v == JsonValue.FALSE) {
            this.__print("false");
        } else if (__v == JsonValue.NULL) {
            this.__print("null");
        } else if (__v instanceof JsonNumber) {
            JsonNumber jv = (JsonNumber)__v;
            this.__print(jv.toString());
        } else if (__v instanceof JsonString) {
            JsonString jv = (JsonString)__v;
            this.__printf("\"%s\"", ImplValueString.escapedForm(jv.getString()));
        } else if (__v instanceof JsonArray) {
            JsonArray jv = (JsonArray)__v;
            this.statelessStartX(null, GeneratorScope.ARRAY);
            for (JsonValue v2 : jv) {
                this.write(v2);
            }
            this.writeEnd();
        } else if (__v instanceof JsonObject) {
            JsonObject jv = (JsonObject)__v;
            this.statelessStartX(null, GeneratorScope.OBJECT);
            for (Map.Entry e2 : jv.entrySet()) {
                this.write((String)e2.getKey(), (JsonValue)e2.getValue());
            }
            this.writeEnd();
        } else {
            throw new JsonGenerationException("Unknown type for generation.");
        }
    }

    private JsonGenerator writeStartKeyedX(String __n, GeneratorScope __s) {
        if (this._done || this._ss.isEmpty() || this._ss.get(0) != GeneratorScope.OBJECT) {
            throw new JsonGenerationException("Not within valid context.");
        }
        this.doCommaCount();
        return this.statelessStartX(__n, __s);
    }

    private JsonGenerator writeStartX(GeneratorScope __s) {
        if (this._done || !this._ss.isEmpty() && this._ss.get(0) != GeneratorScope.ARRAY) {
            throw new JsonGenerationException("Not within valid context.");
        }
        this.doCommaCount();
        return this.statelessStartX(null, __s);
    }
}

