/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.jsr353;

import com.oracle.json.JsonArray;
import com.oracle.json.JsonArrayBuilder;
import com.oracle.json.JsonException;
import com.oracle.json.JsonObject;
import com.oracle.json.JsonObjectBuilder;
import com.oracle.json.JsonReader;
import com.oracle.json.JsonStructure;
import com.oracle.json.JsonValue;
import com.oracle.json.stream.JsonLocation;
import com.oracle.json.stream.JsonParsingException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import net.multiphasicapps.jsr353.BaseDecoder;
import net.multiphasicapps.jsr353.BaseDecoderBit;
import net.multiphasicapps.jsr353.BaseDecoderKind;
import net.multiphasicapps.jsr353.ImplArrayBuilder;
import net.multiphasicapps.jsr353.ImplObjectBuilder;
import net.multiphasicapps.jsr353.ReaderInput;
import net.multiphasicapps.jsr353.SomeBuilder;
import net.multiphasicapps.jsr353.SomeLocation;

public class ImplReader
extends BaseDecoder
implements JsonReader {
    private List<SomeBuilder> _bs = new LinkedList<SomeBuilder>();
    private volatile boolean _closed;
    private volatile boolean _did;
    private List<String> _ks = new LinkedList<String>();

    public ImplReader(Reader __r) {
        super(new ReaderInput(__r));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            super.close();
            this._closed = true;
            this._bs = null;
            this._ks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonStructure read() {
        Object object = this.lock;
        synchronized (object) {
            JsonStructure rv;
            block23: {
                BaseDecoderKind k2;
                JsonLocation jl;
                if (this._closed) {
                    throw new JsonException("Stream has been closed.");
                }
                if (this._did) {
                    throw new JsonException("Data has already been read.");
                }
                this._did = true;
                rv = null;
                while (true) {
                    Object ob;
                    JsonValue v2;
                    jl = this.input.getLocation();
                    BaseDecoderBit b2 = this.nextBit();
                    if (b2 == null) break block23;
                    k2 = b2.getKind();
                    if (k2 == BaseDecoderKind.PUSH_OBJECT) {
                        this._bs.add(0, new ImplObjectBuilder());
                        continue;
                    }
                    if (k2 == BaseDecoderKind.PUSH_ARRAY) {
                        this._bs.add(0, new ImplArrayBuilder());
                        continue;
                    }
                    if (k2 == BaseDecoderKind.FINISHED_OBJECT) {
                        rv = ((JsonObjectBuilder)((Object)this._bs.remove(0))).build();
                        break block23;
                    }
                    if (k2 == BaseDecoderKind.FINISHED_ARRAY) {
                        rv = ((JsonArrayBuilder)((Object)this._bs.remove(0))).build();
                        break block23;
                    }
                    if (k2 == BaseDecoderKind.DECLARE_KEY) {
                        this._ks.add(0, (String)b2.get(0));
                        continue;
                    }
                    if (k2 == BaseDecoderKind.ADD_OBJECT_KEYVAL || k2 == BaseDecoderKind.POP_ARRAY_ADD_OBJECT_KEYVAL || k2 == BaseDecoderKind.POP_OBJECT_ADD_OBJECT_KEYVAL) {
                        v2 = null;
                        if (k2 == BaseDecoderKind.POP_ARRAY_ADD_OBJECT_KEYVAL) {
                            v2 = ((JsonArrayBuilder)((Object)this._bs.remove(0))).build();
                        } else if (k2 == BaseDecoderKind.POP_OBJECT_ADD_OBJECT_KEYVAL) {
                            v2 = ((JsonObjectBuilder)((Object)this._bs.remove(0))).build();
                        } else if (k2 == BaseDecoderKind.ADD_OBJECT_KEYVAL) {
                            v2 = (JsonValue)b2.get(0);
                        }
                        ob = (JsonObjectBuilder)((Object)this._bs.get(0));
                        ob.add(this._ks.get(0), v2);
                        this._ks.remove(0);
                        continue;
                    }
                    if (k2 != BaseDecoderKind.ADD_ARRAY_VALUE && k2 != BaseDecoderKind.POP_OBJECT_ADD_ARRAY && k2 != BaseDecoderKind.POP_ARRAY_ADD_ARRAY) break;
                    v2 = null;
                    if (k2 == BaseDecoderKind.ADD_ARRAY_VALUE) {
                        v2 = (JsonValue)b2.get(0);
                    } else if (k2 == BaseDecoderKind.POP_OBJECT_ADD_ARRAY) {
                        v2 = ((JsonObjectBuilder)((Object)this._bs.remove(0))).build();
                    } else if (k2 == BaseDecoderKind.POP_ARRAY_ADD_ARRAY) {
                        v2 = ((JsonArrayBuilder)((Object)this._bs.remove(0))).build();
                    }
                    ob = (JsonArrayBuilder)((Object)this._bs.get(0));
                    ob.add(v2);
                }
                throw new JsonParsingException(String.format("Unhandled kind action %1$s.", new Object[]{k2}), jl);
            }
            if (rv == null) {
                throw new JsonParsingException(String.format("No value has been read.", new Object[0]), new SomeLocation());
            }
            return rv;
        }
    }

    @Override
    public JsonArray readArray() {
        Object object = this.lock;
        synchronized (object) {
            JsonStructure js = this.read();
            if (js != null && js instanceof JsonArray && js.getValueType() == JsonValue.ValueType.ARRAY) {
                return (JsonArray)js;
            }
            throw new JsonException("An array was not read.");
        }
    }

    @Override
    public JsonObject readObject() {
        Object object = this.lock;
        synchronized (object) {
            JsonStructure js = this.read();
            if (js != null && js instanceof JsonObject && js.getValueType() == JsonValue.ValueType.OBJECT) {
                return (JsonObject)js;
            }
            throw new JsonException("An object was not read.");
        }
    }
}

