/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.jsr353;

import com.oracle.json.JsonException;
import com.oracle.json.stream.JsonLocation;
import com.oracle.json.stream.JsonParsingException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import net.multiphasicapps.io.LineColumnReader;
import net.multiphasicapps.jsr353.BaseDecoderData;
import net.multiphasicapps.jsr353.BaseDecoderInput;
import net.multiphasicapps.jsr353.BaseDecoderType;
import net.multiphasicapps.jsr353.SomeLocation;

public class ReaderInput
extends BaseDecoderInput
implements Closeable {
    protected final LineColumnReader lcr;
    private boolean _closed;
    private int _peek = Integer.MIN_VALUE;

    public ReaderInput(Reader __r) {
        if (__r == null) {
            throw new NullPointerException("noin");
        }
        this.lcr = new LineColumnReader(__r, Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.ilock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            try {
                this.lcr.close();
            }
            catch (IOException ioe) {
                throw new JsonException("clioe", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonLocation getLocation() {
        Object object = this.ilock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("closedin");
            }
            return new SomeLocation((long)this.lcr.getLineNumber() + 1L, this.lcr.getColumnNumber());
        }
    }

    @Override
    protected BaseDecoderData next() {
        Object object = this.ilock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("closedin");
            }
            try {
                return this.__nextInternal();
            }
            catch (IOException ioe) {
                throw new JsonException("clioe", ioe);
            }
        }
    }

    private BaseDecoderData __nextInternal() throws IOException {
        JsonLocation jl;
        int c2;
        do {
            jl = this.getLocation();
            c2 = this.__read();
            if (c2 >= 0) continue;
            return null;
        } while (c2 == 9 || c2 == 10 || c2 == 13 || c2 == 32);
        if (c2 == 123) {
            return new BaseDecoderData(BaseDecoderType.START_OBJECT, null);
        }
        if (c2 == 125) {
            return new BaseDecoderData(BaseDecoderType.END_OBJECT, null);
        }
        if (c2 == 91) {
            return new BaseDecoderData(BaseDecoderType.START_ARRAY, null);
        }
        if (c2 == 93) {
            return new BaseDecoderData(BaseDecoderType.END_ARRAY, null);
        }
        if (c2 == 34) {
            StringBuilder sb = new StringBuilder();
            boolean esc = false;
            while (true) {
                if ((c2 = this.__read()) < 0 || c2 == 9 || c2 == 13 || c2 == 10) {
                    throw new JsonParsingException("seol", jl);
                }
                if (esc) {
                    if (c2 == 117) {
                        int[] hex = new int[4];
                        for (int i2 = 0; i2 < 4; ++i2) {
                            hex[i2] = this.__read();
                            if (hex[i2] < 0) {
                                throw new JsonParsingException("ueof", jl);
                            }
                            int dig = Character.digit((char)hex[i2], 16);
                            if (dig < 0) {
                                throw new JsonParsingException(String.format("bx", hex[i2]), jl);
                            }
                            hex[i2] = dig;
                        }
                        c2 = hex[0] << 12 | hex[1] << 8 | hex[2] << 4 | hex[3];
                    } else {
                        switch (c2) {
                            case 34: {
                                c2 = 34;
                                break;
                            }
                            case 92: {
                                c2 = 92;
                                break;
                            }
                            case 47: {
                                c2 = 47;
                                break;
                            }
                            case 98: {
                                c2 = 8;
                                break;
                            }
                            case 102: {
                                c2 = 12;
                                break;
                            }
                            case 110: {
                                c2 = 10;
                                break;
                            }
                            case 114: {
                                c2 = 13;
                                break;
                            }
                            case 116: {
                                c2 = 9;
                                break;
                            }
                            default: {
                                throw new JsonParsingException(String.format("illesc", c2), jl);
                            }
                        }
                    }
                    sb.append((char)c2);
                    esc = false;
                    continue;
                }
                if (c2 == 34) break;
                if (c2 == 92) {
                    esc = true;
                    continue;
                }
                sb.append((char)c2);
            }
            return new BaseDecoderData(BaseDecoderType.STRING, sb.toString());
        }
        if (c2 == 58) {
            return new BaseDecoderData(BaseDecoderType.COLON, null);
        }
        if (c2 == 44) {
            return new BaseDecoderData(BaseDecoderType.COMMA, null);
        }
        if (c2 == 45 || c2 >= 48 && c2 <= 57) {
            StringBuilder sb = new StringBuilder();
            boolean diddeci = false;
            boolean didexpo = false;
            boolean cansign = false;
            while (true) {
                if (c2 < 0) {
                    throw new JsonParsingException("eoflit", jl);
                }
                if (c2 != 45 && c2 != 43 && (c2 < 48 || c2 > 57) && c2 != 101 && c2 != 69 && c2 != 46) {
                    throw new JsonParsingException(String.format("illgnum", Character.valueOf((char)c2)), jl);
                }
                sb.append((char)c2);
                c2 = this.__peek();
                if (c2 != 45 && c2 != 43 && (c2 < 48 || c2 > 57) && c2 != 101 && c2 != 69 && c2 != 46) break;
                if (c2 == 69) {
                    c2 = 101;
                }
                if (c2 == 45 || c2 == 43) {
                    if (!cansign) {
                        throw new JsonParsingException("badnumsign", jl);
                    }
                    cansign = false;
                } else {
                    cansign = false;
                }
                if (c2 == 101) {
                    if (didexpo) {
                        throw new JsonParsingException("mulexpo", jl);
                    }
                    didexpo = true;
                    cansign = true;
                }
                if (c2 == 46) {
                    if (diddeci) {
                        throw new JsonParsingException("muldeci", jl);
                    }
                    diddeci = true;
                }
                c2 = this.__read();
            }
            return new BaseDecoderData(BaseDecoderType.LITERAL, sb.toString());
        }
        if (c2 == 102 || c2 == 116 || c2 == 110) {
            StringBuilder sb = new StringBuilder();
            boolean t2 = c2 == 116;
            boolean n2 = c2 == 110;
            boolean f2 = c2 == 102;
            int rl = t2 || n2 ? 4 : 5;
            sb.append((char)c2);
            for (int i3 = 1; i3 < rl; ++i3) {
                c2 = this.__read();
                if (c2 < 0) {
                    throw new JsonParsingException("eoflit", jl);
                }
                sb.append((char)c2);
            }
            String ls = sb.toString();
            if (!(ls.equals("true") || ls.equals("false") || ls.equals("null"))) {
                throw new JsonParsingException(String.format("illlit", ls), jl);
            }
            return new BaseDecoderData(BaseDecoderType.LITERAL, sb.toString());
        }
        throw new JsonParsingException(String.format("illchart", Character.valueOf((char)c2)), jl);
    }

    private final int __peek() throws IOException {
        if (this._peek > Integer.MIN_VALUE) {
            return this._peek;
        }
        this._peek = this.lcr.read();
        return this._peek;
    }

    private final int __read() throws IOException {
        while (true) {
            if (this._peek > Integer.MIN_VALUE) {
                int rv = this._peek;
                this._peek = Integer.MIN_VALUE;
                return rv;
            }
            this.__peek();
        }
    }
}

