/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.tac;

import java.io.IOException;
import java.io.PrintStream;
import net.multiphasicapps.tac.TestResult;
import net.multiphasicapps.tac.TestStatus;

public final class TestExecution {
    public static final String RESULT_MANIFEST = "net.multiphasicapps.tac.resultManifest";
    public final TestStatus status;
    public final Class<?> testClass;
    public final TestResult result;
    public final TestResult expected;
    public final Object tossed;

    public TestExecution(TestStatus __ts, Class<?> __tc, TestResult __res, TestResult __exp, Object __tossed) {
        this.status = __ts;
        this.testClass = __tc;
        this.result = __res;
        this.expected = __exp;
        this.tossed = __tossed;
    }

    public final void print(PrintStream __ps) throws NullPointerException {
        if (__ps == null) {
            throw new NullPointerException("NARG");
        }
        if (Boolean.getBoolean(RESULT_MANIFEST)) {
            System.err.println("********************************");
            try {
                this.result.writeAsManifest(System.err);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.err.println("********************************");
        }
        switch (this.status) {
            case SUCCESS: {
                __ps.printf("%s: PASS %s%n", this.testClass, this.result);
                break;
            }
            case FAILED: {
                __ps.printf("%s: FAIL %s%n", this.testClass, this.result);
                this.result.printComparison(System.err, this.expected);
                break;
            }
            case TEST_EXCEPTION: {
                __ps.printf("BU0d %s%n", this.testClass);
                break;
            }
            case UNTESTABLE: {
                __ps.printf("BU0c %s%n", this.testClass);
            }
        }
        if (this.status != TestStatus.FAILED && this.tossed instanceof Throwable) {
            ((Throwable)this.tossed).printStackTrace(__ps);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("status=");
        sb.append((Object)this.status);
        sb.append(", testClass=");
        sb.append(this.testClass.getName());
        sb.append(", result=");
        sb.append(this.result.toString());
        sb.append(", expected=");
        sb.append(this.expected.toString());
        Object tossed = this.tossed;
        if (tossed != null) {
            sb.append(", tossed=");
            sb.append(tossed.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public final Throwable tossedAsThrowable() {
        Object rv = this.tossed;
        return rv instanceof Throwable ? (Throwable)rv : null;
    }
}

