/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.tac;

import cc.squirreljme.jvm.manifest.JavaManifest;
import cc.squirreljme.jvm.manifest.JavaManifestAttributes;
import cc.squirreljme.jvm.manifest.JavaManifestKey;
import cc.squirreljme.jvm.mle.TypeShelf;
import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.SortedTreeMap;
import cc.squirreljme.runtime.cldc.util.SortedTreeSet;
import cc.squirreljme.runtime.cldc.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.multiphasicapps.tac.DataDeserialization;
import net.multiphasicapps.tac.DataSerialization;
import net.multiphasicapps.tac.InvalidTestParameterException;
import net.multiphasicapps.tac.TestResultBuilder;
import net.multiphasicapps.tool.manifest.writer.MutableJavaManifest;
import net.multiphasicapps.tool.manifest.writer.MutableJavaManifestAttributes;

@SquirrelJMEVendorApi
public final class TestResult {
    protected final String rvalue;
    protected final String tvalue;
    private final Map<String, String> _secondary;
    private int _hash;
    private Reference<String> _string;

    @SquirrelJMEVendorApi
    public TestResult(String __rv, String __tv, Map<String, String> __sec) throws NullPointerException {
        if (__rv == null || __tv == null || __sec == null) {
            throw new NullPointerException("NARG");
        }
        this.rvalue = __rv;
        this.tvalue = __tv;
        SortedTreeMap<String, String> to = new SortedTreeMap<String, String>();
        for (Map.Entry<String, String> e2 : __sec.entrySet()) {
            String k2 = e2.getKey();
            String v2 = e2.getValue();
            if (k2 == null || v2 == null) {
                throw new NullPointerException("NARG");
            }
            to.put(k2, v2);
        }
        this._secondary = new LinkedHashMap<String, String>(to);
    }

    public final boolean equals(Object __o) {
        if (__o == this) {
            return true;
        }
        if (!(__o instanceof TestResult)) {
            return false;
        }
        TestResult o2 = (TestResult)__o;
        return this.rvalue.equals(o2.rvalue) && this.tvalue.equals(o2.tvalue) && this._secondary.equals(o2._secondary);
    }

    @SquirrelJMEVendorApi
    public final String getSecondaryRawValue(String __key) throws NullPointerException {
        if (__key == null) {
            throw new NullPointerException("NARG");
        }
        return this._secondary.get(__key);
    }

    public final int hashCode() {
        int rv = this._hash;
        if (rv == 0) {
            this._hash = rv = this.rvalue.hashCode() ^ this.tvalue.hashCode() ^ this._secondary.hashCode();
        }
        return rv;
    }

    @SquirrelJMEVendorApi
    public final boolean isSatisfiedBy(TestResult __o) throws NullPointerException {
        if (__o == null) {
            throw new NullPointerException("NARG");
        }
        return TestResult.valueEquals(__o.rvalue, this.rvalue) && TestResult.valueEquals(__o.tvalue, this.tvalue) && TestResult.__equals(__o._secondary, this._secondary);
    }

    @SquirrelJMEVendorApi
    public final void printComparison(PrintStream __ps, TestResult __o) throws NullPointerException {
        if (__o == null || __ps == null) {
            throw new NullPointerException("NARG");
        }
        TestResult.__printSingleCompare(__ps, "return", this.rvalue, __o.rvalue);
        TestResult.__printSingleCompare(__ps, "thrown", this.tvalue, __o.tvalue);
        Map<String, String> as2 = this._secondary;
        Map<String, String> bs2 = __o._secondary;
        SortedTreeSet merged = new SortedTreeSet();
        merged.addAll(as2.keySet());
        merged.addAll(bs2.keySet());
        for (String k2 : merged) {
            TestResult.__printSingleCompare(__ps, k2, as2.get(k2), bs2.get(k2));
        }
    }

    public final String toString() {
        String rv;
        Reference<String> ref = this._string;
        if (ref == null || null == (rv = ref.get())) {
            StringBuilder sb = new StringBuilder();
            sb.append("{rv=");
            sb.append(this.rvalue);
            sb.append(", tv=");
            sb.append(this.tvalue);
            Map<String, String> secondary = this._secondary;
            if (!secondary.isEmpty()) {
                sb.append(", sv=");
                sb.append(secondary);
            }
            sb.append('}');
            rv = sb.toString();
            this._string = new WeakReference<String>(rv);
        }
        return rv;
    }

    @SquirrelJMEVendorApi
    public final void writeAsManifest(OutputStream __os) throws IOException, NullPointerException {
        if (__os == null) {
            throw new NullPointerException("NARG");
        }
        MutableJavaManifest man = new MutableJavaManifest();
        MutableJavaManifestAttributes attr = man.getMainAttributes();
        attr.putValue("result", this.rvalue);
        attr.putValue("thrown", this.tvalue);
        for (Map.Entry<String, String> e2 : this._secondary.entrySet()) {
            attr.putValue("secondary-" + DataSerialization.encodeKey(e2.getKey()), e2.getValue());
        }
        man.write(__os);
    }

    @SquirrelJMEVendorApi
    public static TestResult loadForClass(Class<?> __cl, Map<String, String> __otherKeys, String __multiParam) throws NullPointerException {
        if (__cl == null) {
            throw new NullPointerException("NARG");
        }
        ArrayList<String> multiParams = null;
        if (__multiParam != null) {
            LinkedHashSet<String> working = new LinkedHashSet<String>();
            String[] splits = StringUtils.basicSplit('@', __multiParam);
            working.addAll(Arrays.asList(splits));
            int n2 = splits.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StringBuilder sb = new StringBuilder();
                for (int j2 = 0; j2 <= i2; ++j2) {
                    if (sb.length() > 0) {
                        sb.append('@');
                    }
                    sb.append(splits[j2]);
                }
                working.add(sb.toString());
            }
            multiParams = new ArrayList<String>(working);
            Collections.reverse(multiParams);
        }
        TestResultBuilder rv = new TestResultBuilder();
        for (Class<?> at2 = __cl; at2 != null; at2 = at2.getSuperclass()) {
            TestResult.__loadClassValues(__otherKeys, multiParams, rv, at2);
            for (Class<?> implement : TypeShelf.interfaces(at2)) {
                TestResult.__loadClassValues(__otherKeys, multiParams, rv, implement);
            }
        }
        return rv.build();
    }

    @SquirrelJMEVendorApi
    public static List<String> throwableList(String __ts) throws NullPointerException {
        if (__ts == null) {
            throw new NullPointerException("NARG");
        }
        if (!__ts.startsWith("throwable:")) {
            throw new IllegalArgumentException("BU07");
        }
        int lm = (__ts = __ts.substring(10)).indexOf(58);
        if (lm >= 0) {
            __ts = __ts.substring(0, lm);
        }
        ArrayList<String> rv = new ArrayList<String>();
        String baseform = "java.lang";
        int i2 = 0;
        int n2 = __ts.length();
        while (i2 < n2) {
            String sub;
            int ld;
            int lc = __ts.indexOf(44, i2);
            if (lc < 0) {
                lc = n2;
            }
            if ((ld = (sub = __ts.substring(i2, lc)).lastIndexOf(46)) >= 0) {
                baseform = sub.substring(0, ld);
                sub = sub.substring(ld + 1);
            }
            rv.add(baseform + "." + sub);
            i2 = lc + 1;
        }
        return rv;
    }

    @SquirrelJMEVendorApi
    public static boolean valueEquals(String __act, String __exp) throws InvalidTestParameterException, NullPointerException {
        if (__act == null || __exp == null) {
            throw new NullPointerException("NARG");
        }
        if (__act.startsWith("throwable:") && __exp.startsWith("throwable:")) {
            List<String> la = TestResult.throwableList(__act);
            List<String> lb = TestResult.throwableList(__exp);
            Debugging.debugNote("%s ~~= %s", la, lb);
            la.retainAll(lb);
            return !la.isEmpty();
        }
        if (__act.startsWith("long:") && __exp.startsWith("long-ignore-sign:")) {
            long exp;
            long act = Long.parseLong(__act.substring("long:".length()));
            return (act & Long.MAX_VALUE) == ((exp = Long.parseLong(__exp.substring("long-ignore-sign:".length()))) & Long.MAX_VALUE);
        }
        if (__act.startsWith("long:") && __exp.startsWith("long-fudge:")) {
            long act = Long.parseLong(__act.substring("long:".length()));
            int xfc = __exp.indexOf(58);
            int xlc = __exp.lastIndexOf(58);
            if (xlc == xfc) {
                xlc = -1;
            }
            long exp = Long.parseLong(__exp.substring(xfc + 1, xlc >= 0 ? xlc : __exp.length()));
            long fudge = Math.abs(xlc >= 0 ? Long.parseLong(__exp.substring(xlc + 1)) : 0L);
            return act == exp || act >= exp - fudge && act <= exp + fudge;
        }
        return __exp.equals(__act);
    }

    private static boolean __equals(Map<String, String> __act, Map<String, String> __exp) throws InvalidTestParameterException, NullPointerException {
        if (__act == null || __exp == null) {
            throw new NullPointerException("NARG");
        }
        for (Map.Entry<String, String> a2 : __act.entrySet()) {
            String key = a2.getKey();
            if ("Drop".equals(__exp.get(key))) continue;
            if (!__exp.containsKey(key)) {
                return false;
            }
            if (TestResult.valueEquals(a2.getValue(), __exp.get(key))) continue;
            return false;
        }
        for (String key : __exp.keySet()) {
            if (__act.containsKey(key) || "Drop".equals(__exp.get(key))) continue;
            return false;
        }
        return true;
    }

    private static void __extractResults(Map<String, String> __otherKeys, TestResultBuilder __result, Class<?> __pivot, String __baseName) {
        JavaManifestAttributes attr;
        try (InputStream in = __pivot.getResourceAsStream(__baseName + ".in");){
            if (in == null) {
                return;
            }
            attr = new JavaManifest(in).getMainAttributes();
        }
        catch (IOException e2) {
            return;
        }
        block22: for (Map.Entry<JavaManifestKey, String> e3 : attr.entrySet()) {
            String ekey = e3.getKey().toString().toLowerCase();
            String eval = e3.getValue();
            switch (ekey) {
                case "result": {
                    if (__result.getReturn() != null) continue block22;
                    __result.setReturnEncoded(eval);
                    continue block22;
                }
                case "thrown": {
                    if (__result.getThrown() != null) continue block22;
                    __result.setThrownEncoded(eval);
                    continue block22;
                }
            }
            if (ekey.startsWith("secondary-")) {
                String skey = DataDeserialization.decodeKey(ekey.substring(10));
                if (__result.getSecondary(skey) != null) continue;
                __result.putSecondaryEncoded(skey, eval);
                continue;
            }
            if (__otherKeys == null || __otherKeys.containsKey(ekey)) continue;
            __otherKeys.put(ekey, eval);
        }
    }

    private static void __loadClassValues(Map<String, String> __otherKeys, List<String> __multiParams, TestResultBuilder __rv, Class<?> __at) {
        String atBase;
        String atName = __at.getName();
        int ld = atName.lastIndexOf(46);
        String string = atBase = ld < 0 ? atName : atName.substring(ld + 1);
        if (__multiParams != null && !__multiParams.isEmpty()) {
            for (String multiParam : __multiParams) {
                TestResult.__extractResults(__otherKeys, __rv, __at, atBase + "@" + multiParam);
            }
        }
        TestResult.__extractResults(__otherKeys, __rv, __at, atBase);
    }

    private static void __printSingleCompare(PrintStream __ps, String __key, String __a, String __b) throws NullPointerException {
        if (__ps == null || __key == null) {
            throw new NullPointerException("NARG");
        }
        boolean equals = __a == null || __b == null ? Objects.equals(__a, __b) : TestResult.valueEquals(__a, __b);
        if (__a == null) {
            __a = "-???-";
        }
        if (__b == null) {
            __b = "-???-";
        }
        __ps.printf("\t%-15s %c %s %s%n", __key, Character.valueOf(equals ? (char)'=' : '!'), __a, __b);
    }
}

