/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.blockreader;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.EOFException;
import java.io.IOException;
import net.multiphasicapps.zip.blockreader.BlockAccessor;

@SquirrelJMEVendorApi
public class ArrayBlockAccessor
implements BlockAccessor {
    @SquirrelJMEVendorApi
    protected final byte[] buffer;
    @SquirrelJMEVendorApi
    protected final int offset;
    @SquirrelJMEVendorApi
    protected final int length;

    @SquirrelJMEVendorApi
    public ArrayBlockAccessor(byte[] __b) throws NullPointerException {
        this(__b, 0, __b.length);
    }

    @SquirrelJMEVendorApi
    public ArrayBlockAccessor(byte[] __b, int __o, int __l) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new ArrayIndexOutOfBoundsException("AIOB");
        }
        this.buffer = __b;
        this.offset = __o;
        this.length = __l;
    }

    @Override
    public void close() {
    }

    @Override
    public byte read(long __addr) throws EOFException, IOException {
        if (__addr < 0L) {
            throw new IOException("BF04");
        }
        if (__addr > (long)this.length) {
            throw new EOFException("BF05");
        }
        return this.buffer[this.offset + (int)__addr];
    }

    @Override
    public int read(long __addr, byte[] __b, int __o, int __l) throws ArrayIndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new ArrayIndexOutOfBoundsException("AIOB");
        }
        if (__addr < 0L) {
            throw new IOException("BF06");
        }
        int length = this.length;
        if (__addr >= (long)length) {
            return -1;
        }
        int addr = (int)__addr;
        int actual = Math.min(__l, length - addr);
        byte[] buffer = this.buffer;
        int offset = this.offset;
        int i2 = 0;
        int s2 = offset + addr;
        int d2 = __o;
        while (i2 < actual) {
            __b[d2] = buffer[s2];
            ++i2;
            ++s2;
            ++d2;
        }
        return actual;
    }

    @Override
    public long size() {
        return this.length;
    }
}

