/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.blockreader;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.multiphasicapps.zip.blockreader.BlockAccessor;

@SquirrelJMEVendorApi
public class FileChannelBlockAccessor
implements BlockAccessor {
    @SquirrelJMEVendorApi
    protected final FileChannel channel;

    @SquirrelJMEVendorApi
    public FileChannelBlockAccessor(Path __p) throws IOException, NullPointerException {
        this(FileChannel.open(__p, StandardOpenOption.READ));
    }

    @SquirrelJMEVendorApi
    public FileChannelBlockAccessor(FileChannel __fc) throws IOException, NullPointerException {
        if (__fc == null) {
            throw new NullPointerException("NARG");
        }
        this.channel = __fc;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public byte read(long __addr) throws EOFException, IOException {
        if (__addr < 0L) {
            throw new IOException("BF07");
        }
        byte[] val2 = new byte[1];
        int rv = this.read(__addr, val2, 0, 1);
        if (rv < 0) {
            throw new EOFException("BF08");
        }
        return val2[0];
    }

    @Override
    public int read(long __addr, byte[] __b, int __o, int __l) throws ArrayIndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (__o < 0 || __l < 0 || __o + __l < 0 || __o + __l > __b.length) {
            throw new ArrayIndexOutOfBoundsException("AIOB");
        }
        if (__addr < 0L) {
            throw new IOException("BF09");
        }
        ByteBuffer buf = ByteBuffer.wrap(__b, __o, __l);
        FileChannel channel = this.channel;
        while (buf.hasRemaining()) {
            if (channel.read(buf, __addr + (long)buf.position()) >= 0) continue;
            int n2 = buf.position();
            if (n2 <= 0) {
                return -1;
            }
            return n2;
        }
        return buf.position();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }
}

