/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.blockreader;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.multiphasicapps.io.DecompressionInputStream;
import net.multiphasicapps.zip.ZipCompressionType;
import net.multiphasicapps.zip.ZipException;
import net.multiphasicapps.zip.blockreader.BlockAccessor;
import net.multiphasicapps.zip.blockreader.ZipBlockReader;
import net.multiphasicapps.zip.blockreader.__ArrayData__;
import net.multiphasicapps.zip.blockreader.__BlockAccessorRegionInputStream__;
import net.multiphasicapps.zip.blockreader.__CRCInputStream__;

@SquirrelJMEVendorApi
public final class ZipBlockEntry {
    private static final int _MAX_CENTRAL_DIR_VERSION = 20;
    private static final int _CENTRAL_DIRECTORY_MADE_BY_VERSION_OFFSET = 4;
    private static final int _CENTRAL_DIRECTORY_EXTRACT_VERSION_OFFSET = 6;
    private static final int _CENTRAL_DIRECTORY_FLAG_OFFSET = 8;
    private static final int _CENTRAL_DIRECTORY_METHOD_OFFSET = 10;
    private static final int _CENTRAL_DIRECTORY_CRC_OFFSET = 16;
    private static final int _CENTRAL_DIRECTORY_COMPRESSED_OFFSET = 20;
    private static final int _CENTRAL_DIRECTORY_UNCOMPRESSED_OFFSET = 24;
    private static final int _CENTRAL_DIRECTORY_NAME_LENGTH_OFFSET = 28;
    private static final int _CENTRAL_DIRECTORY_EXTRA_LENGTH_OFFSET = 30;
    private static final int _CENTRAL_DIRECTORY_COMMENT_LENGTH_OFFSET = 32;
    private static final int _CENTRAL_DIRECTORY_LOCAL_HEADER_OFFSET = 42;
    private static final int _CENTRAL_DIRECTORY_MIN_LENGTH = 46;
    private static final int _LOCAL_HEADER_MAGIC_NUMBER = 67324752;
    private static final int _LOCAL_HEADER_NAME_LENGTH_OFFSET = 26;
    private static final int _LOCAL_HEADER_COMMENT_LENGTH_OFFSET = 28;
    private static final int _LOCAL_HEADER_MIN_LENGTH = 30;
    @SquirrelJMEVendorApi
    protected static final int GPF_ENCODING_UTF8 = 2048;
    @SquirrelJMEVendorApi
    protected final ZipBlockReader owner;
    @SquirrelJMEVendorApi
    protected final BlockAccessor accessor;
    @SquirrelJMEVendorApi
    protected final long position;
    private Reference<String> _name;

    ZipBlockEntry(ZipBlockReader __br, int __id) throws NullPointerException {
        if (__br == null) {
            throw new NullPointerException("NARG");
        }
        this.owner = __br;
        this.accessor = __br._accessor;
        this.position = __br._offsets[__id];
    }

    @SquirrelJMEVendorApi
    public boolean isDirectory() throws IOException, ZipException {
        return this.__internalToString().endsWith("/");
    }

    @SquirrelJMEVendorApi
    public long lastModifiedTime() {
        return Long.MIN_VALUE;
    }

    @SquirrelJMEVendorApi
    public String name() {
        return this.toString();
    }

    @SquirrelJMEVendorApi
    public InputStream open() throws IOException, ZipException {
        byte[] header;
        if (this.isDirectory()) {
            throw new ZipException(String.format("BF0a %s", this.toString()));
        }
        ZipBlockReader owner = this.owner;
        BlockAccessor accessor = this.accessor;
        byte[] data = this.__readCentralDir();
        int ver = __ArrayData__.readUnsignedShort(6, data);
        int made = __ArrayData__.readUnsignedShort(4, data);
        if ((ver & 0xFF00) != 0 && (made & 0xFF00) == (ver & 0xFF00)) {
            ver &= 0xFF;
        }
        if (20 < ver) {
            throw new ZipException(String.format("BF0c %d", ver));
        }
        int method = __ArrayData__.readUnsignedShort(10, data);
        int crc = __ArrayData__.readSignedInt(16, data);
        long compressed = __ArrayData__.readUnsignedInt(20, data);
        long lhoffset = owner._zipbaseaddr + __ArrayData__.readUnsignedInt(42, data);
        if (30 != accessor.read(lhoffset, header = new byte[30], 0, 30)) {
            throw new ZipException("BF0d");
        }
        if (__ArrayData__.readSignedInt(0, header) != 67324752) {
            throw new ZipException("BF0e");
        }
        int lhfnl = __ArrayData__.readUnsignedShort(26, header);
        int lhcml = __ArrayData__.readUnsignedShort(28, header);
        long database = lhoffset + 30L + (long)lhfnl + (long)lhcml;
        __BlockAccessorRegionInputStream__ base = new __BlockAccessorRegionInputStream__(accessor, database, compressed);
        ZipCompressionType ztype = ZipCompressionType.forMethod(method);
        if (ztype == null) {
            throw new ZipException(String.format("BF0f %d", method));
        }
        DecompressionInputStream algo = ztype.inputStream(base);
        return new __CRCInputStream__(algo, crc);
    }

    public String toString() {
        try {
            return this.__internalToString();
        }
        catch (IOException e2) {
            throw new RuntimeException("BF0g", e2);
        }
    }

    @SquirrelJMEVendorApi
    public long uncompressedSize() throws IOException, ZipException {
        byte[] data = this.__readCentralDir();
        return __ArrayData__.readUnsignedInt(24, data);
    }

    private byte[] __readCentralDir() throws IOException, ZipException {
        byte[] data = new byte[46];
        if (46 != this.accessor.read(this.position, data, 0, 46)) {
            throw new ZipException("BF0b");
        }
        return data;
    }

    private String __internalToString() throws IOException, ZipException {
        String rv;
        Reference<String> ref = this._name;
        if (ref == null || null == (rv = ref.get())) {
            byte[] rawname;
            BlockAccessor accessor = this.accessor;
            long position = this.position;
            byte[] data = new byte[46];
            if (46 != accessor.read(position, data, 0, 46)) {
                throw new ZipException("BF0h");
            }
            int fnl = __ArrayData__.readUnsignedShort(28, data);
            if (fnl != accessor.read(position + 46L, rawname = new byte[fnl], 0, fnl)) {
                throw new ZipException("BF0i");
            }
            rv = (__ArrayData__.readUnsignedShort(8, data) & 0x800) != 0 ? new String(rawname, 0, fnl, "utf-8") : new String(rawname, 0, fnl, "ibm437");
            this._name = new WeakReference<String>(rv);
        }
        return rv;
    }
}

