/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.blockreader;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.multiphasicapps.zip.ZipException;
import net.multiphasicapps.zip.blockreader.ArrayBlockAccessor;
import net.multiphasicapps.zip.blockreader.BlockAccessor;
import net.multiphasicapps.zip.blockreader.ZipBlockEntry;
import net.multiphasicapps.zip.blockreader.ZipEntryNotFoundException;
import net.multiphasicapps.zip.blockreader.__ArrayData__;

@SquirrelJMEVendorApi
public class ZipBlockReader
implements Iterable<ZipBlockEntry>,
Closeable {
    private static final int _CENTRAL_DIRECTORY_MAGIC_NUMBER = 33639248;
    private static final int _CENTRAL_DIRECTORY_NAME_LENGTH_OFFSET = 28;
    private static final int _CENTRAL_DIRECTORY_EXTRA_LENGTH_OFFSET = 30;
    private static final int _CENTRAL_DIRECTORY_COMMENT_LENGTH_OFFSET = 32;
    private static final int _CENTRAL_DIRECTORY_MIN_LENGTH = 46;
    private static final int _END_DIRECTORY_MAGIC_NUMBER = 101010256;
    private static final int _END_DIRECTORY_DISK_ENTRIES_OFFSET = 8;
    private static final int _END_DIRECTORY_CENTRAL_DIR_SIZE_OFFSET = 12;
    private static final int _END_DIRECTORY_CENTRAL_DIR_OFFSET_OFFSET = 16;
    private static final int _END_DIRECTORY_MIN_LENGTH = 22;
    private static final int _END_DIRECTORY_MAX_LENGTH = 65557;
    protected final BlockAccessor accessor;
    @SquirrelJMEVendorApi
    protected final int numentries;
    @SquirrelJMEVendorApi
    protected final long cdirbase;
    final long _zipbaseaddr;
    final BlockAccessor _accessor;
    final long[] _offsets;
    private final Reference<ZipBlockEntry>[] _entries;

    @SquirrelJMEVendorApi
    public ZipBlockReader(byte[] __b) throws IOException, NullPointerException {
        this(new ArrayBlockAccessor(__b));
    }

    @SquirrelJMEVendorApi
    public ZipBlockReader(byte[] __b, int __o, int __l) throws ArrayIndexOutOfBoundsException, IOException, NullPointerException {
        this(new ArrayBlockAccessor(__b, __o, __l));
    }

    @SquirrelJMEVendorApi
    public ZipBlockReader(BlockAccessor __b) throws IOException, NullPointerException, ZipException {
        long zipbaseaddr;
        long cdirbase;
        int numentries;
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        this.accessor = __b;
        this._accessor = __b;
        byte[] dirbytes = new byte[22];
        long endat = ZipBlockReader.__locateCentralDirEnd(__b, dirbytes);
        this.numentries = numentries = __ArrayData__.readUnsignedShort(8, dirbytes);
        long csz = __b.size();
        long cdirsize = __ArrayData__.readUnsignedInt(12, dirbytes);
        this.cdirbase = cdirbase = endat - cdirsize;
        if (cdirsize > csz) {
            throw new ZipException(String.format("BF0j %d %d", cdirsize, csz));
        }
        this._zipbaseaddr = zipbaseaddr = csz - (__ArrayData__.readUnsignedInt(16, dirbytes) + cdirsize + (csz - endat));
        if (zipbaseaddr < 0L || zipbaseaddr > csz) {
            throw new ZipException(String.format("BF0k %d %d", zipbaseaddr, csz));
        }
        this._entries = ZipBlockReader.__newEntryReferenceList(numentries);
        this._offsets = this.__readOffsets();
    }

    @Override
    public void close() throws IOException {
        this.accessor.close();
    }

    @SquirrelJMEVendorApi
    public boolean contains(String __s) throws IOException, NullPointerException {
        try {
            return this.get(__s) != null;
        }
        catch (ZipEntryNotFoundException e2) {
            return false;
        }
    }

    @SquirrelJMEVendorApi
    public ZipBlockEntry get(String __s) throws IOException, NullPointerException, ZipEntryNotFoundException {
        if (__s == null) {
            throw new NullPointerException("NARG");
        }
        for (ZipBlockEntry e2 : this) {
            if (!e2.toString().equals(__s)) continue;
            return e2;
        }
        throw new ZipEntryNotFoundException(String.format("BF0l %s", __s));
    }

    @Override
    public Iterator<ZipBlockEntry> iterator() {
        return new __Iterator__();
    }

    @SquirrelJMEVendorApi
    public InputStream open(String __s) throws IOException, NullPointerException, ZipEntryNotFoundException {
        ZipBlockEntry ent = this.get(__s);
        if (ent == null) {
            throw new ZipEntryNotFoundException(String.format("BF0m %s", __s));
        }
        return ent.open();
    }

    @SquirrelJMEVendorApi
    public int size() {
        return this.numentries;
    }

    private long[] __readOffsets() throws IOException {
        int numentries = this.numentries;
        long[] rv = new long[numentries];
        BlockAccessor accessor = this.accessor;
        long at2 = this.cdirbase;
        byte[] cdirent = new byte[46];
        for (int i2 = 0; i2 < numentries; ++i2) {
            rv[i2] = at2;
            if (accessor.read(at2, cdirent, 0, 46) != 46) {
                throw new ZipException(String.format("BF0n %d %d %d", i2, at2, accessor.size()));
            }
            if (__ArrayData__.readSignedInt(0, cdirent) != 33639248) {
                throw new ZipException(String.format("BF0o %d", i2));
            }
            int fnl = __ArrayData__.readUnsignedShort(28, cdirent);
            int cml = __ArrayData__.readUnsignedShort(30, cdirent);
            int edl = __ArrayData__.readUnsignedShort(32, cdirent);
            at2 += (long)(fnl + cml + edl + 46);
        }
        return rv;
    }

    private static long __locateCentralDirEnd(BlockAccessor __b, byte[] __db) throws IOException, NullPointerException {
        if (__b == null || __db == null) {
            throw new NullPointerException("NARG");
        }
        long size = __b.size();
        if (size < 22L) {
            throw new ZipException(String.format("BF0p %d", size));
        }
        long end = Math.max(0L, size - 65557L);
        for (long at2 = size - 22L; at2 >= end; --at2) {
            byte b2 = __b.read(at2);
            if (b2 != 80) continue;
            __b.read(at2, __db, 0, 22);
            if (__ArrayData__.readSignedInt(0, __db) != 101010256 || (long)__ArrayData__.readUnsignedShort(20, __db) != size - (at2 + 22L)) continue;
            return at2;
        }
        throw new ZipException("BF0q");
    }

    private static Reference<ZipBlockEntry>[] __newEntryReferenceList(int __n) {
        return new Reference[__n];
    }

    private class __Iterator__
    implements Iterator<ZipBlockEntry> {
        protected final int numentries;
        private volatile int _next;

        private __Iterator__() {
            this.numentries = ZipBlockReader.this.numentries;
            this._next = 0;
        }

        @Override
        public boolean hasNext() {
            return this._next < this.numentries;
        }

        @Override
        public ZipBlockEntry next() throws NoSuchElementException {
            ZipBlockEntry rv;
            int next = this._next;
            if (next >= this.numentries) {
                throw new NoSuchElementException("NSEE");
            }
            this._next = next + 1;
            Reference[] entries = ZipBlockReader.this._entries;
            Reference ref = entries[next];
            if (ref == null || null == (rv = (ZipBlockEntry)ref.get())) {
                rv = new ZipBlockEntry(ZipBlockReader.this, next);
                entries[next] = new WeakReference<ZipBlockEntry>(rv);
            }
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("RORO");
        }
    }
}

