/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.queue;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.util.SortedTreeMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import net.multiphasicapps.zip.queue.__QueuedOutput__;
import net.multiphasicapps.zip.streamwriter.ZipStreamWriter;

@SquirrelJMEVendorApi
public class ArchiveOutputQueue
implements Closeable {
    @SquirrelJMEVendorApi
    protected final ZipStreamWriter zip;
    @SquirrelJMEVendorApi
    protected final Map<String, Integer> outputFiles = new SortedTreeMap<String, Integer>();
    @SquirrelJMEVendorApi
    private final Reference<ArchiveOutputQueue> _self = new WeakReference<ArchiveOutputQueue>(this);
    private volatile boolean _isClosed;

    @SquirrelJMEVendorApi
    public ArchiveOutputQueue(ZipStreamWriter __zip) throws NullPointerException {
        if (__zip == null) {
            throw new NullPointerException("NARG");
        }
        this.zip = __zip;
    }

    @Override
    public void close() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        for (Map.Entry<String, Integer> entry : this.outputFiles.entrySet()) {
            if (entry.getValue() != null) continue;
            throw new IOException("NC04 " + entry.getKey());
        }
        ZipStreamWriter zip = this.zip;
        zip.flush();
        zip.close();
        zip.flush();
    }

    @SquirrelJMEVendorApi
    public void flush() throws IOException {
        this.zip.flush();
    }

    @SquirrelJMEVendorApi
    public boolean hasOutput(String __file) throws NullPointerException {
        if (__file == null) {
            throw new NullPointerException("NARG");
        }
        return this.outputFiles.containsKey(__file);
    }

    @SquirrelJMEVendorApi
    public OutputStream nextEntry(String __name) throws IOException, NullPointerException {
        if (__name == null) {
            throw new NullPointerException("NARG");
        }
        Map<String, Integer> outputFiles = this.outputFiles;
        if (outputFiles.containsKey(__name)) {
            throw new IOException("NC03 " + __name);
        }
        return new __QueuedOutput__(this._self, __name);
    }

    @SquirrelJMEVendorApi
    public PrintStream nextPrintStream(String __name) throws IOException, NullPointerException {
        return new PrintStream(this.nextEntry(__name), true, "utf-8");
    }

    @SquirrelJMEVendorApi
    public void writeEntry(String __name, byte ... __bytes) throws IOException, NullPointerException {
        if (__name == null || __bytes == null) {
            throw new NullPointerException("NARG");
        }
        try (OutputStream out = this.nextEntry(__name);){
            out.write(__bytes);
        }
    }
}

