/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.queue;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import net.multiphasicapps.io.CRC32Calculator;
import net.multiphasicapps.zip.queue.ArchiveOutputQueue;
import net.multiphasicapps.zip.streamwriter.ZipStreamWriter;

final class __QueuedOutput__
extends OutputStream {
    protected final ByteArrayOutputStream data = new ByteArrayOutputStream();
    protected final Reference<ArchiveOutputQueue> owner;
    protected final String name;
    private volatile boolean _isClosed;

    __QueuedOutput__(Reference<ArchiveOutputQueue> __owner, String __name) throws NullPointerException {
        if (__owner == null || __name == null) {
            throw new NullPointerException("NARG");
        }
        this.name = __name;
        this.owner = __owner;
    }

    @Override
    public void close() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        ArchiveOutputQueue archive = this.owner.get();
        if (archive == null) {
            throw new IllegalStateException("GCGC");
        }
        byte[] bytes = this.data.toByteArray();
        int checksum = CRC32Calculator.calculateZip(bytes);
        ZipStreamWriter zip = archive.zip;
        try (OutputStream out = zip.nextEntry(this.name);){
            out.write(bytes, 0, bytes.length);
            out.flush();
        }
        zip.flush();
        archive.outputFiles.put(this.name, checksum);
    }

    @Override
    public void write(int __b) throws IOException {
        if (this._isClosed) {
            throw new IOException("CLSD");
        }
        this.data.write(__b);
    }

    @Override
    public void write(byte[] __b) throws IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (this._isClosed) {
            throw new IOException("CLSD");
        }
        this.data.write(__b);
    }

    @Override
    public void write(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        if (this._isClosed) {
            throw new IOException("CLSD");
        }
        this.data.write(__b, __o, __l);
    }
}

