/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.streamreader;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.archive.ArchiveStreamEntry;
import java.io.IOException;
import java.io.InputStream;
import net.multiphasicapps.io.CRC32Calculator;
import net.multiphasicapps.io.DecompressionInputStream;
import net.multiphasicapps.io.DynamicHistoryInputStream;
import net.multiphasicapps.zip.ZipCompressionType;
import net.multiphasicapps.zip.ZipException;
import net.multiphasicapps.zip.streamreader.ZipStreamReader;

@SquirrelJMEVendorApi
public final class ZipStreamEntry
extends InputStream
implements ArchiveStreamEntry {
    private static final int _MAX_DESCRIPTOR_SIZE = 16;
    private static final int _HEADERLESS_DESCRIPTOR_SIZE = 12;
    private static final int _DESCRIPTOR_MAGIC_NUMBER = 134695760;
    @SquirrelJMEVendorApi
    protected final CRC32Calculator crc = new CRC32Calculator(true, true, 79764919, -1, -1);
    @SquirrelJMEVendorApi
    protected final ZipStreamReader zipreader;
    @SquirrelJMEVendorApi
    protected final String filename;
    @SquirrelJMEVendorApi
    protected final ZipCompressionType method;
    @SquirrelJMEVendorApi
    protected final DynamicHistoryInputStream dhin;
    @SquirrelJMEVendorApi
    protected final DecompressionInputStream cin;
    @SquirrelJMEVendorApi
    protected final boolean undefined;
    @SquirrelJMEVendorApi
    protected final boolean detectseof;
    @SquirrelJMEVendorApi
    protected final int expectedcrc;
    @SquirrelJMEVendorApi
    protected final int expecteduncompsize;
    @SquirrelJMEVendorApi
    protected final int expectedcompsize;
    private final byte[] _solo = new byte[1];
    private final byte[] _peeking;
    private volatile boolean _closed;
    private volatile long _readuncomp;
    private volatile boolean _eof;

    ZipStreamEntry(ZipStreamReader __zsr, String __fn, boolean __undef, int __crc, int __comp, int __uncomp, ZipCompressionType __method, DynamicHistoryInputStream __ins) throws IOException, NullPointerException {
        DecompressionInputStream dis;
        if (__zsr == null || __fn == null || __method == null || __ins == null) {
            throw new NullPointerException("NARG");
        }
        this.zipreader = __zsr;
        this.filename = __fn;
        this.method = __method;
        this.dhin = __ins;
        this.cin = dis = __method.inputStream(__ins, this.crc);
        this.undefined = __undef;
        this.detectseof = dis.detectsEOF();
        this.expectedcrc = __crc;
        this.expecteduncompsize = __uncomp;
        this.expectedcompsize = __comp;
        this._peeking = __undef ? new byte[16] : null;
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            if (!this._eof) {
                byte[] buf = new byte[4096];
                while (this.read(buf) >= 0) {
                }
            }
            this.zipreader.__closeEntry(this);
        }
    }

    @SquirrelJMEVendorApi
    public ZipCompressionType compressionType() {
        return this.method;
    }

    @Override
    public String name() {
        return this.filename;
    }

    @Override
    public int read() throws IOException {
        int rv;
        byte[] solo = this._solo;
        do {
            if ((rv = this.read(solo, 0, 1)) >= 0) continue;
            return rv;
        } while (rv == 0);
        return solo[0] & 0xFF;
    }

    @Override
    public int read(byte[] __b) throws IOException, NullPointerException {
        return this.read(__b, 0, __b.length);
    }

    @Override
    public int read(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
        if (__b == null) {
            throw new NullPointerException("NARG");
        }
        int n2 = __b.length;
        if (__o < 0 || __l < 0 || __o + __l > n2) {
            throw new IndexOutOfBoundsException("IOOB");
        }
        if (this._eof) {
            return -1;
        }
        if (this.undefined) {
            if (this.detectseof) {
                return this.__detectedRead(__b, __o, __l);
            }
            return this.__probingRead(__b, __o, __l);
        }
        return this.__definedRead(__b, __o, __l);
    }

    private int __definedRead(byte[] __b, int __o, int __l) throws IOException {
        int rc;
        int rest;
        DecompressionInputStream cin = this.cin;
        long cinusz = cin.uncompressedBytes();
        long cincsz = cin.compressedBytes();
        int remun = (int)((long)this.expecteduncompsize - cinusz);
        int remco = (int)((long)this.expectedcompsize - cincsz);
        int n2 = rest = remun == 0 ? remco : remun;
        if (__l > rest) {
            __l = rest;
        }
        if ((rc = this.cin.read(__b, __o, __l)) < 0) {
            this._eof = true;
            CRC32Calculator crc = this.crc;
            int expectedcrc = this.expectedcrc;
            int expecteduncompsize = this.expecteduncompsize;
            int expectedcompsize = this.expectedcompsize;
            if ((long)expecteduncompsize != cinusz || (long)expectedcompsize != cincsz || expectedcrc != crc.checksum()) {
                throw new ZipException(String.format("BF0u %08x %08x %d %d %d %d", expectedcrc, crc.checksum(), expecteduncompsize, cinusz, expectedcompsize, cincsz));
            }
            return -1;
        }
        if (rc == 0 && rest == 0) {
            throw new ZipException(String.format("BF72 %d (%d/%d) (%d/%d) %s", this.expecteduncompsize, cinusz, this.expecteduncompsize, cincsz, this.expectedcompsize, this.filename));
        }
        this._readuncomp += (long)rc;
        return rc;
    }

    private int __detectedRead(byte[] __b, int __o, int __l) throws IOException {
        DecompressionInputStream cin = this.cin;
        int rc = cin.read(__b, __o, __l);
        if (rc >= 0) {
            if (rc == 0 && this._eof) {
                return -1;
            }
            return rc;
        }
        DynamicHistoryInputStream dhin = this.dhin;
        byte[] peeking = this._peeking;
        this._eof = true;
        int probed = dhin.peek(0, peeking, 0, 16);
        if (probed < 12) {
            throw new ZipException(String.format("BF0v %d", probed));
        }
        int offset = 134695760 == ZipStreamReader.__readInt(peeking, 0) ? 4 : 0;
        int ddcrc = ZipStreamReader.__readInt(peeking, offset);
        int ddcomp = ZipStreamReader.__readInt(peeking, offset + 4);
        int dduncomp = ZipStreamReader.__readInt(peeking, offset + 8);
        CRC32Calculator crc = this.crc;
        long cinusz = cin.uncompressedBytes();
        long cincsz = cin.compressedBytes();
        if ((long)dduncomp != cinusz || (long)ddcomp != cincsz || ddcrc != crc.checksum()) {
            throw new ZipException(String.format("BF0w %08x %08x %d %d %d %d", ddcrc, crc.checksum(), dduncomp, cinusz, ddcomp, cincsz));
        }
        return -1;
    }

    private int __probingRead(byte[] __b, int __o, int __l) throws IOException {
        DynamicHistoryInputStream dhin = this.dhin;
        byte[] peeking = this._peeking;
        CRC32Calculator crc = this.crc;
        DecompressionInputStream cin = this.cin;
        int d2 = 0;
        int i2 = __o;
        int e2 = __o + __l;
        while (i2 < e2) {
            int probed = dhin.peek(0, peeking, 0, 16);
            if (probed < 12) {
                throw new ZipException(String.format("BF0x %d", probed));
            }
            int offset = 134695760 == ZipStreamReader.__readInt(peeking, 0) ? 4 : 0;
            int ddcrc = ZipStreamReader.__readInt(peeking, offset);
            int ddcomp = ZipStreamReader.__readInt(peeking, offset + 4);
            int dduncomp = ZipStreamReader.__readInt(peeking, offset + 8);
            if ((long)ddcomp == cin.compressedBytes() && (long)dduncomp == cin.uncompressedBytes() && ddcrc == crc.checksum()) {
                this._eof = true;
                return d2 <= 0 ? -1 : d2;
            }
            int rc = cin.read();
            if (rc < 0) {
                throw new ZipException("BF0y");
            }
            __b[i2] = (byte)rc;
            ++i2;
            ++d2;
        }
        if (d2 == 0 && this._eof) {
            return -1;
        }
        return d2;
    }
}

