/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.streamreader;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.archive.ArchiveStreamReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.multiphasicapps.io.DataEndianess;
import net.multiphasicapps.io.DynamicHistoryInputStream;
import net.multiphasicapps.io.ExtendedDataInputStream;
import net.multiphasicapps.zip.ZipCompressionType;
import net.multiphasicapps.zip.ZipException;
import net.multiphasicapps.zip.streamreader.ZipStreamEntry;

@SquirrelJMEVendorApi
public class ZipStreamReader
implements ArchiveStreamReader,
Closeable {
    private static final int _MAX_EXTRACT_VERSION = 20;
    private static final int _MINIMUM_HEADER_SIZE = 30;
    private static final int _LOCAL_HEADER_MAGIC = 67324752;
    @SquirrelJMEVendorApi
    protected final DynamicHistoryInputStream input;
    @SquirrelJMEVendorApi
    protected final ExtendedDataInputStream data;
    private final byte[] _localheader = new byte[30];
    private volatile ZipStreamEntry _entry;
    private volatile boolean _eof;
    private volatile ZipException _defer;

    @SquirrelJMEVendorApi
    public ZipStreamReader(InputStream __is) throws NullPointerException {
        ExtendedDataInputStream d2;
        DynamicHistoryInputStream q2;
        if (__is == null) {
            throw new NullPointerException("NARG");
        }
        this.input = q2 = new DynamicHistoryInputStream(__is);
        this.data = d2 = new ExtendedDataInputStream(q2);
        d2.setEndianess(DataEndianess.LITTLE);
    }

    @Override
    public void close() throws IOException {
        this._eof = true;
        this.input.close();
        this.data.close();
    }

    @SquirrelJMEVendorApi
    public ZipException deferred() {
        ZipException rv = this._defer;
        this._defer = null;
        return rv;
    }

    @Override
    public ZipStreamEntry nextEntry() throws IOException {
        if (this._entry != null) {
            throw new IOException("BF0z");
        }
        if (this._eof) {
            return null;
        }
        DynamicHistoryInputStream input = this.input;
        ExtendedDataInputStream data = this.data;
        byte[] localheader = this._localheader;
        while (!this._eof) {
            ZipStreamEntry rv;
            ZipCompressionType cmeth;
            int gpfs;
            int rhcount;
            try {
                rhcount = input.peek(0, localheader, 0, 4);
            }
            catch (IndexOutOfBoundsException e2) {
                throw new ZipException("BF10", e2);
            }
            if (rhcount < 4) {
                this._eof = true;
                return null;
            }
            int lhskip = ZipStreamReader.__skipLocalHeader(localheader);
            if (lhskip > 0) {
                try {
                    data.readFully(localheader, 0, lhskip);
                }
                catch (EOFException e3) {
                    this._eof = true;
                }
                continue;
            }
            rhcount = input.peek(0, localheader);
            if (rhcount < 30) {
                this._eof = true;
                return null;
            }
            ZipException defer = null;
            int xver = ZipStreamReader.__readUnsignedShort(localheader, 4) & 0xFF;
            boolean deny = false;
            if (defer == null && (deny |= xver < 0 || xver > 20)) {
                defer = new ZipException(String.format("BF11 %d", xver));
            }
            boolean utf = 0 != ((gpfs = ZipStreamReader.__readUnsignedShort(localheader, 6)) & 0x800);
            boolean undefinedsize = 0 != (gpfs & 8);
            if (defer == null && (deny |= 0 != (gpfs & 1))) {
                defer = new ZipException("BF12");
            }
            if (defer == null && (deny |= (cmeth = ZipCompressionType.forMethod(ZipStreamReader.__readUnsignedShort(localheader, 8))) == null)) {
                defer = new ZipException(String.format("BF13 %s", new Object[]{cmeth}));
            }
            int crc = ZipStreamReader.__readInt(localheader, 14);
            int csz = ZipStreamReader.__readInt(localheader, 18);
            if (!undefinedsize) {
                deny |= csz < 0;
            }
            int usz = ZipStreamReader.__readInt(localheader, 22);
            if (!undefinedsize) {
                deny |= usz < 0;
            }
            if (defer == null && deny) {
                defer = new ZipException(String.format("BF14 %d %d", csz, usz));
            }
            int fnl = ZipStreamReader.__readUnsignedShort(localheader, 26);
            int cml = ZipStreamReader.__readUnsignedShort(localheader, 28);
            if (deny) {
                if (defer != null) {
                    this._defer = defer;
                }
                this.data.readFully(localheader, 0, 4);
                continue;
            }
            data.readFully(localheader);
            byte[] rawname = new byte[fnl];
            data.readFully(rawname);
            String filename = utf ? new String(rawname, 0, fnl, "utf-8") : new String(rawname, 0, fnl, "ibm437");
            data.readFully(localheader, 0, Math.min(cml, 30));
            this._entry = rv = new ZipStreamEntry(this, filename, undefinedsize, crc, csz, usz, cmeth, input);
            return rv;
        }
        this._eof = true;
        return null;
    }

    final void __closeEntry(ZipStreamEntry __ent) throws IOException, NullPointerException {
        if (__ent == null) {
            throw new NullPointerException("NARG");
        }
        if (this._entry != __ent) {
            throw new IOException("BF15");
        }
        this._entry = null;
    }

    static int __readInt(byte[] __b, int __p) {
        return __b[__p] & 0xFF | (__b[__p + 1] & 0xFF) << 8 | (__b[__p + 2] & 0xFF) << 16 | (__b[__p + 3] & 0xFF) << 24;
    }

    static int __readUnsignedShort(byte[] __b, int __p) {
        return __b[__p] & 0xFF | (__b[__p + 1] & 0xFF) << 8;
    }

    private static int __skipLocalHeader(byte[] __b) {
        byte lha = __b[0];
        byte lhb = __b[1];
        byte lhc = __b[2];
        byte lhd = __b[3];
        if (lha == 80 && lhb == 75 && lhc == 3 && lhd == 4) {
            return 0;
        }
        if (lhb == 80 && lhc == 75 && lhd == 3) {
            return 1;
        }
        if (lhc == 80 && lhd == 75) {
            return 2;
        }
        if (lhd == 80) {
            return 3;
        }
        return 4;
    }
}

