/*
 * Decompiled with CFR 0.152.
 */
package net.multiphasicapps.zip.streamwriter;

import cc.squirreljme.runtime.cldc.annotation.SquirrelJMEVendorApi;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import net.multiphasicapps.io.CRC32Calculator;
import net.multiphasicapps.io.DataEndianess;
import net.multiphasicapps.io.ExtendedDataOutputStream;
import net.multiphasicapps.zip.ZipCompressionType;
import net.multiphasicapps.zip.streamwriter.__TOCEntry__;

@SquirrelJMEVendorApi
public class ZipStreamWriter
implements Closeable {
    private static final int _LOCAL_FILE_MAGIC_NUMBER = 67324752;
    private static final int _DATA_DESCRIPTOR_MAGIC_NUMBER = 134695760;
    private static final int _CENTRAL_DIRECTORY_MAGIC_NUMBER = 33639248;
    private static final int _END_DIRECTORY_MAGIC_NUMBER = 101010256;
    private static final long _MAX_FILE_SIZE = 0xFFFFFFFFL;
    private static final int _GENERAL_PURPOSE_FLAGS = 2056;
    @SquirrelJMEVendorApi
    protected final ExtendedDataOutputStream output;
    private final LinkedList<__TOCEntry__> _toc = new LinkedList();
    private boolean _closed;
    private __InnerOutputStream__ _inner;
    private __OuterOutputStream__ _outer;
    private int _bestversion = Math.max(20, ZipCompressionType.DEFLATE.extractVersion());

    @SquirrelJMEVendorApi
    public ZipStreamWriter(OutputStream __os) throws NullPointerException {
        ExtendedDataOutputStream output;
        if (__os == null) {
            throw new NullPointerException("NARG");
        }
        this.output = output = new ExtendedDataOutputStream(__os);
        output.setEndianess(DataEndianess.LITTLE);
    }

    @Override
    public void close() throws IOException {
        if (this._closed) {
            return;
        }
        if (this._inner != null || this._outer != null) {
            throw new IOException("BF16");
        }
        this._closed = true;
        ExtendedDataOutputStream output = this.output;
        LinkedList<__TOCEntry__> toc = this._toc;
        int numtoc = toc.size();
        long cdstart = output.size();
        Debugging.todoNote("Implement correct timestamp.", new Object[0]);
        int time = 31680;
        int date = 19560;
        int bestversion = this._bestversion;
        for (__TOCEntry__ entry : toc) {
            long epos = output.size();
            if (epos > 0xFFFFFFFFL) {
                throw new IOException();
            }
            output.writeInt(33639248);
            output.writeShort(bestversion);
            ZipCompressionType ecomp = entry._compression;
            output.writeShort(ecomp.extractVersion());
            output.writeShort(2056);
            output.writeShort(ecomp.method());
            output.writeShort(time);
            output.writeShort(date);
            output.writeInt(entry._crc);
            output.writeInt((int)entry._compressed);
            output.writeInt((int)entry._uncompressed);
            byte[] efn = entry._name;
            output.writeShort(efn.length);
            output.writeShort(0);
            output.writeShort(0);
            output.writeShort(0);
            output.writeShort(0);
            output.writeInt(0);
            output.writeInt((int)entry._localposition);
            output.write(efn);
        }
        long cdend = output.size();
        output.writeInt(101010256);
        output.writeShort(0);
        output.writeShort(0);
        output.writeShort(numtoc);
        output.writeShort(numtoc);
        output.writeInt((int)(cdend - cdstart));
        output.writeInt((int)cdstart);
        output.writeShort(0);
    }

    @SquirrelJMEVendorApi
    public void flush() throws IOException {
        this.output.flush();
    }

    @SquirrelJMEVendorApi
    public OutputStream nextEntry(String __name) throws IOException, NullPointerException {
        return this.nextEntry(__name, ZipCompressionType.DEFAULT_COMPRESSION);
    }

    @SquirrelJMEVendorApi
    public OutputStream nextEntry(String __name, ZipCompressionType __comp) throws IOException, NullPointerException {
        if (__name == null || __comp == null) {
            throw new NullPointerException("NARG");
        }
        LinkedList<__TOCEntry__> toc = this._toc;
        if (this._closed) {
            throw new IOException("BF17");
        }
        if (this._inner != null || this._outer != null) {
            throw new IOException("BF18");
        }
        if (toc.size() >= 65535) {
            throw new IOException("BF19");
        }
        byte[] utfname = __name.getBytes("utf-8");
        int fnn = utfname.length;
        if (fnn > 65535) {
            throw new IOException(String.format("BF1a %d", fnn));
        }
        __TOCEntry__ last = new __TOCEntry__(this.output.size(), utfname, __comp);
        toc.addLast(last);
        ExtendedDataOutputStream output = this.output;
        output.writeInt(67324752);
        output.writeShort(__comp.extractVersion());
        output.writeShort(2056);
        output.writeShort(__comp.method());
        output.writeShort(0);
        output.writeShort(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeShort(fnn);
        output.writeShort(0);
        output.write(utfname);
        __InnerOutputStream__ inner = new __InnerOutputStream__();
        OutputStream wrapped = __comp.outputStream(inner);
        __OuterOutputStream__ outer = new __OuterOutputStream__(wrapped);
        this._inner = inner;
        this._outer = outer;
        return outer;
    }

    private void __closeEntry() throws IOException {
        int crc;
        LinkedList<__TOCEntry__> toc = this._toc;
        __InnerOutputStream__ inner = this._inner;
        __OuterOutputStream__ outer = this._outer;
        if (inner == null || outer == null) {
            throw new IOException("BF1b");
        }
        inner.flush();
        outer.flush();
        __TOCEntry__ last = toc.getLast();
        long uncomp = outer._size;
        long comp = inner._size;
        if (uncomp >= 0xFFFFFFFFL || comp >= 0xFFFFFFFFL) {
            throw new IOException(String.format("BF1c %d %d", uncomp, comp));
        }
        last._uncompressed = uncomp;
        last._compressed = comp;
        last._crc = crc = outer.crccalc.checksum();
        ExtendedDataOutputStream output = this.output;
        output.writeInt(134695760);
        output.writeInt(crc);
        output.writeInt((int)comp);
        output.writeInt((int)uncomp);
        this._inner = null;
        this._outer = null;
    }

    private final class __OuterOutputStream__
    extends __BaseOutputStream__ {
        protected final CRC32Calculator crccalc;

        private __OuterOutputStream__(OutputStream __os) {
            super(__os);
            this.crccalc = new CRC32Calculator(true, true, 79764919, -1, -1);
        }

        @Override
        public final void close() throws IOException {
            if (this.finished) {
                return;
            }
            this.finished = true;
            this.wrapped.close();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void write(int __b) throws IOException {
            super.write(__b);
            this.crccalc.offer((byte)__b);
        }

        @Override
        public void write(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
            super.write(__b, __o, __l);
            this.crccalc.offer(__b, __o, __l);
        }
    }

    private final class __InnerOutputStream__
    extends __BaseOutputStream__ {
        private __InnerOutputStream__() {
            super(ZipStreamWriter.this.output);
        }

        @Override
        public final void close() throws IOException {
            if (this.finished) {
                return;
            }
            this.finished = true;
            ZipStreamWriter.this.__closeEntry();
        }
    }

    private static abstract class __BaseOutputStream__
    extends OutputStream {
        protected final OutputStream wrapped;
        protected boolean finished;
        volatile int _size;

        private __BaseOutputStream__(OutputStream __os) throws NullPointerException {
            if (__os == null) {
                throw new NullPointerException("NARG");
            }
            this.wrapped = __os;
        }

        @Override
        public abstract void close() throws IOException;

        @Override
        public void flush() throws IOException {
            if (this.finished) {
                return;
            }
            this.wrapped.flush();
        }

        @Override
        public void write(int __b) throws IOException {
            if (this.finished) {
                throw new IOException("BF1d");
            }
            int oldsize = this._size;
            int newsize = oldsize + 1;
            if (newsize < 0 || newsize < oldsize) {
                throw new IOException("BF1e");
            }
            this.wrapped.write(__b);
            this._size = newsize;
        }

        @Override
        public void write(byte[] __b, int __o, int __l) throws IndexOutOfBoundsException, IOException, NullPointerException {
            if (__b == null) {
                throw new NullPointerException("NARG");
            }
            int n2 = __b.length;
            if (__o < 0 || __l < 0 || __o + __l > n2) {
                throw new IndexOutOfBoundsException("IOOB");
            }
            if (this.finished) {
                throw new IOException("BF1f");
            }
            int oldsize = this._size;
            int newsize = oldsize + __l;
            if (newsize < 0 || newsize < oldsize) {
                throw new IOException("BF1g");
            }
            this.wrapped.write(__b, __o, __l);
            this._size = newsize;
        }
    }
}

