/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.OS;

public class ImageList {
    int[] pixbufs;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.pixbufs = new int[4];
    }

    public static int convertSurface(Image image) {
        int n = image.surface;
        int n2 = Cairo.cairo_surface_get_type(n);
        if (n2 != 0) {
            int n3;
            Rectangle rectangle = image.getBoundsInPixels();
            int n4 = Cairo.cairo_surface_get_content(n) == 4096 ? 1 : 0;
            if ((n = Cairo.cairo_image_surface_create(n4, rectangle.width, rectangle.height)) == 0) {
                SWT.error(2);
            }
            if ((n3 = Cairo.cairo_create(n)) == 0) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(n3, 1);
            Cairo.cairo_set_source_surface(n3, image.surface, 0.0, 0.0);
            Cairo.cairo_paint(n3);
            Cairo.cairo_destroy(n3);
        } else {
            Cairo.cairo_surface_reference(n);
        }
        return n;
    }

    public static int createPixbuf(Image image) {
        int n;
        if (OS.USE_CAIRO) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = ImageList.convertSurface(image);
            int n9 = Cairo.cairo_image_surface_get_format(n8);
            boolean bl = n9 == 0;
            n = OS.gdk_pixbuf_new(0, bl, 8, n7 = Cairo.cairo_image_surface_get_width(n8), n6 = Cairo.cairo_image_surface_get_height(n8));
            if (n == 0) {
                SWT.error(2);
            }
            int n10 = OS.gdk_pixbuf_get_rowstride(n);
            int n11 = OS.gdk_pixbuf_get_pixels(n);
            if (OS.BIG_ENDIAN) {
                n5 = 0;
                n4 = 1;
                n3 = 2;
                n2 = 3;
            } else {
                n5 = 3;
                n4 = 2;
                n3 = 1;
                n2 = 0;
            }
            byte[] byArray = new byte[n10];
            int n12 = Cairo.cairo_image_surface_get_data(n8);
            if (bl) {
                for (int i = 0; i < n6; ++i) {
                    OS.memmove(byArray, n12 + i * n10, n10);
                    int n13 = 0;
                    int n14 = 0;
                    while (n13 < n7) {
                        int n15 = byArray[n14 + n5] & 0xFF;
                        int n16 = byArray[n14 + n4] & 0xFF;
                        int n17 = byArray[n14 + n3] & 0xFF;
                        int n18 = byArray[n14 + n2] & 0xFF;
                        byArray[n14 + 3] = (byte)n15;
                        if (n15 != 0) {
                            byArray[n14 + 0] = (byte)((n16 * 255 + n15 / 2) / n15);
                            byArray[n14 + 1] = (byte)((n17 * 255 + n15 / 2) / n15);
                            byArray[n14 + 2] = (byte)((n18 * 255 + n15 / 2) / n15);
                        }
                        ++n13;
                        n14 += 4;
                    }
                    OS.memmove(n11 + i * n10, byArray, n10);
                }
            } else {
                int n19 = Cairo.cairo_image_surface_get_stride(n8);
                byte[] byArray2 = new byte[n19];
                for (int i = 0; i < n6; ++i) {
                    OS.memmove(byArray2, n12 + i * n19, n19);
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    while (n20 < n7) {
                        byte by = byArray2[n22 + n4];
                        byte by2 = byArray2[n22 + n3];
                        byte by3 = byArray2[n22 + n2];
                        byArray[n21 + 0] = by;
                        byArray[n21 + 1] = by2;
                        byArray[n21 + 2] = by3;
                        ++n20;
                        n21 += 3;
                        n22 += 4;
                    }
                    OS.memmove(n11 + i * n10, byArray, n10);
                }
            }
            Cairo.cairo_surface_destroy(n8);
        } else {
            boolean bl;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_pixmap_get_size(image.pixmap, nArray, nArray2);
            int n23 = OS.gdk_colormap_get_system();
            boolean bl2 = bl = image.mask != 0 && OS.gdk_drawable_get_depth(image.mask) == 1;
            if (bl) {
                n = OS.gdk_pixbuf_new(0, true, 8, nArray[0], nArray2[0]);
                if (n == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(n, image.pixmap, n23, 0, 0, 0, 0, nArray[0], nArray2[0]);
                int n24 = OS.gdk_pixbuf_new(0, false, 8, nArray[0], nArray2[0]);
                if (n24 == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(n24, image.mask, 0, 0, 0, 0, 0, nArray[0], nArray2[0]);
                int n25 = OS.gdk_pixbuf_get_rowstride(n);
                int n26 = OS.gdk_pixbuf_get_pixels(n);
                byte[] byArray = new byte[n25];
                int n27 = OS.gdk_pixbuf_get_rowstride(n24);
                int n28 = OS.gdk_pixbuf_get_pixels(n24);
                byte[] byArray3 = new byte[n27];
                for (int i = 0; i < nArray2[0]; ++i) {
                    int n29 = n26 + i * n25;
                    OS.memmove(byArray, n29, n25);
                    int n30 = n28 + i * n27;
                    OS.memmove(byArray3, n30, n27);
                    for (int j = 0; j < nArray[0]; ++j) {
                        if (byArray3[j * 3] != 0) continue;
                        byArray[j * 4 + 3] = 0;
                    }
                    OS.memmove(n29, byArray, n25);
                }
                OS.g_object_unref(n24);
            } else {
                ImageData imageData = image.getImageData(DPIUtil.getDeviceZoom());
                boolean bl3 = imageData.getTransparencyType() == 1;
                n = OS.gdk_pixbuf_new(0, bl3, 8, nArray[0], nArray2[0]);
                if (n == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(n, image.pixmap, n23, 0, 0, 0, 0, nArray[0], nArray2[0]);
                if (bl3) {
                    byte[] byArray = imageData.alphaData;
                    int n31 = OS.gdk_pixbuf_get_rowstride(n);
                    int n32 = OS.gdk_pixbuf_get_pixels(n);
                    byte[] byArray4 = new byte[n31];
                    for (int i = 0; i < nArray2[0]; ++i) {
                        int n33 = n32 + i * n31;
                        OS.memmove(byArray4, n33, n31);
                        for (int j = 0; j < nArray[0]; ++j) {
                            byArray4[j * 4 + 3] = byArray[i * nArray[0] + j];
                        }
                        OS.memmove(n33, byArray4, n31);
                    }
                }
            }
        }
        return n;
    }

    public int add(Image image) {
        int n;
        for (n = 0; n < this.images.length; ++n) {
            if (this.images[n] != null && this.images[n].isDisposed()) {
                OS.g_object_unref(this.pixbufs[n]);
                this.images[n] = null;
                this.pixbufs[n] = 0;
            }
            if (this.images[n] == null) break;
        }
        if (n == this.images.length) {
            Image[] imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
            int[] nArray = new int[this.pixbufs.length + 4];
            System.arraycopy(this.pixbufs, 0, nArray, 0, this.pixbufs.length);
            this.pixbufs = nArray;
        }
        this.set(n, image);
        return n;
    }

    public void dispose() {
        if (this.pixbufs == null) {
            return;
        }
        for (int i = 0; i < this.pixbufs.length; ++i) {
            if (this.pixbufs[i] == 0) continue;
            OS.g_object_unref(this.pixbufs[i]);
        }
        this.images = null;
        this.pixbufs = null;
    }

    public Image get(int n) {
        return this.images[n];
    }

    public int getPixbuf(int n) {
        return this.pixbufs[n];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (image != this.images[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int n) {
        if (n == 0) {
            return -1;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (n != this.pixbufs[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void put(int n, Image image) {
        int n2 = this.images.length;
        if (0 > n || n >= n2) {
            return;
        }
        if (image != null) {
            this.set(n, image);
        } else {
            this.images[n] = null;
            if (this.pixbufs[n] != 0) {
                OS.g_object_unref(this.pixbufs[n]);
            }
            this.pixbufs[n] = 0;
        }
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (image != this.images[i]) continue;
            OS.g_object_unref(this.pixbufs[i]);
            this.images[i] = null;
            this.pixbufs[i] = 0;
        }
    }

    void set(int n, Image image) {
        int n2;
        int n3 = ImageList.createPixbuf(image);
        int n4 = OS.gdk_pixbuf_get_width(n3);
        int n5 = OS.gdk_pixbuf_get_height(n3);
        if (this.width == -1 || this.height == -1) {
            this.width = n4;
            this.height = n5;
        }
        if (n4 != this.width || n5 != this.height) {
            n2 = OS.gdk_pixbuf_scale_simple(n3, this.width, this.height, 2);
            OS.g_object_unref(n3);
            n3 = n2;
        }
        if ((n2 = this.pixbufs[n]) != 0) {
            if (this.images[n] == image) {
                OS.gdk_pixbuf_copy_area(n3, 0, 0, this.width, this.height, n2, 0, 0);
                OS.g_object_unref(n3);
                n3 = n2;
            } else {
                OS.g_object_unref(n2);
            }
        }
        this.pixbufs[n] = n3;
        this.images[n] = image;
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.images.length; ++i) {
            if (this.images[i] == null) continue;
            if (this.images[i].isDisposed()) {
                OS.g_object_unref(this.pixbufs[i]);
                this.images[i] = null;
                this.pixbufs[i] = 0;
            }
            if (this.images[i] == null) continue;
            ++n;
        }
        return n;
    }
}

