/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    int handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';
    private static final int PATH_MAX = 1024;

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            n5 = 0;
            n5 = this.uriMode ? OS.gtk_file_chooser_get_uris(this.handle) : OS.gtk_file_chooser_get_filenames(this.handle);
            int n6 = OS.g_slist_length(n5);
            this.fileNames = new String[n6];
            n4 = n5;
            n3 = 0;
            for (int i = 0; i < n6; ++i) {
                n2 = OS.g_slist_data(n4);
                int n7 = 0;
                if (this.uriMode) {
                    n7 = n2;
                } else {
                    n7 = OS.g_filename_to_utf8(n2, -1, null, null, null);
                    if (n7 == 0) {
                        n7 = OS.g_filename_display_name(n2);
                    }
                }
                if (n2 != n7) {
                    OS.g_free(n2);
                }
                if (n7 != 0) {
                    int[] nArray = new int[1];
                    int n8 = OS.g_utf8_to_utf16(n7, -1, null, nArray, null);
                    OS.g_free(n7);
                    if (n8 != 0) {
                        int n9 = nArray[0];
                        char[] cArray = new char[n9];
                        OS.memmove(cArray, n8, n9 * 2);
                        OS.g_free(n8);
                        this.fullPath = new String(cArray);
                        this.fileNames[n3++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                n4 = OS.g_slist_next(n4);
            }
            if (n3 != 0 && n3 != n6) {
                String[] stringArray = new String[n3];
                System.arraycopy(this.fileNames, 0, stringArray, 0, n3);
                this.fileNames = stringArray;
            }
            OS.g_slist_free(n5);
        } else {
            n5 = 0;
            if (this.uriMode) {
                n5 = OS.gtk_file_chooser_get_uri(this.handle);
            } else {
                int n10 = OS.gtk_file_chooser_get_filename(this.handle);
                if (n10 != 0) {
                    n5 = OS.g_filename_to_utf8(n10, -1, null, null, null);
                    if (n5 == 0) {
                        n5 = OS.g_filename_display_name(n10);
                    }
                    if (n10 != n5) {
                        OS.g_free(n10);
                    }
                }
            }
            if (n5 != 0) {
                int[] nArray = new int[1];
                n4 = OS.g_utf8_to_utf16(n5, -1, null, nArray, null);
                OS.g_free(n5);
                if (n4 != 0) {
                    n3 = nArray[0];
                    char[] cArray = new char[n3];
                    OS.memmove(cArray, n4, n3 * 2);
                    OS.g_free(n4);
                    this.fullPath = new String(cArray);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        n5 = OS.gtk_file_chooser_get_filter(this.handle);
        if (n5 != 0 && (n = OS.gtk_file_filter_get_name(n5)) != 0) {
            n4 = OS.strlen(n);
            byte[] byArray = new byte[n4];
            OS.memmove(byArray, n, n4);
            String string = new String(Converter.mbcsToWcs(byArray));
            for (n2 = 0; n2 < this.filterExtensions.length; ++n2) {
                if (this.filterNames.length > 0) {
                    if (!this.filterNames[n2].equals(string)) continue;
                    this.filterIndex = n2;
                    break;
                }
                if (!this.filterExtensions[n2].equals(string)) continue;
                this.filterIndex = n2;
                break;
            }
        }
        if (this.fullPath != null) {
            int n11 = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n11 + 1);
            this.filterPath = this.fullPath.substring(0, n11);
        }
        return this.fullPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        return this.openChooserDialog();
    }

    String openChooserDialog() {
        Display display;
        byte[] byArray = Converter.wcsToMbcs(this.title, true);
        int n = (this.style & 0x2000) != 0 ? 1 : 0;
        int n2 = this.parent.topHandle();
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? (OS.GTK3 ? OS.gtk_file_chooser_dialog_new(byArray, n2, n, OS.GTK_NAMED_LABEL_CANCEL, -6, OS.GTK_NAMED_LABEL_OK, -5, 0) : OS.gtk_file_chooser_dialog_new(byArray, n2, n, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0)) : (OS.GTK3 ? OS.gtk_file_chooser_dialog_new(byArray, n2, n, OS.GTK_NAMED_LABEL_OK, -5, OS.GTK_NAMED_LABEL_CANCEL, -6, 0) : OS.gtk_file_chooser_dialog_new(byArray, n2, n, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0));
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_window_set_modal(this.handle, true);
        int n3 = OS.gtk_window_get_group(0);
        OS.gtk_window_group_add_window(n3, this.handle);
        int n4 = OS.gtk_window_get_icon_list(n2);
        if (n4 != 0) {
            OS.gtk_window_set_icon_list(this.handle, n4);
            OS.g_list_free(n4);
        }
        if (this.uriMode) {
            OS.gtk_file_chooser_set_local_only(this.handle, false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 0x4000000) != 0) {
            n5 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n6 = OS.g_signal_add_emission_hook(n5, 0, display.emissionProc, this.handle, 0);
        }
        display.sendPreExternalEventDispatchEvent();
        int n7 = OS.gtk_dialog_run(this.handle);
        OS.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n5, n6);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n7 == -5) {
            string = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    void presetChooserDialog() {
        String string;
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.fileName.equals("")) {
                this.fileName = "Untitled";
            }
            if (this.filterPath.length() > 0) {
                if (this.uriMode) {
                    object2 = Converter.wcsToMbcs(this.filterPath, true);
                    OS.gtk_file_chooser_set_current_folder_uri(this.handle, (byte[])object2);
                } else {
                    object2 = Converter.wcsToMbcs(SEPARATOR + this.filterPath, true);
                    if (OS.IsAIX) {
                        object = new byte[1024];
                        n3 = OS.realpath((byte[])object2, object);
                        if (n3 != 0) {
                            OS.gtk_file_chooser_set_current_folder(this.handle, n3);
                        }
                    } else {
                        int n4 = OS.realpath((byte[])object2, null);
                        if (n4 != 0) {
                            OS.gtk_file_chooser_set_current_folder(this.handle, n4);
                            OS.g_free(n4);
                        }
                    }
                }
            }
            if (this.fileName.length() > 0) {
                object2 = new StringBuffer();
                ((StringBuffer)object2).append(this.fileName);
                if (this.fileName.lastIndexOf(46) == -1 && this.filterExtensions.length != 0) {
                    object = null;
                    object = this.filterIndex == -1 ? (Object)this.filterExtensions[0] : (Object)this.filterExtensions[this.filterIndex];
                    String string2 = null;
                    n2 = object.indexOf(59);
                    string2 = n2 == -1 ? object.trim() : object.substring(0, n2).trim();
                    string = string2.substring(n = string2.lastIndexOf(46));
                    if (!this.isGlobPattern(string)) {
                        ((StringBuffer)object2).append(string);
                    }
                }
                object = Converter.wcsToMbcs(((StringBuffer)object2).toString(), true);
                OS.gtk_file_chooser_set_current_name(this.handle, object);
            }
        } else {
            object2 = new StringBuffer();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    ((StringBuffer)object2).append(SEPARATOR);
                }
                ((StringBuffer)object2).append(this.filterPath);
                ((StringBuffer)object2).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuffer)object2).append(this.fileName);
            }
            object = Converter.wcsToMbcs(((StringBuffer)object2).toString(), true);
            if (this.uriMode) {
                OS.gtk_file_chooser_set_uri(this.handle, object);
            } else if (OS.IsAIX) {
                byte[] byArray = new byte[1024];
                n2 = OS.realpath(object, byArray);
                if (n2 != 0) {
                    if (this.fileName.length() > 0) {
                        OS.gtk_file_chooser_set_filename(this.handle, n2);
                    } else {
                        OS.gtk_file_chooser_set_current_folder(this.handle, n2);
                    }
                }
            } else {
                n3 = OS.realpath(object, null);
                if (n3 != 0) {
                    if (this.fileName.length() > 0) {
                        OS.gtk_file_chooser_set_filename(this.handle, n3);
                    } else {
                        OS.gtk_file_chooser_set_current_folder(this.handle, n3);
                    }
                    OS.g_free(n3);
                }
            }
        }
        if ((this.style & 0x2000) != 0) {
            OS.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        int n5 = 0;
        for (int i = 0; i < this.filterExtensions.length; ++i) {
            byte[] byArray;
            byte[] byArray2;
            if (this.filterExtensions[i] == null) continue;
            n3 = OS.gtk_file_filter_new();
            if (this.filterNames.length > i && this.filterNames[i] != null) {
                byArray2 = Converter.wcsToMbcs(this.filterNames[i], true);
                OS.gtk_file_filter_set_name(n3, byArray2);
            } else {
                byArray2 = Converter.wcsToMbcs(this.filterExtensions[i], true);
                OS.gtk_file_filter_set_name(n3, byArray2);
            }
            n2 = 0;
            n = this.filterExtensions[i].indexOf(59);
            while (n != -1) {
                string = this.filterExtensions[i].substring(n2, n);
                byArray = Converter.wcsToMbcs(string, true);
                OS.gtk_file_filter_add_pattern(n3, byArray);
                n2 = n + 1;
                n = this.filterExtensions[i].indexOf(59, n2);
            }
            string = this.filterExtensions[i].substring(n2);
            byArray = Converter.wcsToMbcs(string, true);
            OS.gtk_file_filter_add_pattern(n3, byArray);
            OS.gtk_file_chooser_add_filter(this.handle, n3);
            if (i != this.filterIndex) continue;
            n5 = n3;
        }
        if (n5 != 0) {
            OS.gtk_file_chooser_set_filter(this.handle, n5);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    private boolean isGlobPattern(String string) {
        return string.contains("*") || string.contains("?") || string.contains("[") && string.contains("]");
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    void setURIMode(boolean bl) {
        this.uriMode = bl;
    }
}

