/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.AccelerationEntry;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.DecimalDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComboBoxUI;

class AccelerationDataWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private AccelerationEntry entry = null;
    private boolean pFlag = true;
    private JTextField accelerationXField;
    private JTextField accelerationYField;
    private JTextField accelerationZField;
    private JTextField rollAngleField;
    private JTextField pitchAngleField;
    private JComboBox screenDirectionCombo;
    private JButton setButton;
    private JButton cancelButton;
    private String ILLEGAL_ACCELERATIONX = "1";
    private String ILLEGAL_ACCELERATIONY = "2";
    private String ILLEGAL_ACCELERATIONZ = "3";
    private String ILLEGAL_ROLLANGLE = "4";
    private String ILLEGAL_PITCHANGLE = "5";
    private static final String[] screenDirectionItems = new String[]{"0", "90", "180", "270", "-1"};

    AccelerationDataWindow(MainWindow mainWindow, AccelerationEntry accelerationEntry, boolean bl) {
        super(mainWindow, Resource.getString("ACC_SET_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.entry = accelerationEntry;
        this.pFlag = bl;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("ACC_X_AXIS"));
        JLabel jLabel2 = new JLabel(Resource.getString("ACC_ACCELERATION_SIGN"));
        JLabel jLabel3 = new JLabel(Resource.getString("ACC_Y_AXIS"));
        JLabel jLabel4 = new JLabel(Resource.getString("ACC_ACCELERATION_SIGN"));
        JLabel jLabel5 = new JLabel(Resource.getString("ACC_Z_AXIS"));
        JLabel jLabel6 = new JLabel(Resource.getString("ACC_ACCELERATION_SIGN"));
        JLabel jLabel7 = new JLabel(Resource.getString("ACC_ROLL_ANGLE"));
        JLabel jLabel8 = new JLabel(Resource.getString("ACC_ANGLE_SIGN"));
        JLabel jLabel9 = new JLabel(Resource.getString("ACC_PITCH_ANGLE"));
        JLabel jLabel10 = new JLabel(Resource.getString("ACC_ANGLE_SIGN"));
        JLabel jLabel11 = new JLabel(Resource.getString("ACC_DIRECTION"));
        JLabel jLabel12 = new JLabel(Resource.getString("ACC_ANGLE_SIGN"));
        this.accelerationXField = new JTextField(10);
        this.accelerationYField = new JTextField(10);
        this.accelerationZField = new JTextField(10);
        this.rollAngleField = new JTextField(10);
        this.pitchAngleField = new JTextField(10);
        this.accelerationXField.setDocument(new DecimalDocument(11));
        this.accelerationYField.setDocument(new DecimalDocument(11));
        this.accelerationZField.setDocument(new DecimalDocument(11));
        this.rollAngleField.setDocument(new DecimalDocument(4));
        this.pitchAngleField.setDocument(new DecimalDocument(4));
        this.screenDirectionCombo = new JComboBox<String>(screenDirectionItems);
        this.screenDirectionCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.screenDirectionCombo.setPreferredSize(new Dimension(70, 18));
        this.accelerationXField.setHorizontalAlignment(4);
        this.accelerationYField.setHorizontalAlignment(4);
        this.accelerationZField.setHorizontalAlignment(4);
        this.rollAngleField.setHorizontalAlignment(4);
        this.pitchAngleField.setHorizontalAlignment(4);
        this.accelerationXField.setText(accelerationEntry.getAccelerationX());
        this.accelerationYField.setText(accelerationEntry.getAccelerationY());
        this.accelerationZField.setText(accelerationEntry.getAccelerationZ());
        this.rollAngleField.setText(accelerationEntry.getRoll());
        this.pitchAngleField.setText(accelerationEntry.getPitch());
        for (int i = 0; i < screenDirectionItems.length; ++i) {
            if (!accelerationEntry.getScreenOrientation().equals(screenDirectionItems[i])) continue;
            this.screenDirectionCombo.setSelectedIndex(i);
        }
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("ACC_ACCELERATION_NAME")));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("ACC_TERMINAL_INCLINATION")));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("ACC_MAINSCREEN_DIRECTION")));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout());
        jPanel5.add(jLabel);
        jPanel5.add(this.accelerationXField);
        jPanel5.add(jLabel2);
        jPanel6.add(jLabel3);
        jPanel6.add(this.accelerationYField);
        jPanel6.add(jLabel4);
        jPanel7.add(jLabel5);
        jPanel7.add(this.accelerationZField);
        jPanel7.add(jLabel6);
        jPanel2.add(jPanel5);
        jPanel2.add(jPanel6);
        jPanel2.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout());
        jPanel8.add(jLabel7);
        jPanel8.add(this.rollAngleField);
        jPanel8.add(jLabel8);
        jPanel9.add(jLabel9);
        jPanel9.add(this.pitchAngleField);
        jPanel9.add(jLabel10);
        jPanel3.add(jPanel8);
        jPanel3.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout());
        jPanel10.add(jLabel11);
        jPanel10.add(this.screenDirectionCombo);
        jPanel10.add(jLabel12);
        jPanel4.add(jPanel10);
        jPanel.add(this.setButton);
        jPanel.add(this.cancelButton);
        container.add(jPanel2);
        container.add(jPanel3);
        container.add(jPanel4);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    static boolean checkAcceleration(String string) {
        try {
            int n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    static boolean checkAngle(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return n >= -180 && n < 180;
    }

    void set() {
        boolean bl = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (AccelerationDataWindow.checkAcceleration(this.accelerationXField.getText())) {
            string2 = this.accelerationXField.getText();
        }
        if (AccelerationDataWindow.checkAcceleration(this.accelerationYField.getText())) {
            string3 = this.accelerationYField.getText();
        }
        if (AccelerationDataWindow.checkAcceleration(this.accelerationZField.getText())) {
            string4 = this.accelerationZField.getText();
        }
        if (AccelerationDataWindow.checkAngle(this.rollAngleField.getText())) {
            string5 = this.rollAngleField.getText();
        }
        if (AccelerationDataWindow.checkAngle(this.pitchAngleField.getText())) {
            string6 = this.pitchAngleField.getText();
        }
        string7 = (String)this.screenDirectionCombo.getSelectedItem();
        String string9 = "";
        try {
            if (string2 == null || string2.length() < 1) {
                throw new IllegalArgumentException(this.ILLEGAL_ACCELERATIONX);
            }
            if (string3 == null || string3.length() < 1) {
                throw new IllegalArgumentException(this.ILLEGAL_ACCELERATIONY);
            }
            if (string4 == null || string4.length() < 1) {
                throw new IllegalArgumentException(this.ILLEGAL_ACCELERATIONZ);
            }
            if (string5 == null || string5.length() < 1) {
                throw new IllegalArgumentException(this.ILLEGAL_ROLLANGLE);
            }
            if (string6 == null || string6.length() < 1) {
                throw new IllegalArgumentException(this.ILLEGAL_PITCHANGLE);
            }
            string = string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + "," + string7;
            string8 = this.entry.getEntryId() + ".acc";
            this.entry.save(string, string8, this.pFlag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().equals(this.ILLEGAL_ACCELERATIONX)) {
                string9 = Resource.getString("ACC_X_AXIS");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_ACCELERATIONY)) {
                string9 = Resource.getString("ACC_Y_AXIS");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_ACCELERATIONZ)) {
                string9 = Resource.getString("ACC_Z_AXIS");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_ROLLANGLE)) {
                string9 = Resource.getString("ACC_ROLL_ANGLE");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_PITCHANGLE)) {
                string9 = Resource.getString("ACC_PITCH_ANGLE");
            }
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string9), this, 2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", string8));
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

