/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.AppIconCheck;
import com.nttdocomo.dojaemu.ktoolbar.ProjectFilesPath;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.swing.ImageIcon;

class AppIcon {
    private final String ICON_DIR = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "images" + File.separator;
    private final String ICON_NAME_NORMAL = "normal.gif";
    private final String ICON_NAME_TRUSTED = "trusted.gif";
    private final String ICON_NOT_IN_JAR = "notinjar.gif";
    private final int ICON_SIZE = 24;
    private ProjectFilesPath pfl;
    private ImageIcon iconNormal;
    private ImageIcon iconTrusted;
    private ImageIcon iconNotInJar;

    public AppIcon(String string) {
        this.pfl = new ProjectFilesPath(string);
        this.iconNormal = this.getDefaultIcon("normal.gif");
        this.iconTrusted = this.getDefaultIcon("trusted.gif");
        this.iconNotInJar = this.getDefaultIcon("notinjar.gif");
    }

    private ImageIcon getDefaultIcon(String string) {
        ImageIcon imageIcon = null;
        Image image = null;
        try {
            byte[] byArray = this.getIconBytes(this.ICON_DIR + string);
            AppIconCheck appIconCheck = new AppIconCheck(0);
            int n = appIconCheck.checkFormat(byArray);
            if (n == 0) {
                imageIcon = new ImageIcon(byArray);
            } else if (n == -3) {
                imageIcon = new ImageIcon(byArray);
                image = imageIcon.getImage();
                int n2 = image.getWidth(null);
                int n3 = image.getHeight(null);
                if (n2 > 0 && n3 > 0) {
                    image = image.getScaledInstance(24, 24, 4);
                    imageIcon.setImage(image);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageIcon;
    }

    private boolean checkAppIconAdf(String string) {
        if ((string = string.trim()).length() == 0 || 255 < string.getBytes().length) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (' ' <= cArray[i] && cArray[i] <= '~' && cArray[i] != '/' && cArray[i] != '\\') {
                if (cArray[i] != ',' || (0 >= i || cArray[i - 1] != ' ') && (i >= cArray.length - 1 || cArray[i + 1] != ' ')) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public ImageIcon getImageIcon(String string) {
        ImageIcon imageIcon = null;
        Image image = null;
        String string2 = null;
        try {
            ADF aDF = new ADF(new File(this.pfl.getJamPath(string)));
            string2 = aDF.getProperty("TrustedAPID");
            String string3 = aDF.getProperty("AppIcon");
            if (string3 != null) {
                if (!this.checkAppIconAdf(string3)) {
                    return this.iconNotInJar;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                if (stringTokenizer.countTokens() > 0) {
                    String string4 = stringTokenizer.nextToken();
                    AppIconCheck appIconCheck = new AppIconCheck(1);
                    String string5 = this.pfl.getJarPath(string);
                    byte[] byArray = this.getIconBytes(string5, string4);
                    String string6 = null;
                    if (!(byArray != null && appIconCheck.checkFormat(byArray) == 0 || (byArray = this.getIconBytes(string6 = this.pfl.getResPath(string) + string4)) != null && appIconCheck.checkFormat(byArray) == 0)) {
                        return this.iconNotInJar;
                    }
                    imageIcon = new ImageIcon(byArray);
                    image = imageIcon.getImage();
                    Image image2 = image.getScaledInstance(24, 24, 4);
                    imageIcon.setImage(image2);
                    if (string6 != null) {
                        image = imageIcon.getImage();
                        BufferedImage bufferedImage = new BufferedImage(24, 24, 2);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        graphics2D.drawImage(image, 0, 0, null);
                        graphics2D.drawImage(this.iconNotInJar.getImage(), 0, 0, null);
                        imageIcon.setImage(bufferedImage);
                    }
                    return imageIcon;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        imageIcon = string2 == null ? this.iconNormal : this.iconTrusted;
        return imageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getIconBytes(String string) {
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        byte[] byArray2 = null;
        try {
            fileInputStream = new FileInputStream(string);
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getIconBytes(String string, String string2) {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        JarFile jarFile = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        byte[] byArray2 = null;
        try {
            jarFile = new JarFile(string);
            inputStream = jarFile.getInputStream(jarFile.getEntry(string2));
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray2;
    }
}

