/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AppIconException;
import java.io.ByteArrayInputStream;

class AppIconCheck {
    private final int TRAILER = 59;
    private final int IMAGE_BLOCK = 44;
    private final int EXTENSION_INTRODUCER = 33;
    private final int PLAIN_TEXT_EXTENTION = 1;
    private final int GRAPHIC_CONTROL_EXTENTION = 249;
    private final int COMMENT_EXTENTION = 254;
    private final int APPLICATION_EXTENTION = 255;
    private final int FILE_TYPE_GIF = 0;
    private final int FILE_TYPE_JPEG = 1;
    private final int FILE_TYPE_UNKNOWN = -1;
    private final int[] REGULATION_SIZE = new int[]{24, 48, 96};
    public static final int REGULATION_FORMAT = 0;
    public static final int INVALID_FORMAT = -1;
    public static final int INVALID_SIGVER = -2;
    public static final int INVALID_SIZE = -3;
    public static final int INVALID_INTERLACE = -4;
    public static final int INVALID_ANIMATION = -5;
    public static final int UNDEFINED_ERROR = -99;
    private int nTh;

    public AppIconCheck(int n) {
        this.nTh = n;
    }

    private void checkGifHeader(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n = 0;
        byte[] byArray = new byte[6];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (!string.equals("GIF87a") && !string.equals("GIF89a")) {
            throw new AppIconException(2, "Invalid signature or version");
        }
        byte[] byArray2 = new byte[4];
        byteArrayInputStream.read(byArray2);
        int n2 = byArray2[1] | byArray2[0];
        int n3 = byArray2[3] | byArray2[2];
        if (this.REGULATION_SIZE[this.nTh] != n2 || this.REGULATION_SIZE[this.nTh] != n3) {
            throw new AppIconException(3, "Invalid logical screen size");
        }
        byte by = (byte)byteArrayInputStream.read();
        if ((by & 0x80) != 0) {
            int n4 = (by & 7) + 1;
            n = (int)Math.pow(2.0, n4) * 3;
        }
        byteArrayInputStream.skip(2 + n);
    }

    private void checkImageBlock(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        int n2 = 0;
        byteArrayInputStream.skip(8L);
        byte by = (byte)((byte)byteArrayInputStream.read() & 0xFF);
        if ((by & 0x40) != 0) {
            throw new AppIconException(4, "Interlace image");
        }
        if ((by & 0x80) != 0) {
            n = (by & 7) + 1;
            n2 = (int)Math.pow(2.0, n) * 3;
        }
        byteArrayInputStream.skip(n2 + 1);
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkPlaneText(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        byteArrayInputStream.skip(byteArrayInputStream.read() & 0xFF);
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkGraphicControl(ByteArrayInputStream byteArrayInputStream) throws Exception {
        byteArrayInputStream.skip(byteArrayInputStream.read() & 0xFF);
        if ((byteArrayInputStream.read() & 0xFF) != 0) {
            throw new AppIconException(1, "Invalid Block Terminator");
        }
    }

    private void checkComment(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkApplication(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        byteArrayInputStream.skip(1L);
        byte[] byArray = new byte[11];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (string.equals("NETSCAPE2.0") || string.equals("ANIMEXTS1.0")) {
            bl = true;
        }
        while ((n = byteArrayInputStream.read()) != 0) {
            if (n == 3) {
                byte[] byArray2 = new byte[n];
                byteArrayInputStream.read(byArray2);
                if (byArray2[0] != 1) continue;
                bl2 = true;
                continue;
            }
            byteArrayInputStream.skip(n);
        }
        if (bl && bl2) {
            throw new AppIconException(5, "Animation GIF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkGifFormat(byte[] byArray) {
        int n = 0;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.checkGifHeader(byteArrayInputStream);
            while (true) {
                int n2;
                if ((n2 = byteArrayInputStream.read()) == 59) {
                } else {
                    if (n2 == 44) {
                        this.checkImageBlock(byteArrayInputStream);
                        continue;
                    }
                    if (n2 == 33) {
                        int n3 = byteArrayInputStream.read();
                        if (n3 == 1) {
                            this.checkPlaneText(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 249) {
                            this.checkGraphicControl(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 254) {
                            this.checkComment(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 255) {
                            this.checkApplication(byteArrayInputStream);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (AppIconException appIconException) {
            n = appIconException.getType() * -1;
        }
        catch (Exception exception) {
            n = -99;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return n;
    }

    private void checkJpegFormat(byte[] byArray) throws Exception {
        int n = -1;
        if (byArray.length > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            for (int i = 2; i < byArray.length - 8; ++i) {
                int n2;
                int n3 = byArray[i] & 0xFF;
                int n4 = byArray[i + 1] & 0xFF;
                if (n3 != 255) continue;
                if (n4 == 192 || n4 == 193 || n4 == 194 || n4 == 195 || n4 == 197 || n4 == 198 || n4 == 199 || n4 == 201 || n4 == 202 || n4 == 203 || n4 == 205 || n4 == 206 || n4 == 207) {
                    n2 = (byArray[i + 7] << 8) + (byArray[i + 8] & 0xFF);
                    int n5 = (byArray[i + 5] << 8) + (byArray[i + 6] & 0xFF);
                    if (this.REGULATION_SIZE[this.nTh] != n2 || this.REGULATION_SIZE[this.nTh] != n5) {
                        throw new AppIconException(3, "Invalid logical screen size");
                    }
                    n = 0;
                    break;
                }
                n2 = (byArray[i + 2] << 8) + (byArray[i + 3] & 0xFF);
                i += n2 + 1;
            }
        }
        if (n == -1) {
            throw new AppIconException(1, "Invalid Format");
        }
    }

    private int checkFileType(byte[] byArray) throws Exception {
        int n = -1;
        String string = "";
        if (byArray.length >= 6) {
            string = new String(byArray, 0, 6);
        }
        if (string.equals("GIF87a") || string.equals("GIF89a")) {
            n = 0;
        } else if (byArray.length >= 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            n = 1;
        }
        return n;
    }

    public int checkFormat(byte[] byArray) {
        int n = 0;
        try {
            switch (this.checkFileType(byArray)) {
                case 0: {
                    this.checkGifFormat(byArray);
                    break;
                }
                case 1: {
                    this.checkJpegFormat(byArray);
                    break;
                }
                default: {
                    throw new AppIconException(2, "Invalid signature or version");
                }
            }
        }
        catch (AppIconException appIconException) {
            n = appIconException.getType() * -1;
        }
        catch (Exception exception) {
            n = -99;
        }
        return n;
    }
}

