/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.FontSizeEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;

class AppSettingWindow
extends TabPanel
implements DocumentListener {
    private static final int MIN_HEAP_SIZE = 1000;
    private static final int MAX_HEAP_SIZE = Short.MAX_VALUE;
    private static final String[] TIME_ZONE = new String[]{"---------", "GMT-12:00", "GMT-11:00", "GMT-10:00", "GMT-09:30", "GMT-09:00", "GMT-08:30", "GMT-08:00", "GMT-07:00", "GMT-06:00", "GMT-05:00", "GMT-04:00", "GMT-03:30", "GMT-03:00", "GMT-02:00", "GMT-02:00", "GMT-01:00", "GMT 00:00", "GMT+01:00", "GMT+02:00", "GMT+03:00", "GMT+03:30", "GMT+04:00", "GMT+04:30", "GMT+05:00", "GMT+05:30", "GMT+06:00", "GMT+06:30", "GMT+07:00", "GMT+08:00", "GMT+09:00", "GMT+09:30", "GMT+10:00", "GMT+10:30", "GMT+11:00", "GMT+12:00", "GMT+12:45", "GMT+13:00", "GMT+14:00"};
    private JTextField heapSizeField;
    private JComboBox timezoneComboBox;
    private int currentRegisteredFontIndex = -1;
    private JList fontSizeList;
    public DefaultListModel fontSizeModel;
    private static final String FONTSIZE_FILE = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "fontsize.properties";
    private static final String FONTSIZE_KEY = "EX_FONT_SIZE";

    AppSettingWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        String string;
        int n;
        JLabel jLabel = new JLabel(Resource.getString("HEAP_SIZE"));
        JLabel jLabel2 = new JLabel(Resource.getString("HEAP_UNIT"));
        JLabel jLabel3 = new JLabel(Resource.getString("TIME_ZONE"));
        this.heapSizeField = new JTextField(6);
        this.heapSizeField.setDocument(new HalfNumberDocument(6));
        this.heapSizeField.setText(String.valueOf(this.parent.getHeapMemorySize()));
        this.heapSizeField.getDocument().addDocumentListener(this);
        this.timezoneComboBox = new JComboBox();
        this.timezoneComboBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        for (n = 0; n < TIME_ZONE.length; ++n) {
            this.timezoneComboBox.addItem(TIME_ZONE[n]);
        }
        n = this.parent.getTimeZone();
        String string2 = string = n < 0 ? "GMT-" : "GMT+";
        if (n == 0) {
            string = "GMT 00:00";
        } else if (n == -1) {
            string = "---------";
        } else {
            if ((n *= n < 0 ? -1 : 1) / 60 < 10) {
                string = string + "0";
            }
            string = string + n / 60 + ":";
            if (n % 60 < 10) {
                string = string + "0";
            }
            string = string + n % 60;
        }
        for (int i = 0; i < TIME_ZONE.length; ++i) {
            if (!TIME_ZONE[i].equals(string)) continue;
            this.timezoneComboBox.setSelectedIndex(i);
        }
        this.timezoneComboBox.setActionCommand("selectTimeZone");
        JButton jButton = new JButton(Resource.getString("ADD"));
        JButton jButton2 = new JButton(Resource.getString("DELETE"));
        jButton.setActionCommand("add");
        jButton2.setActionCommand("delete");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.fontSizeModel = new DefaultListModel();
        this.fontSizeList = new JList(this.fontSizeModel);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.setCellRenderer(new FontSizeListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.fontSizeList);
        jScrollPane.setPreferredSize(new Dimension(100, 120));
        try {
            this.loadListItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_HEAP_SIZE")));
        jPanel2.add(jLabel);
        jPanel2.add(this.heapSizeField);
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_TIME_ZONE")));
        jPanel3.add(jLabel3);
        jPanel3.add(this.timezoneComboBox);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_FONT_SIZE")));
        jPanel4.add((Component)jScrollPane, "Center");
        jPanel4.add((Component)jPanel, "East");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        this.add("North", jPanel5);
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.timezoneComboBox.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
    }

    @Override
    boolean set() {
        int n;
        String string = this.heapSizeField.getText().trim();
        int n2 = 0;
        Object[] objectArray = new String[]{String.valueOf(1000), String.valueOf(Short.MAX_VALUE)};
        if (string.length() == 0) {
            try {
                this.parent.showDialog(Resource.format("SPECIFIED_VAL_WNG", Resource.getString("HEAP_SIZE")), this.tabwin, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }
        for (n = 0; n < string.length(); ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            this.parent.showDialog(Resource.format("HEAP_LIMIT_WNG", objectArray), this.tabwin, 2);
            return false;
        }
        n2 = Integer.parseInt(string);
        if (n2 < 1000 || n2 > Short.MAX_VALUE) {
            this.parent.showDialog(Resource.format("HEAP_LIMIT_WNG", objectArray), this.tabwin, 2);
            return false;
        }
        this.parent.setHeapMemorySize(n2);
        if ("---------".equals(TIME_ZONE[this.timezoneComboBox.getSelectedIndex()])) {
            this.parent.setTimeZone(-1);
        } else {
            n = TIME_ZONE[this.timezoneComboBox.getSelectedIndex()].substring(3, 4).equals("-") ? -1 : 1;
            int n3 = Integer.parseInt(TIME_ZONE[this.timezoneComboBox.getSelectedIndex()].substring(4, 6));
            int n4 = Integer.parseInt(TIME_ZONE[this.timezoneComboBox.getSelectedIndex()].substring(7, 9));
            this.parent.setTimeZone((n3 * 60 + n4) * n);
        }
        try {
            this.saveListItem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    void cancel() {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    public void selectTimeZone() {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    void add() {
        FontSizeEditWindow fontSizeEditWindow = new FontSizeEditWindow(this.parent, this);
        fontSizeEditWindow.setLocation(this.parent.getShowLocation(fontSizeEditWindow.getWidth(), fontSizeEditWindow.getHeight(), this.tabwin));
        fontSizeEditWindow.setVisible(true);
        fontSizeEditWindow.dispose();
        if (fontSizeEditWindow.fontSize != null) {
            this.fontSizeModel.add(this.fontSizeModel.getSize(), fontSizeEditWindow.fontSize);
            this.fontSizeList.setSelectedIndex(this.fontSizeModel.getSize() - 1);
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    void delete() {
        if (!this.fontSizeList.isSelectionEmpty()) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("FONT_SIZE_DELETE_WNG", this.fontSizeModel.elementAt(this.fontSizeList.getSelectedIndex())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                int n = this.fontSizeList.getSelectedIndex();
                this.fontSizeModel.remove(n);
                this.listener.tabPanelEvent(this, 1, 0);
            }
        }
    }

    private void loadListItem() throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(FONTSIZE_FILE));
        String[] stringArray = properties.getProperty(FONTSIZE_KEY).split(",");
        this.fontSizeList.removeAll();
        for (int i = 0; i < stringArray.length; ++i) {
            this.fontSizeModel.add(this.fontSizeModel.getSize(), stringArray[i]);
        }
    }

    private void saveListItem() throws FileNotFoundException, IOException {
        String string = "";
        for (int i = 0; i < this.fontSizeModel.getSize(); ++i) {
            string = string + this.fontSizeModel.elementAt(i);
            if (i + 1 == this.fontSizeModel.getSize()) continue;
            string = string + ",";
        }
        Properties properties = new Properties();
        properties.setProperty(FONTSIZE_KEY, string);
        properties.store(new FileOutputStream(FONTSIZE_FILE), "Ex Font Size");
    }

    class FontSizeListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        FontSizeListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }
}

