/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.BMLPropUtil;
import com.nttdocomo.dojaemu.ktoolbar.BMLWindow;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.ComboBoxUI;

public class BMLSettingWindow
extends JDialog {
    private JPanel jContentPane = null;
    private JComboBox affiliationIdComb = null;
    private JComboBox jamNameComb;
    private JTextField parameterText = null;
    private JPanel affiliationPanel = null;
    private JPanel cooperationInfoPanel = null;
    private JPanel buttonPanel = null;
    private JButton settingButton = null;
    private JButton cancelButton = null;
    private MainWindow mainWin;
    private BMLWindow bmlWin;
    private String[] AFFILIATION_ID_ARRAY = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"};
    private boolean isJamNameExists = true;
    private static final String JAM_FILE_EXTENSION = ".jam";

    BMLSettingWindow(MainWindow mainWindow, BMLWindow bMLWindow) {
        super(bMLWindow, Resource.getString("BML_SETTING_WINDOW_TITLE"), true);
        this.mainWin = mainWindow;
        this.bmlWin = bMLWindow;
        this.initialize();
        this.settingButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.settingButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.pack();
    }

    void set() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = (String)this.affiliationIdComb.getSelectedItem();
        if (string == null) {
            string = "";
        }
        String string2 = "";
        if (this.isJamNameExists) {
            string2 = (String)this.jamNameComb.getSelectedItem() + JAM_FILE_EXTENSION;
        }
        hashtable.put("AFFILIATION_ID", string);
        hashtable.put("JAM_NAME", string2);
        hashtable.put("PARAMETER", this.parameterText.getText());
        int n = BMLPropUtil.save(hashtable);
        if (n < 0) {
            this.mainWin.showDialog(Resource.getString("NOT_SET_COOPERATION_INFO"), this, 0);
            return;
        }
        this.bmlWin.setProperties(hashtable);
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getAffiliationPanel(), "North");
            this.jContentPane.add((Component)this.getCooperationInfoPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getAffiliationPanel() {
        if (this.affiliationPanel == null) {
            this.affiliationPanel = new JPanel();
            this.affiliationPanel.setLayout(new FlowLayout(1));
            JLabel jLabel = new JLabel(Resource.getString("BML_AFFILIATION_ID"));
            this.affiliationIdComb = new JComboBox<String>(this.AFFILIATION_ID_ARRAY);
            this.affiliationIdComb.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
            this.affiliationPanel.add(jLabel);
            this.affiliationPanel.add(this.affiliationIdComb);
            String string = (String)this.bmlWin.getProperties().get("AFFILIATION_ID");
            if (string == null) {
                string = "";
            }
            this.affiliationIdComb.setSelectedItem(string);
        }
        return this.affiliationPanel;
    }

    private JComboBox getJamNameComb() {
        String[] stringArray = this.getADFList(this.mainWin.getProjectHome());
        if (stringArray.length == 0) {
            stringArray = new String[]{Resource.getString("BML_NONE_APPLICATION")};
            this.isJamNameExists = false;
        }
        this.jamNameComb = new JComboBox<String>(stringArray);
        this.jamNameComb.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        if (this.isJamNameExists) {
            String string = (String)this.bmlWin.getProperties().get("JAM_NAME");
            if (string == null) {
                string = "";
            }
            if (string.endsWith(JAM_FILE_EXTENSION)) {
                this.jamNameComb.setSelectedItem(string.substring(0, string.length() - 4));
            }
        }
        return this.jamNameComb;
    }

    private JTextField getParameterText() {
        if (this.parameterText == null) {
            String string = (String)this.bmlWin.getProperties().get("PARAMETER");
            if (string == null) {
                string = "";
            }
            this.parameterText = new JTextField(string);
            this.parameterText.setColumns(25);
        }
        return this.parameterText;
    }

    private String[] getADFList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new File(string).list();
        if (stringArray == null) {
            return new String[0];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + File.separator + stringArray[i] + File.separator + "bin" + File.separator;
            String string3 = string2 + stringArray[i] + JAM_FILE_EXTENSION;
            String string4 = string2 + stringArray[i] + ".jar";
            String string5 = string + File.separator + stringArray[i] + File.separator + stringArray[i];
            File file = new File(string3);
            File file2 = new File(string4);
            File file3 = new File(string5);
            if (!file.exists() || !file2.exists()) continue;
            try {
                ADF aDF = new ADF(file);
                String string6 = aDF.getProperty("LaunchByBML");
                if (string6 == null) {
                }
            }
            catch (Exception exception) {}
            continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    private JPanel getCooperationInfoPanel() {
        if (this.cooperationInfoPanel == null) {
            JLabel jLabel = new JLabel(Resource.getString("BML_JAM_FILE_NAME"));
            JLabel jLabel2 = new JLabel(Resource.getString("BML_PARAMETER"));
            this.cooperationInfoPanel = new JPanel();
            this.cooperationInfoPanel.setLayout(new GridLayout(4, 1));
            this.cooperationInfoPanel.add(jLabel);
            this.cooperationInfoPanel.add(this.getJamNameComb());
            this.cooperationInfoPanel.add(jLabel2);
            this.cooperationInfoPanel.add(this.getParameterText());
        }
        return this.cooperationInfoPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getSettingButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getSettingButton() {
        if (this.settingButton == null) {
            this.settingButton = new JButton();
            this.settingButton.setText(Resource.getString("SET"));
        }
        return this.settingButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(Resource.getString("CANCEL"));
        }
        return this.cancelButton;
    }
}

