/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.HostInfoDocument;
import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;

public class BluetoothSettingWindow
extends TabPanel
implements DocumentListener {
    private JPanel mainContainer = null;
    private JPanel ownBTPanel = null;
    private JPanel scanningBTPanel = null;
    private JPanel registeredBTPanel = null;
    private JLabel deviceNameLabel = null;
    private JTextField deviceNameField = null;
    private JLabel bdAddrLabel = null;
    private JPanel bdaddrPanel = null;
    private JLabel deviceTypeLabel = null;
    private JComboBox codListBox = null;
    private JTextField hostField = null;
    private JPanel flowPanel = null;
    private JLabel hostLabel = null;
    private JScrollPane jScrollPane = null;
    private JTable registeredDevice = null;
    private JButton deleteButton = null;
    private JPanel buttonPanel = null;
    private DefaultTableModel defaultTableModel = null;
    private AbstractWindow tabwin;
    private JTextField[] bdAddrFields;
    private int currentRegisteredDeviceIndex = -1;
    private static final int FIELD_COLUMNS = 25;
    private static final int BD_ADDR_COLUMNS = 2;
    private static final String PROPS_FILE = "bluetooth.properties";
    private static final String OWN_SECTION = "OwnDevice";
    private static final String REGISTERED_DEVICE_SECTION = "RegisteredDevice";
    private static final String SCANNING_SECTION = "ScanningDevice";
    private static final String DEVICE_TYPE_ITEM_KEY = "deviceType";
    private static final String DEVICE_NAME_ITEM_KEY = "deviceName";
    private static final String BD_ADDR_ITEM_KEY = "deviceAddr";
    private static final String LAST_SELECTED_ITEM_KEY = "lastSelected";
    private static final String HOST_ITEM_KEY = "host";
    private static final int MAX_DEVICES = 10;
    private static final int COD_VALUE_MOBILE = 516;
    private static final int COD_VALUE_PC = 260;
    private final String[] codLabel = new String[2];

    public BluetoothSettingWindow() {
    }

    public BluetoothSettingWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.tabwin = abstractWindow;
        this.codLabel[0] = Resource.getString("BT_COD_LABEL_MOBILE");
        this.codLabel[1] = Resource.getString("BT_COD_LABEL_PC");
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainContainer(), "North");
        this.loadValue();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    private void setBdAddrValue(String string) {
        JTextField[] jTextFieldArray = this.getBDAddrFields();
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            try {
                jTextFieldArray[i].setText(string.substring(i * 2, i * 2 + 2));
                continue;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                jTextFieldArray[i].setText("00");
            }
        }
    }

    private void loadValue() {
        String string = null;
        IniFileEntity iniFileEntity = new IniFileEntity(System.getProperty("emu.home") + File.separator + "lib" + File.separator + PROPS_FILE);
        try {
            iniFileEntity.read();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                System.err.println(Resource.format("READ_ERR", iniFileEntity.getName()));
            }
            IniFileEntity iniFileEntity2 = new IniFileEntity(System.getProperty("emu.home") + File.separator + "lib" + File.separator + PROPS_FILE);
            iniFileEntity2.setSectionAttribute(OWN_SECTION, DEVICE_NAME_ITEM_KEY, "DoJaBluetooth");
            iniFileEntity2.setSectionAttribute(OWN_SECTION, BD_ADDR_ITEM_KEY, "112233445566");
            iniFileEntity2.setSectionAttribute(OWN_SECTION, DEVICE_TYPE_ITEM_KEY, "516");
            iniFileEntity2.setSectionAttribute(SCANNING_SECTION, HOST_ITEM_KEY, "localhost");
            try {
                iniFileEntity2.save();
                iniFileEntity = iniFileEntity2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.deviceNameField.setText(iniFileEntity.getSectionAttribute(OWN_SECTION, DEVICE_NAME_ITEM_KEY));
        String string2 = iniFileEntity.getSectionAttribute(OWN_SECTION, DEVICE_TYPE_ITEM_KEY);
        int n = 0;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 260;
        }
        switch (n2) {
            case 516: {
                n = 0;
                break;
            }
            case 260: {
                n = 1;
                break;
            }
            default: {
                n = 1;
            }
        }
        this.codListBox.setSelectedIndex(n);
        string = iniFileEntity.getSectionAttribute(OWN_SECTION, BD_ADDR_ITEM_KEY);
        if (string != null) {
            this.setBdAddrValue(string);
        }
        this.hostField.setText(iniFileEntity.getSectionAttribute(SCANNING_SECTION, HOST_ITEM_KEY));
        BluetoothDevice[] bluetoothDeviceArray = new BluetoothDevice[10];
        int n3 = 0;
        for (int i = 0; i < 10; ++i) {
            String string3 = iniFileEntity.getSectionAttribute(REGISTERED_DEVICE_SECTION + i, DEVICE_NAME_ITEM_KEY);
            String string4 = iniFileEntity.getSectionAttribute(REGISTERED_DEVICE_SECTION + i, BD_ADDR_ITEM_KEY);
            String string5 = iniFileEntity.getSectionAttribute(REGISTERED_DEVICE_SECTION + i, DEVICE_TYPE_ITEM_KEY);
            String string6 = iniFileEntity.getSectionAttribute(REGISTERED_DEVICE_SECTION + i, LAST_SELECTED_ITEM_KEY);
            if (string3 == null || string3.equals("")) break;
            BluetoothDevice bluetoothDevice = new BluetoothDevice(string3, string4, string5);
            bluetoothDevice.setLastSelected(string6);
            bluetoothDeviceArray[i] = bluetoothDevice;
            ++n3;
        }
        if (n3 > 0) {
            this.sortDeviceList(bluetoothDeviceArray, n3 - 1);
        }
        this.defaultTableModel = new BTDeviceTableModel(bluetoothDeviceArray);
        this.getRegisteredDevice().setModel(this.defaultTableModel);
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        String string = this.deviceNameField.getText().trim();
        JTextField[] jTextFieldArray = this.getBDAddrFields();
        String[] stringArray = new String[jTextFieldArray.length];
        String string2 = "";
        String string3 = this.hostField.getText().trim();
        if (string.length() == 0) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("BT_NAME_LABEL")), this, 2);
            this.deviceNameField.requestFocus();
            return false;
        }
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            stringArray[i] = jTextFieldArray[i].getText();
            if (stringArray[i].length() != 2) {
                this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("BT_ADDR_LABRL")), this, 2);
                jTextFieldArray[i].requestFocus();
                return false;
            }
            string2 = string2 + stringArray[i];
        }
        IniFileEntity iniFileEntity = new IniFileEntity(System.getProperty("emu.home") + File.separator + "lib" + File.separator + PROPS_FILE);
        iniFileEntity.setSectionAttribute(OWN_SECTION, DEVICE_NAME_ITEM_KEY, string);
        iniFileEntity.setSectionAttribute(OWN_SECTION, BD_ADDR_ITEM_KEY, string2);
        String string4 = String.valueOf(this.codListBox.getSelectedIndex() == 0 ? 516 : 260);
        iniFileEntity.setSectionAttribute(OWN_SECTION, DEVICE_TYPE_ITEM_KEY, string4);
        BluetoothDevice[] bluetoothDeviceArray = ((BTDeviceTableModel)this.defaultTableModel).getDeviceArray();
        for (int i = 0; i < bluetoothDeviceArray.length; ++i) {
            String string5 = REGISTERED_DEVICE_SECTION + i;
            iniFileEntity.setSectionAttribute(string5, DEVICE_NAME_ITEM_KEY, bluetoothDeviceArray[i].getDeviceName());
            iniFileEntity.setSectionAttribute(string5, BD_ADDR_ITEM_KEY, bluetoothDeviceArray[i].getDeviceAddr());
            iniFileEntity.setSectionAttribute(string5, DEVICE_TYPE_ITEM_KEY, String.valueOf(bluetoothDeviceArray[i].getDeviceCodValue()));
            iniFileEntity.setSectionAttribute(string5, LAST_SELECTED_ITEM_KEY, bluetoothDeviceArray[i].getLastSelectedStr());
        }
        iniFileEntity.setSectionAttribute(SCANNING_SECTION, HOST_ITEM_KEY, string3);
        try {
            iniFileEntity.save();
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", iniFileEntity.getName()));
            return true;
        }
        return true;
    }

    void delete() {
        int n;
        if (this.currentRegisteredDeviceIndex != -1 && (n = JOptionPane.showConfirmDialog(this, Resource.getString("BT_DEL_MSG"), Resource.getString("BT_DEL_TITLE"), 0)) == 0) {
            this.defaultTableModel.removeRow(this.currentRegisteredDeviceIndex);
            if (this.listener != null) {
                this.listener.tabPanelEvent(this, 1, 0);
            }
        }
    }

    void deviceTypeChanged() {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    private void swap(BluetoothDevice[] bluetoothDeviceArray, int n, int n2) {
        BluetoothDevice bluetoothDevice = bluetoothDeviceArray[n];
        bluetoothDeviceArray[n] = bluetoothDeviceArray[n2];
        bluetoothDeviceArray[n2] = bluetoothDevice;
    }

    private void quicksort(BluetoothDevice[] bluetoothDeviceArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        long l = bluetoothDeviceArray[(n + n2) / 2].getLastSelected();
        while (true) {
            if (bluetoothDeviceArray[n3].getLastSelected() > l) {
                ++n3;
                continue;
            }
            while (bluetoothDeviceArray[n4].getLastSelected() < l) {
                --n4;
            }
            if (n3 <= n4) {
                this.swap(bluetoothDeviceArray, n3++, n4--);
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quicksort(bluetoothDeviceArray, n, n4);
        }
        if (n3 < n2) {
            this.quicksort(bluetoothDeviceArray, n3, n2);
        }
    }

    private void sortDeviceList(BluetoothDevice[] bluetoothDeviceArray, int n) {
        this.quicksort(bluetoothDeviceArray, 0, n);
    }

    private JPanel getMainContainer() {
        if (this.mainContainer == null) {
            this.mainContainer = new JPanel();
            this.mainContainer.setLayout(new BorderLayout());
            this.mainContainer.add((Component)this.getOwnBTPanel(), "North");
            this.mainContainer.add((Component)this.getRegisteredBTPanel(), "Center");
            this.mainContainer.add((Component)this.getScanningBTPanel(), "South");
        }
        return this.mainContainer;
    }

    private JPanel getOwnBTPanel() {
        if (this.ownBTPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(0, 10, 0, 10);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 0, 0, 3);
            gridBagConstraints4.weightx = 1.0;
            this.deviceTypeLabel = new JLabel();
            this.deviceTypeLabel.setText(Resource.getString("BT_COD_LABEL"));
            this.bdAddrLabel = new JLabel();
            this.bdAddrLabel.setText(Resource.getString("BT_ADDR_LABRL"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(3, 0, 3, 0);
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.anchor = 10;
            gridBagConstraints6.gridx = 0;
            this.deviceNameLabel = new JLabel();
            this.deviceNameLabel.setText(Resource.getString("BT_NAME_LABEL"));
            this.ownBTPanel = new JPanel();
            this.ownBTPanel.setLayout(new GridBagLayout());
            this.ownBTPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("BT_OWN_DEVICE_BORDER_TITLE"), 0, 0, null, null));
            this.ownBTPanel.add((Component)this.deviceNameLabel, gridBagConstraints6);
            this.ownBTPanel.add((Component)this.getDeviceNameField(), gridBagConstraints5);
            this.ownBTPanel.add((Component)this.bdAddrLabel, gridBagConstraints3);
            this.ownBTPanel.add((Component)this.getBdaddrPanel(), gridBagConstraints);
            this.ownBTPanel.add((Component)this.deviceTypeLabel, gridBagConstraints2);
            this.ownBTPanel.add((Component)this.getCodListBox(), gridBagConstraints4);
        }
        return this.ownBTPanel;
    }

    private JPanel getScanningBTPanel() {
        if (this.scanningBTPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            flowLayout.setHgap(0);
            this.scanningBTPanel = new JPanel();
            this.scanningBTPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("BT_SCAN_DEVICE_BORDER_TITLE"), 0, 0, null, null));
            this.scanningBTPanel.setLayout(flowLayout);
            this.scanningBTPanel.add((Component)this.getFlowPanel(), null);
        }
        return this.scanningBTPanel;
    }

    private JPanel getRegisteredBTPanel() {
        if (this.registeredBTPanel == null) {
            this.registeredBTPanel = new JPanel();
            this.registeredBTPanel.setLayout(new BorderLayout());
            this.registeredBTPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("BT_REG_DEVICE_BORDER_TITLE"), 0, 0, null, null));
            this.registeredBTPanel.add((Component)this.getJScrollPane(), "Center");
            this.registeredBTPanel.add((Component)this.getButtonPanel(), "East");
        }
        return this.registeredBTPanel;
    }

    private JTextField getDeviceNameField() {
        if (this.deviceNameField == null) {
            this.deviceNameField = new JTextField(32);
            this.deviceNameField.setColumns(25);
            this.deviceNameField.setDocument(new HalfLetterAndNumberDocument(32));
            this.deviceNameField.getDocument().addDocumentListener(this);
        }
        return this.deviceNameField;
    }

    private JPanel getBdaddrPanel() {
        if (this.bdaddrPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            flowLayout.setVgap(2);
            flowLayout.setHgap(0);
            this.bdaddrPanel = new JPanel();
            this.bdaddrPanel.setLayout(flowLayout);
            JTextField[] jTextFieldArray = this.getBDAddrFields();
            for (int i = 0; i < jTextFieldArray.length - 1; ++i) {
                this.bdaddrPanel.add((Component)jTextFieldArray[i], null);
                this.bdaddrPanel.add((Component)new JLabel(":"), null);
            }
            this.bdaddrPanel.add((Component)jTextFieldArray[jTextFieldArray.length - 1], null);
        }
        return this.bdaddrPanel;
    }

    private JComboBox getCodListBox() {
        if (this.codListBox == null) {
            this.codListBox = new JComboBox();
            this.codListBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
            this.codListBox.addItem(this.codLabel[0]);
            this.codListBox.addItem(this.codLabel[1]);
            this.codListBox.setActionCommand("deviceTypeChanged");
            this.codListBox.addActionListener(new ActionDispatcher(this));
        }
        return this.codListBox;
    }

    private JTextField[] getBDAddrFields() {
        if (this.bdAddrFields == null) {
            this.bdAddrFields = new JTextField[6];
            for (int i = 0; i < this.bdAddrFields.length; ++i) {
                this.bdAddrFields[i] = new JTextField();
                this.bdAddrFields[i].setColumns(2);
                this.bdAddrFields[i].setDocument(new LimitedHexDocument(2));
                this.bdAddrFields[i].getDocument().addDocumentListener(this);
            }
        }
        return this.bdAddrFields;
    }

    private JTextField getHostField() {
        if (this.hostField == null) {
            this.hostField = new JTextField();
            this.hostField.setColumns(25);
            this.hostField.setDocument(new HostInfoDocument(255));
            this.hostField.getDocument().addDocumentListener(this);
        }
        return this.hostField;
    }

    private JPanel getFlowPanel() {
        if (this.flowPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 3, 5, 5);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(7, 28, 7, 28);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            this.hostLabel = new JLabel();
            this.hostLabel.setText(Resource.getString("BT_SCAN_DEVICE_LABEL"));
            this.flowPanel = new JPanel();
            this.flowPanel.setLayout(new GridBagLayout());
            this.flowPanel.add((Component)this.hostLabel, gridBagConstraints2);
            this.flowPanel.add((Component)this.getHostField(), gridBagConstraints);
        }
        return this.flowPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(380, 160));
            this.jScrollPane.setViewportView(this.getRegisteredDevice());
        }
        return this.jScrollPane;
    }

    private JTable getRegisteredDevice() {
        if (this.registeredDevice == null) {
            this.registeredDevice = new JTable(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    super.valueChanged(listSelectionEvent);
                    if (listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() instanceof DefaultListSelectionModel) {
                        BluetoothSettingWindow.this.currentRegisteredDeviceIndex = ((DefaultListSelectionModel)listSelectionEvent.getSource()).getAnchorSelectionIndex();
                    }
                }
            };
            this.registeredDevice.setFont(new Font("MS UI Gothic", 0, 12));
            this.registeredDevice.setCellSelectionEnabled(true);
            this.registeredDevice.setRowSelectionAllowed(true);
            this.registeredDevice.setSelectionMode(0);
            this.registeredDevice.setColumnSelectionAllowed(false);
            this.registeredDevice.setAutoResizeMode(2);
            this.registeredDevice.setShowGrid(true);
            this.registeredDevice.setEnabled(true);
            this.registeredDevice.setDefaultRenderer(Object.class, new BluetoothTableCellRenderer());
        }
        return this.registeredDevice;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButton.setText(Resource.getString("BT_DEL_BUTTON_LABEL"));
            this.deleteButton.setActionCommand("delete");
            this.deleteButton.addActionListener(new ActionDispatcher(this));
        }
        return this.deleteButton;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getDeleteButton(), null);
        }
        return this.buttonPanel;
    }

    class BluetoothTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        BluetoothTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    public class HalfLetterAndNumberDocument
    extends PlainDocument {
        int limit;

        HalfLetterAndNumberDocument(int n) {
            this.limit = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) {
            String string2 = null;
            int n2 = this.getLength();
            try {
                if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                    super.insertString(n, string, attributeSet);
                    return;
                }
                if (n2 >= this.limit) {
                    return;
                }
                if (string != null) {
                    byte[] byArray = string.getBytes();
                    int n3 = string.length();
                    if (n3 != byArray.length) {
                        return;
                    }
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        if (Character.isLetterOrDigit(cArray[i])) continue;
                        return;
                    }
                    string2 = n2 + n3 > this.limit ? string.substring(0, this.limit - n2) : string;
                }
                super.insertString(n, string2, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public class LimitedDocument
    extends PlainDocument {
        int limit;

        LimitedDocument(int n) {
            this.limit = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) {
            try {
                if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                    super.insertString(n, string, attributeSet);
                    return;
                }
                if (this.getLength() >= this.limit) {
                    return;
                }
                super.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public class HalfNumberDocument
    extends PlainDocument {
        int limit;

        HalfNumberDocument(int n) {
            this.limit = n;
        }

        HalfNumberDocument() {
            this.limit = -1;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) {
            try {
                if (this.limit != -1 && this.getLength() >= this.limit) {
                    return;
                }
                if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                    super.insertString(n, string, attributeSet);
                    return;
                }
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    if (Character.isDigit(cArray[i])) continue;
                    return;
                }
                super.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public class LimitedHexDocument
    extends PlainDocument {
        int limit;

        LimitedHexDocument(int n) {
            this.limit = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) {
            try {
                if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                    super.insertString(n, string, attributeSet);
                    return;
                }
                if (this.getLength() >= this.limit) {
                    return;
                }
                if (string != null) {
                    byte[] byArray = string.getBytes();
                    int n2 = string.length();
                    if (n2 != byArray.length) {
                        return;
                    }
                    try {
                        Integer.parseInt(string, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                super.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public class BTDeviceTableModel
    extends DefaultTableModel {
        private ArrayList internalData;

        public BTDeviceTableModel(BluetoothDevice[] bluetoothDeviceArray) {
            super(new String[]{Resource.getString("BT_NAME_LABEL"), Resource.getString("BT_ADDR_LABRL"), Resource.getString("BT_COD_LABEL")}, 0);
            this.internalData = new ArrayList();
            if (bluetoothDeviceArray != null) {
                for (int i = 0; i < bluetoothDeviceArray.length && bluetoothDeviceArray[i] != null; ++i) {
                    this.internalData.add(bluetoothDeviceArray[i]);
                    this.addRow(bluetoothDeviceArray[i].getDeviceInfo());
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void removeRow(int n) {
            super.removeRow(n);
            this.internalData.remove(n);
        }

        public BluetoothDevice[] getDeviceArray() {
            Object[] objectArray = this.internalData.toArray();
            BluetoothDevice[] bluetoothDeviceArray = new BluetoothDevice[objectArray.length];
            for (int i = 0; i < bluetoothDeviceArray.length; ++i) {
                bluetoothDeviceArray[i] = (BluetoothDevice)objectArray[i];
            }
            return bluetoothDeviceArray;
        }
    }

    class BluetoothDevice {
        private String deviceName;
        private String deviceAddr;
        private int deviceCod;
        private long lastSelected;

        BluetoothDevice(String string, String string2, String string3) {
            this.deviceName = string;
            this.deviceAddr = string2;
            try {
                this.deviceCod = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.deviceCod = 260;
            }
        }

        public long getLastSelected() {
            return this.lastSelected;
        }

        public String getLastSelectedStr() {
            return String.valueOf(this.lastSelected);
        }

        public void setLastSelected(String string) {
            try {
                this.lastSelected = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.lastSelected = 0L;
            }
        }

        public String getDeviceAddr() {
            return this.deviceAddr;
        }

        public String getDeviceCod() {
            if (this.deviceCod == 516) {
                return BluetoothSettingWindow.this.codLabel[0];
            }
            return BluetoothSettingWindow.this.codLabel[1];
        }

        public int getDeviceCodValue() {
            return this.deviceCod;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public String[] getDeviceInfo() {
            String[] stringArray = new String[]{this.deviceName, this.deviceAddr, this.deviceCod == 516 ? BluetoothSettingWindow.this.codLabel[0] : BluetoothSettingWindow.this.codLabel[1]};
            return stringArray;
        }
    }
}

