/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.BookmarkEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class BookmarkEntryWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private JTextField nameField;
    private JTextField urlField;
    private static final File bookmarkDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "bookmark");
    private BookmarkEntry entry;

    BookmarkEntryWindow(MainWindow mainWindow, BookmarkEntry bookmarkEntry) {
        super(mainWindow, Resource.getString("BOOKMARK_ENTRY_WINDOW_TITLE"));
        this.entry = bookmarkEntry;
        this.addWindowListener();
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("BOOKMARK_NAME"));
        JLabel jLabel2 = new JLabel(Resource.getString("BOOKMARK_URL"));
        this.nameField = new JTextField(32);
        this.urlField = new JTextField(32);
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel.add(jLabel);
        jPanel.add(this.nameField);
        jPanel2.add(jLabel2);
        jPanel2.add(this.urlField);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jPanel3);
        container.add("Center", jPanel4);
        container.add("South", jPanel5);
        this.setResizable(true);
        this.pack();
    }

    void set() {
        if (this.urlField.getText().length() == 0) {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("BOOKMARK_NAME")), this, 2);
        } else {
            String string = this.urlField.getText();
            if (!string.startsWith("http://") && !string.startsWith("https://")) {
                this.parent.showDialog(Resource.format("INPUT_FORMAT_ERR", Resource.getString("BOOKMARK_URL")), this, 2);
            } else if (string.getBytes().length > 256) {
                this.parent.showDialog(Resource.format("INPUT_LENGTH_ERR", Resource.getString("BOOKMARK_URL")), this, 2);
            } else if (!this.isAscii(string)) {
                this.parent.showDialog(Resource.format("INPUT_FORMAT_ERR", Resource.getString("BOOKMARK_URL")), this, 2);
            } else {
                this.entry.setBookmarkName(this.nameField.getText());
                this.entry.setUrl(this.urlField.getText());
                String string2 = bookmarkDir + File.separator + this.entry.getNo() + ".bmk";
                if (this.entry.save(string2) != 0) {
                    this.parent.showDialog(Resource.format("WRITE_ERR", string2), this, 2);
                }
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean isAscii(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

