/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CompassDataWindow
extends TabPanel {
    private JTextField degreeField;
    private JTextField decimalField;
    private JButton setButton;
    private String directionData = "000.00000";
    private String ILLEGAL_DIRECTION = "1";
    private static final int DECIMAL_COLUMN = 6;

    CompassDataWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.loadCompassDataFile();
        JLabel jLabel = new JLabel(Resource.getString("COMPASS_MAGNETIC_NORTH"));
        JLabel jLabel2 = new JLabel(".");
        this.setButton = new JButton(Resource.getString("SET"));
        this.degreeField = new JTextField(3);
        this.decimalField = new JTextField(6);
        this.degreeField.setHorizontalAlignment(4);
        this.decimalField.setHorizontalAlignment(2);
        this.degreeField.setDocument(new HalfNumberDocument(3));
        this.decimalField.setDocument(new HalfNumberDocument(6));
        this.degreeField.setText(this.getDegreePart(this.directionData, 0));
        this.decimalField.setText(this.getDegreePart(this.directionData, 1));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jLabel);
        jPanel.add(this.degreeField);
        jPanel.add(jLabel2);
        jPanel.add(this.decimalField);
        jPanel2.add(this.setButton);
        this.add("Center", jPanel);
        this.add("South", jPanel2);
        this.setButton.setActionCommand("set");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
    }

    private String getCompassDataPath() {
        return System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "compass.dat";
    }

    private void loadCompassDataFile() {
        File file = new File(this.getCompassDataPath());
        BufferedReader bufferedReader = null;
        if (file.exists() && file.isFile()) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.directionData = string;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveCompassDataFile() {
        boolean bl = true;
        boolean bl2 = true;
        String string = this.parseDegreeDirection();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string2 = "";
        try {
            if (string == null) {
                throw new IllegalArgumentException(this.ILLEGAL_DIRECTION);
            }
            bufferedWriter = new BufferedWriter(new FileWriter(this.getCompassDataPath(), false));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", this.getCompassDataPath()));
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().equals(this.ILLEGAL_DIRECTION)) {
                string2 = Resource.getString("COMPASS_DIRECTION_ANGLE");
            }
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string2), this, 2);
            bl = false;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    private String parseDegreeDirection() {
        int n = 0;
        int n2 = 0;
        String string = this.degreeField.getText();
        String string2 = this.decimalField.getText();
        String string3 = null;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return null;
        }
        if (n >= 0 && n < 360) {
            if (string.length() == 1) {
                string = "00" + string;
            } else if (string.length() == 2) {
                string = "0" + string;
            }
            String string4 = this.getDecimalString(string2, 6);
            string3 = string + "." + string4;
        }
        return string3;
    }

    private String getDegreePart(String string, int n) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 2) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    string2 = string3;
                    break;
                }
                case 1: {
                    string2 = string4;
                }
            }
        }
        return string2;
    }

    @Override
    boolean set() {
        this.saveCompassDataFile();
        return true;
    }

    @Override
    void cancel() {
    }

    private String getDecimalString(String string, int n) {
        String string2 = null;
        if (string.length() < 0 || n < 1) {
            string2 = null;
        } else {
            string2 = string;
            while (string2.length() < n) {
                string2 = string2 + "0";
            }
        }
        return string2;
    }
}

