/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractFrame;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class ConnectWindow
extends AbstractFrame {
    private static final int FRAME_WIDTH = 300;
    private static final int FRAME_HEIGHT = 150;
    private static final int MAX_PARAM_NUM = 16;
    private static final int MAX_PARAM_LEN = 255;
    private JTextField urlField;
    private String adfUrl;
    private JRadioButton trustedOnRadioButton;
    private JRadioButton trustedOffRadioButton;
    private Hashtable parameters = new Hashtable();
    private byte[] byteParam;
    private int paramLen;
    private int type;
    private static final String JAMPropertyPath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "JAM.properties";

    private static String getParamPath(String string) {
        String string2 = string.substring(0, string.length() - 4);
        return System.getProperty("emu.home") + File.separator + "apps" + File.separator + string2 + File.separator + "res" + File.separator + string2 + ".param";
    }

    ConnectWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("CONNECT_WINDOW_TITLE"));
        this.makeConnectWindow();
    }

    private void makeConnectWindow() {
        this.addWindowListener();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JButton jButton = new JButton(Resource.getString("LAUNCH"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.setActionCommand("launch");
        jButton2.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        this.urlField = new JTextField(20);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        this.trustedOnRadioButton = new JRadioButton("ON", true);
        this.trustedOffRadioButton = new JRadioButton("OFF");
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel.add(new JLabel(Resource.getString("URL_ADF")));
        jPanel.add(this.urlField);
        jPanel2.add(new JLabel(Resource.getString("TRUSTEDAPID")));
        buttonGroup.add(this.trustedOnRadioButton);
        buttonGroup.add(this.trustedOffRadioButton);
        jPanel6.add(this.trustedOnRadioButton);
        jPanel6.add(this.trustedOffRadioButton);
        jPanel3.add(jPanel6);
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        container.add("Center", jPanel4);
        container.add("South", jPanel5);
        this.setResizable(false);
        this.setSize(300, 150);
    }

    void launch() {
        String string = "";
        this.adfUrl = this.urlField.getText().trim();
        if (this.adfUrl.length() == 0) {
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(JAMPropertyPath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(Resource.format("NOT_FOUND_ERR", JAMPropertyPath));
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", JAMPropertyPath));
            return;
        }
        String string2 = properties.getProperty(this.adfUrl);
        if (string2 == null) {
            string = Resource.getString("NOT_APPLICATION_WNG");
            string = Resource.getString("NOT_LAUNCH_APPLICATION_WNG2") + string;
            this.parent.showDialog(string, this, 2);
            return;
        }
        this.type = this.trustedOnRadioButton.isSelected() ? 3 : 2;
        this.byteParam = this.getConnectParam(string2) ? JAMManager.getParams(this.parameters) : new byte[]{0};
        StringBuffer stringBuffer = new StringBuffer("");
        if (JAMManager.check(this.type, this.adfUrl, "", stringBuffer)) {
            try {
                this.parent.setVisibleInvoker(this.type, false);
                JAMManager.invokeApplication(JAMManager.getAdfPath(), JAMManager.getJarPath(), 7, this.byteParam, this.parent.getDeviceName(), this.parent.getAdfUrl(), JAMManager.getProjectName(), DebugTraceWindow.getDebugParam());
            }
            catch (Exception exception) {
                this.parent.setVisibleInvoker(this.type, true);
                this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
                return;
            }
            this.parent.setEnabledDeviceMenu(false);
        } else if (stringBuffer.toString().equals(Resource.getString("NOT_APPLICATION_WNG"))) {
            Object[] objectArray = new String[]{this.adfUrl};
            string = Resource.format("NOT_LAUNCH_APPLICATION_WNG", objectArray) + stringBuffer;
            this.parent.showDialog(string, this, 2);
        } else {
            string = Resource.getString("NOT_LAUNCH_APPLICATION_WNG2") + stringBuffer;
            this.parent.showDialog(string, this, 2);
        }
        this.parent.closeWindow(this);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getConnectParam(String string) {
        this.parameters.clear();
        this.paramLen = 0;
        String string2 = "";
        BufferedReader bufferedReader = null;
        String string3 = ConnectWindow.getParamPath(string);
        File file = new File(string3);
        if (!file.exists()) {
            return false;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string3)));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.toLowerCase().indexOf("\"=\"");
                if (n == -1) {
                    System.err.println(Resource.format("PARAM_ERR", string2));
                    continue;
                }
                String string4 = string2.substring(0, n + 1);
                String string5 = string2.substring(n + 2, string2.length());
                if (string4.indexOf("\"") != 0 || string4.lastIndexOf("\"") != string4.length() - 1 || string5.indexOf("\"") != 0 || string5.lastIndexOf("\"") != string5.length() - 1) {
                    System.err.println(Resource.format("PARAM_ERR", string2));
                    continue;
                }
                if (string4.equals("\"\"")) {
                    System.err.println(Resource.format("PARAM_ERR", string2));
                    continue;
                }
                string4 = string4.substring(1, string4.length() - 1);
                string5 = string5.equals("\"\"") ? "" : string5.substring(1, string5.length() - 1);
                this.parameters.put(string4, string5);
                this.paramLen = this.paramLen + string4.getBytes().length + string5.getBytes().length;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(Resource.format("NOT_FOUND_ERR", string3));
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", string3));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }
}

