/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.DTVParameter;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SDF;
import com.nttdocomo.dojaemu.ktoolbar.StringChecker;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComboBoxUI;

class DTVProgramWindow
extends JDialog {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private JComboBox cmbADFFileName;
    private DTVParameter parameter;
    private String projectPath;
    private String adfFileName;
    private boolean saveFlag;

    DTVProgramWindow(JFrame jFrame, String string, DTVParameter dTVParameter) {
        super(jFrame, Resource.getString("DTV_LBL_SET_PROGRAM_GUIDE"), true);
        this.projectPath = string;
        this.parameter = dTVParameter;
        this.saveFlag = false;
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("DTV_LBL_PROGRAM_GUIDE_ADF"));
        jLabel.setHorizontalAlignment(2);
        jLabel.setVerticalAlignment(3);
        String[] stringArray = this.getADFList(string);
        if (stringArray.length == 0) {
            stringArray = new String[]{Resource.getString("DTV_MSG_NONE_PROGRAM_GUIDE")};
        }
        this.cmbADFFileName = new JComboBox<String>(stringArray);
        this.cmbADFFileName.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.adfFileName = this.parameter.getADFFileName();
        if (this.adfFileName.endsWith(".jam")) {
            int n = 0;
            if (this.adfFileName.startsWith("http://") || this.adfFileName.startsWith("https://")) {
                n = this.adfFileName.lastIndexOf("/") + 1;
            }
            this.adfFileName = this.adfFileName.substring(n, this.adfFileName.length() - ".jam".length());
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(this.adfFileName)) continue;
                this.cmbADFFileName.setSelectedIndex(i);
            }
        }
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 20, 5));
        jPanel.add(jLabel);
        jPanel.add(this.cmbADFFileName);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        container.add("North", new JPanel());
        container.add("West", new JPanel());
        container.add("East", new JPanel());
        container.add("Center", jPanel);
        container.add("South", jPanel2);
        this.pack();
        this.setSize(new Dimension(jFrame.getWidth(), this.getHeight()));
        this.setResizable(false);
    }

    private String[] getADFList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new File(string).list();
        if (stringArray == null) {
            return new String[0];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + File.separator + stringArray[i] + File.separator + "bin" + File.separator;
            String string3 = string2 + stringArray[i] + ".jam";
            String string4 = string2 + stringArray[i] + ".jar";
            String string5 = string + File.separator + stringArray[i] + File.separator + stringArray[i];
            File file = new File(string3);
            File file2 = new File(string4);
            File file3 = new File(string5);
            if (!file.exists() || !file2.exists()) continue;
            try {
                ADF aDF = new ADF(file);
                SDF sDF = new SDF(file3);
                sDF.parseSDF(aDF);
                String string6 = sDF.getProperty("LaunchByDTV");
                String string7 = aDF.getProperty("TrustedAPID");
                if (string6 == null || !string6.equals("YES") || string7 == null || string7.trim().length() != 11) continue;
                if (!new StringChecker(string7).isHalfNumber()) {
                }
            }
            catch (Exception exception) {}
            continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    void set() {
        this.saveFlag = true;
        this.setVisible(false);
    }

    void cancel() {
        this.setVisible(false);
    }

    public boolean showWindow() {
        this.setVisible(true);
        if (this.saveFlag) {
            String string = (String)this.cmbADFFileName.getSelectedItem() + ".jam";
            this.parameter.setADFFileName(string);
        }
        this.dispose();
        return this.saveFlag;
    }
}

