/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.AbstractFrame;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DTVMonitor;
import com.nttdocomo.dojaemu.ktoolbar.DTVParameter;
import com.nttdocomo.dojaemu.ktoolbar.DTVProgramWindow;
import com.nttdocomo.dojaemu.ktoolbar.DTVProperty;
import com.nttdocomo.dojaemu.ktoolbar.DTVSelectWindow;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SDF;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class DTVWindow
extends AbstractFrame {
    private static final int FRAME_WIDTH = 280;
    private static final int FRAME_HEIGHT = 320;
    private JLabel lblServiceId;
    private JLabel lblFrequency;
    private JLabel lblAffiliationId;
    private JPanel pnlProgramInfo;
    private DTVParameter parameter;
    private DTVProperty property;
    private boolean appResumeFlag;
    private boolean infoVisibleFlag = true;
    private int dtvTaskStatus;
    private boolean dtvEndFlag;
    private boolean limitTimeFlag;

    DTVWindow(MainWindow mainWindow, int n) {
        super(mainWindow, Resource.getString("DTV_WINDOW_TITLE"));
        this.addWindowListener();
        this.parent = mainWindow;
        this.dtvTaskStatus = n;
        this.appResumeFlag = false;
        this.dtvEndFlag = false;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.property = new DTVProperty();
        this.parameter = this.property.getProperty();
        this.pnlProgramInfo = this.getProgramInfoPanel();
        container.add("North", this.getDTVImagePanel());
        container.add("Center", this.pnlProgramInfo);
        container.add("South", this.getButtonPanel());
        this.pack();
        this.setResizable(false);
    }

    private JPanel getDTVImagePanel() {
        DTVMonitor dTVMonitor = new DTVMonitor(this.parameter, this.parent, this.dtvTaskStatus);
        dTVMonitor.addMouseListener(new DTVMouseListener());
        dTVMonitor.setLayout(new FlowLayout(1));
        return dTVMonitor;
    }

    private JPanel getProgramInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("DTV_LBL_SELECTED_PROGRAM_INFO")));
        jPanel.setLayout(new GridLayout(3, 2, 15, 5));
        this.lblServiceId = new JLabel();
        this.lblFrequency = new JLabel();
        this.lblAffiliationId = new JLabel();
        this.updateDTVParameterInfo();
        JLabel jLabel = new JLabel(Resource.getString("DTV_LBL_SERVICE_ID"));
        JLabel jLabel2 = new JLabel(Resource.getString("DTV_LBL_FREQUENCY"));
        JLabel jLabel3 = new JLabel(Resource.getString("DTV_LBL_AFFILIATION_ID"));
        jLabel.setHorizontalAlignment(4);
        jLabel2.setHorizontalAlignment(4);
        jLabel3.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        jPanel.add(this.lblServiceId);
        jPanel.add(jLabel2);
        jPanel.add(this.lblFrequency);
        jPanel.add(jLabel3);
        jPanel.add(this.lblAffiliationId);
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2, 3, 10));
        JButton jButton = new JButton(Resource.getString("DTV_LBL_SELECT_PROGRAM"));
        JButton jButton2 = new JButton(Resource.getString("DTV_LBL_SET_PROGRAM_GUIDE"));
        JButton jButton3 = new JButton(Resource.getString("DTV_LBL_RUN_PROGRAM_GUIDE"));
        JButton jButton4 = new JButton(Resource.getString("FC_EXIT"));
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        jButton4.addActionListener(actionDispatcher);
        jButton.setActionCommand("select");
        jButton2.setActionCommand("setIAppAdf");
        jButton3.setActionCommand("launch");
        jButton4.setActionCommand("cancel");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        return jPanel;
    }

    private void updateDTVParameterInfo() {
        int n = this.parameter.getServiceId();
        if (n == -1) {
            this.lblServiceId.setText("--");
        } else {
            this.lblServiceId.setText(String.valueOf(n));
        }
        int n2 = this.parameter.getFrequency();
        if (n2 == -1) {
            this.lblFrequency.setText("--");
        } else {
            this.lblFrequency.setText(String.valueOf(n2));
        }
        int n3 = this.parameter.getAffiliationId();
        if (n3 == -1) {
            this.lblAffiliationId.setText("--");
        } else {
            this.lblAffiliationId.setText(String.valueOf(n3));
        }
    }

    void setParameter(DTVParameter dTVParameter) {
        try {
            this.parameter.setFrequency(dTVParameter.getFrequency());
            this.parameter.setServiceId(dTVParameter.getServiceId());
            this.parameter.setAffiliationId(dTVParameter.getAffiliationId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.updateDTVParameterInfo();
    }

    void select() {
        DTVSelectWindow dTVSelectWindow = new DTVSelectWindow(this, this.parameter);
        dTVSelectWindow.setLocation(this.parent.getShowLocation(dTVSelectWindow.getWidth(), dTVSelectWindow.getHeight(), this));
        if (dTVSelectWindow.showWindow()) {
            this.property.store();
            this.updateDTVParameterInfo();
            this.repaint();
        }
    }

    void setIAppAdf() {
        DTVProgramWindow dTVProgramWindow = new DTVProgramWindow(this, this.parent.getProjectHome(), this.parameter);
        dTVProgramWindow.setLocation(this.parent.getShowLocation(dTVProgramWindow.getWidth(), dTVProgramWindow.getHeight(), this));
        if (dTVProgramWindow.showWindow()) {
            this.property.store();
        }
        this.updateSDF();
    }

    private boolean isSameIAppAdf() {
        String string = this.parameter.getADFFileName();
        if (string == null || string.equals("") || !string.endsWith(".jam")) {
            return false;
        }
        if (string.startsWith("http://") || string.startsWith("https://")) {
            int n = string.lastIndexOf("/");
            string = string.substring(n + 1);
        }
        string = string.substring(0, string.lastIndexOf(".jam"));
        string = this.parent.getProjectHome() + File.separator + string + File.separator + "bin" + File.separator + string + ".jam";
        string = string.toLowerCase();
        String string2 = null;
        string2 = this.parent.projectName == null || JAMManager.getLaunch() == 17 ? JAMManager.getProjectNameString() : this.parent.projectName;
        String string3 = this.parent.getJamPath(string2).toLowerCase();
        return string3.equals(string);
    }

    private int showDTVDialog(String string, String string2) {
        JOptionPane jOptionPane = new JOptionPane(string2, 3, 0);
        JDialog jDialog = jOptionPane.createDialog(this, string);
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 1;
    }

    private boolean waitTerminate() {
        this.limitTimeFlag = false;
        Timer timer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTVWindow.this.limitTimeFlag = true;
            }
        });
        JAMManager.exitChildWithCode(1);
        timer.setRepeats(false);
        timer.start();
        while (!this.limitTimeFlag && JAMManager.getState() != 4) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        timer.stop();
        return this.limitTimeFlag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void launch() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.parameter.getFrequency();
        int n3 = this.parameter.getServiceId();
        if (JAMManager.getState() == 3) {
            if (!this.isSameIAppAdf()) {
                n = this.showDTVDialog(Resource.getString("CONFIRM"), Resource.getString("DTV_MSG_SWITCH_PROGRAM_GUIDE"));
                if (n != 0) return;
                this.appResumeFlag = false;
                if (this.waitTerminate()) {
                    this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
                    return;
                }
            } else {
                if (JAMManager.getLaunch() != 3) {
                    this.appResumeFlag = true;
                    this.parent.closeWindow(this);
                    return;
                }
                this.appResumeFlag = false;
                if (this.waitTerminate()) {
                    this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
                    return;
                }
            }
        } else {
            if (JAMManager.getState() != 4) {
                String string = Resource.getString("EXIT_CONNECT_WNG");
                this.parent.showDialog(string, this, 2);
                return;
            }
            n = this.showDTVDialog(Resource.getString("CONFIRM"), Resource.getString("LAUNCH_APPLICATION"));
            if (n != 0) {
                return;
            }
        }
        if (JAMManager.check(8, this.parameter.getADFFileName(), this.parameter.getADFFileName(), stringBuffer)) {
            if (this.checkDeniedMultiAppDTV()) {
                n = this.showDTVDialog(Resource.getString("CONFIRM"), Resource.getString("DTV_MSG_STOP_DTV"));
                if (n != 0) return;
                this.dtvEndFlag = true;
            }
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                if (n3 != -1) {
                    hashtable.put("service_id", String.valueOf(n3));
                }
                this.parent.setVisibleInvoker(8, false);
                JAMManager.invokeApplication(JAMManager.getAdfPath(), JAMManager.getJarPath(), 17, JAMManager.getParams(hashtable), this.parent.getDeviceName(), this.parent.getAdfUrl(), JAMManager.getProjectName(), DebugTraceWindow.getDebugParam());
                this.parent.setVisibleInvoker(8, true);
                this.parent.setEnabledDeviceMenu(false);
                this.parent.closeWindow(this);
                return;
            }
            catch (Exception exception) {
                this.parent.setVisibleInvoker(8, true);
                this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
                return;
            }
        }
        String string = stringBuffer.toString();
        if (string.equals("")) {
            string = Resource.getString("NOT_LAUNCH_APPLICATION_WNG2");
        }
        this.parent.showDialog(string, this, 2);
    }

    void cancel() {
        this.dtvEndFlag = true;
        this.parent.closeWindow(this);
    }

    boolean getAppResumeFlag() {
        return this.appResumeFlag;
    }

    void setAppResumeFlag(boolean bl) {
        this.appResumeFlag = bl;
    }

    boolean getDTVEndFlag() {
        return this.dtvEndFlag;
    }

    int getLatestSeriveId() {
        int n = this.parameter.getServiceId();
        return n;
    }

    private void updateSDF() {
        String string = this.parent.getProjectName();
        if (string == null || string.equals("")) {
            return;
        }
        try {
            new SDF(new File(this.parent.getSdfPath(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean checkDeniedMultiAppDTV() {
        boolean bl;
        block10: {
            String string = null;
            bl = false;
            String string2 = this.parameter.getADFFileName();
            if (string2 != null && !string2.equals("") && string2.endsWith(".jam")) {
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                string2 = string2.substring(0, string2.lastIndexOf(".jam"));
                string = this.parent.getProjectHome() + File.separator + string2 + File.separator + "bin" + File.separator + string2 + ".jam";
            }
            if (string == null || string.trim().length() == 0) break block10;
            String string3 = null;
            File file = new File(string);
            if (file.exists()) {
                ADF aDF;
                try {
                    aDF = new ADF(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
                string3 = aDF.getProperty("DeniedMultiApp");
                if (string3 != null && string3.trim().length() != 0) {
                    int n = 0;
                    int n2 = 0;
                    do {
                        String string4 = null;
                        n2 = string3.indexOf(44, n);
                        if (n2 != -1) {
                            string4 = string3.substring(n, n2);
                            n = n2 + 1;
                        } else {
                            string4 = string3.substring(n);
                        }
                        if (!string4.equals(string4.trim()) || !string4.equals("all") && !string4.equals("dtv")) continue;
                        bl = true;
                        break;
                    } while (n2 != -1 && n2 != string3.length() - 1);
                }
            }
        }
        return bl;
    }

    class DTVMouseListener
    implements MouseListener {
        DTVMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (DTVWindow.this.infoVisibleFlag) {
                DTVWindow.this.pnlProgramInfo.setVisible(false);
                DTVWindow.this.infoVisibleFlag = false;
            } else {
                DTVWindow.this.pnlProgramInfo.setVisible(true);
                DTVWindow.this.infoVisibleFlag = true;
            }
            DTVWindow.this.pack();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

