/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DecomailTempEntry;
import com.nttdocomo.dojaemu.ktoolbar.DecomailTempEntryWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class DecomailTempWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private final int COLUMN_WIDTH = 110;
    private static String[] decomailTempFiles;
    private JTable decomailTempTable;
    private Hashtable decomailTempHash;
    private int[] idList;
    private int next;
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;

    DecomailTempWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel2.add(this.addButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        this.decomailTempTable = this.createDecomailTempTable();
        this.scrollpane = new JScrollPane(this.decomailTempTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 200);
    }

    private JTable createDecomailTempTable() {
        int n;
        String[] stringArray;
        String string = "";
        try {
            this.decomailTempHash = new Hashtable();
            decomailTempFiles = DecomailTempEntry.decomailTempDir.list(new DecomailTempFilter());
            stringArray = new String[decomailTempFiles.length];
            for (n = 0; n < decomailTempFiles.length; ++n) {
                int n2;
                int n3 = decomailTempFiles[n].indexOf(46);
                try {
                    n2 = Integer.parseInt(decomailTempFiles[n].substring(5, n3), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                try {
                    DecomailTempEntry decomailTempEntry = new DecomailTempEntry();
                    decomailTempEntry.setEntryID(n2);
                    decomailTempEntry.load(decomailTempFiles[n]);
                    this.decomailTempHash.put(new Integer(decomailTempEntry.getEntryID()), decomailTempEntry);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(Resource.format("NOT_FOUND_ERR", DecomailTempEntry.decomailTempDir.getPath() + File.separator + decomailTempFiles[n]));
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println(Resource.format("READ_ERR", DecomailTempEntry.decomailTempDir.getPath() + File.separator + decomailTempFiles[n]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.idList = new int[this.decomailTempHash.size()];
        stringArray = this.decomailTempHash.keys();
        for (n = 0; n < this.idList.length; ++n) {
            this.idList[n] = (Integer)stringArray.nextElement();
        }
        Arrays.sort(this.idList);
        this.next = this.idList.length > 0 ? this.idList[this.idList.length - 1] + 1 : 1;
        String[] stringArray2 = new String[]{Resource.getString("DECOMAILTEMPLATE_ENTRY_ID"), Resource.getString("DECOMAILTEMPLATE_TITLE")};
        DecomailTempTableModel decomailTempTableModel = new DecomailTempTableModel(stringArray2, 0);
        for (int i = 0; i < this.idList.length; ++i) {
            DecomailTempEntry decomailTempEntry = null;
            Object v = this.decomailTempHash.get(new Integer(this.idList[i]));
            if (v == null || !(v instanceof DecomailTempEntry)) continue;
            decomailTempEntry = (DecomailTempEntry)v;
            Vector<String> vector = new Vector<String>();
            vector.addElement(new Integer(decomailTempEntry.getEntryID()).toString());
            vector.addElement(decomailTempEntry.getTitle());
            decomailTempTableModel.addRow(vector);
        }
        JTable jTable = new JTable(decomailTempTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new DecomailTempTableCellRenderer());
        jTable.setSelectionMode(2);
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    DecomailTempWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    DecomailTempWindow.this.edit();
                }
            }
        });
        jTable.getColumnModel().getColumn(0).setMinWidth(110);
        jTable.getColumnModel().getColumn(0).setMaxWidth(110);
        return jTable;
    }

    void add() {
        DecomailTempEntry decomailTempEntry = new DecomailTempEntry();
        decomailTempEntry.setEntryID(this.next);
        DecomailTempEntryWindow decomailTempEntryWindow = new DecomailTempEntryWindow(this.parent, decomailTempEntry, Resource.getString("DECOMAILTEMPLATE_ENTRY_WINDOW_TITLE"));
        decomailTempEntryWindow.setLocation(this.parent.getShowLocation(decomailTempEntryWindow.getWidth(), decomailTempEntryWindow.getHeight(), this.tabwin));
        decomailTempEntryWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.decomailTempTable = null;
        this.decomailTempTable = this.createDecomailTempTable();
        this.scrollpane = new JScrollPane(this.decomailTempTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void edit() {
        int n = this.decomailTempTable.getSelectedRow();
        if (this.decomailTempTable.getSelectedRowCount() == 1 && n < this.idList.length) {
            Object v = this.decomailTempHash.get(new Integer(this.idList[n]));
            DecomailTempEntry decomailTempEntry = null;
            if (v instanceof DecomailTempEntry) {
                decomailTempEntry = (DecomailTempEntry)v;
            }
            DecomailTempEntryWindow decomailTempEntryWindow = new DecomailTempEntryWindow(this.parent, decomailTempEntry, Resource.getString("DECOMAILTEMPLATE_EDIT_WINDOW_TITLE"));
            decomailTempEntryWindow.setLocation(this.parent.getShowLocation(decomailTempEntryWindow.getWidth(), decomailTempEntryWindow.getHeight(), this.tabwin));
            decomailTempEntryWindow.setVisible(true);
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.decomailTempTable = null;
            this.decomailTempTable = this.createDecomailTempTable();
            this.scrollpane = new JScrollPane(this.decomailTempTable);
            this.add("Center", this.scrollpane);
            this.setVisible(true);
        }
    }

    void delete() {
        if (this.decomailTempTable.getSelectedRowCount() != 0) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("DECOMAILTEMPLATE_DELETE_WNG", String.valueOf(this.decomailTempTable.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                try {
                    char[] cArray = new char[8];
                    String string = null;
                    String string2 = null;
                    File file = null;
                    PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(DecomailTempEntry.decomailEntry.getPath())));
                    for (int i = 0; i < this.decomailTempTable.getRowCount(); ++i) {
                        string = Integer.toHexString(this.idList[i]);
                        Arrays.fill(cArray, '0');
                        System.arraycopy(string.toCharArray(), 0, cArray, 8 - string.length(), string.length());
                        if (this.decomailTempTable.isRowSelected(i)) {
                            string2 = "Decom" + new String(cArray) + ".dmt";
                            file = new File(DecomailTempEntry.decomailTempDir, string2);
                            file.delete();
                            continue;
                        }
                        string2 = "Decom" + new String(cArray) + ".dmt";
                        DecomailTempEntry decomailTempEntry = (DecomailTempEntry)this.decomailTempHash.get(new Integer(this.idList[i]));
                        printWriter.println(string2 + "\t" + decomailTempEntry.getTitle());
                    }
                    printWriter.close();
                }
                catch (Exception exception) {
                    System.err.println(Resource.getString("DECOMAILTEMPLATE_DELETE_ERR"));
                    return;
                }
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.decomailTempTable = null;
                this.decomailTempTable = this.createDecomailTempTable();
                this.scrollpane = new JScrollPane(this.decomailTempTable);
                this.add("Center", this.scrollpane);
                this.setVisible(true);
            }
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.idList != null && this.idList.length > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    class DecomailTempTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        DecomailTempTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (n2 == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class DecomailTempFilter
    implements FilenameFilter {
        DecomailTempFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(DecomailTempEntry.decomailTempDir)) {
                return string.endsWith(".dmt");
            }
            return false;
        }
    }

    class DecomailTempTableModel
    extends DefaultTableModel {
        DecomailTempTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

