/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AppSettingWindow;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FontSizeEditWindow
extends AbstractWindow {
    private MainWindow parent;
    private JTextField fontSizeField;
    public String fontSize = null;
    private static final int MAX_FONT_SIZE = 128;
    private static final int MIN_FONT_SIZE = 12;
    private static final int SIZE_TINY = 12;
    private static final int SIZE_SMALL = 16;
    private static final int SIZE_MEDIUM = 24;
    private static final int SIZE_LARGE = 30;
    private Object objReg;

    FontSizeEditWindow(MainWindow mainWindow, Object object) {
        super(mainWindow, null, true);
        this.parent = mainWindow;
        this.objReg = object;
        this.addWindowListener();
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        JLabel jLabel = new JLabel(Resource.getString("FONT_SIZE"));
        this.fontSizeField = new JTextField(5);
        this.fontSizeField.setDocument(new HalfNumberDocument(3));
        this.setTitle(Resource.getString("FONT_SIZE_SETTING"));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(jLabel);
        jPanel2.add(this.fontSizeField);
        container.add("Center", jPanel2);
        container.add("South", jPanel);
        this.pack();
        this.setResizable(false);
        this.setSize(200, 100);
        jButton2.setActionCommand("cancel");
        jButton.setActionCommand("save");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton2.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
    }

    void save() {
        int n;
        try {
            n = Integer.parseInt(this.fontSizeField.getText());
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("FONT_SIZE_NOINPUT_WNG"), this, 2);
            return;
        }
        if (n < 12 || n > 128) {
            Object[] objectArray = new String[]{Resource.getString("FONT_SIZE"), String.valueOf(12), String.valueOf(128)};
            this.parent.showDialog(Resource.format("FONT_SIZE_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        if (n == 12 || n == 16 || n == 24 || n == 30) {
            this.parent.showDialog(Resource.getString("FONT_SIZE_DEFAULT_WNG"), this, 2);
            return;
        }
        if (this.objReg instanceof AppSettingWindow) {
            AppSettingWindow appSettingWindow = (AppSettingWindow)this.objReg;
            for (int i = 0; i < appSettingWindow.fontSizeModel.getSize(); ++i) {
                if (!appSettingWindow.fontSizeModel.elementAt(i).equals(String.valueOf(n))) continue;
                this.parent.showDialog(Resource.getString("FONT_SIZE_DUPLICATE_WNG"), this, 2);
                return;
            }
        }
        this.fontSize = String.valueOf(Integer.parseInt(this.fontSizeField.getText()));
        this.setVisible(false);
    }

    void cancel() {
        this.fontSize = null;
        this.setVisible(false);
    }
}

