/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.DecimalDocument;
import com.nttdocomo.dojaemu.ktoolbar.GestureTekRollEntry;
import com.nttdocomo.dojaemu.ktoolbar.GestureTekShakeEntry;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComboBoxUI;

class GestureTekEditWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private GestureTekRollEntry rollEntry;
    private GestureTekShakeEntry shakeEntry;
    private boolean pFlag = true;
    private JTextField gestureTekXField;
    private JTextField gestureTekYField;
    private JTextField shakeField;
    private JComboBox qualityCombo;
    private int select;
    private JButton setButton;
    private JButton cancelButton;
    static int ROLL_SELECT = 0;
    static int SHAKE_SELECT = 1;
    private String ILLEGAL_GESTURETEKX = "1";
    private String ILLEGAL_GESTURETEKY = "2";
    private String ILLEGAL_SHAKE = "3";
    public static final String[] qualityItems = new String[]{"RELIABLE", "LOW_DETAIL", "TOO_FAST", "SAME_VALUE"};
    public static final String[] qualityValues = new String[]{"0", "1", "2", "3"};

    GestureTekEditWindow(MainWindow mainWindow, GestureTekRollEntry gestureTekRollEntry, GestureTekShakeEntry gestureTekShakeEntry, boolean bl, int n) {
        super(mainWindow, Resource.getString("GES_SET_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.shakeEntry = gestureTekShakeEntry;
        this.rollEntry = gestureTekRollEntry;
        this.pFlag = bl;
        this.select = n;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("GES_X_AXIS"));
        JLabel jLabel2 = new JLabel(Resource.getString("GES_Y_AXIS"));
        JLabel jLabel3 = new JLabel(Resource.getString("GES_QUALITY"));
        jLabel3.setHorizontalAlignment(0);
        JLabel jLabel4 = new JLabel(Resource.getString("GES_SHAKE"));
        this.gestureTekXField = new JTextField(10);
        this.gestureTekYField = new JTextField(10);
        this.gestureTekXField.setDocument(new DecimalDocument(11));
        this.gestureTekYField.setDocument(new DecimalDocument(11));
        this.shakeField = new JTextField(10);
        this.shakeField.setDocument(new HalfNumberDocument(3));
        this.qualityCombo = new JComboBox<String>(qualityItems);
        this.qualityCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.qualityCombo.setPreferredSize(new Dimension(100, 20));
        this.gestureTekXField.setHorizontalAlignment(4);
        this.gestureTekYField.setHorizontalAlignment(4);
        this.shakeField.setHorizontalAlignment(4);
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("ROLL_MOVE")));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(3, 1));
        jPanel4.add(jLabel);
        jPanel4.add(jLabel2);
        jPanel4.add(jLabel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(0));
        jPanel6.add(this.gestureTekXField);
        jPanel7.add(this.gestureTekYField);
        jPanel8.add(this.qualityCombo);
        jPanel5.add(jPanel6);
        jPanel5.add(jPanel7);
        jPanel5.add(jPanel8);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SHAKE_MOVE")));
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        jPanel9.add(jLabel4);
        jPanel10.add(this.shakeField);
        jPanel10.setLayout(new FlowLayout(0));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new FlowLayout());
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel11.add(jPanel9);
        jPanel11.add(jPanel10);
        jPanel3.add(jPanel11);
        jPanel.add(this.setButton);
        jPanel.add(this.cancelButton);
        container.add(jPanel2);
        container.add(jPanel3);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        if (n == ROLL_SELECT) {
            this.gestureTekXField.setText(gestureTekRollEntry.getGestureTekX());
            this.gestureTekYField.setText(gestureTekRollEntry.getGestureTekY());
            for (int i = 0; i < qualityValues.length; ++i) {
                if (!qualityValues[i].equals(gestureTekRollEntry.getQuality())) continue;
                this.qualityCombo.setSelectedIndex(i);
                break;
            }
            this.gestureTekXField.setEnabled(true);
            this.gestureTekYField.setEnabled(true);
            this.qualityCombo.setEnabled(true);
            this.shakeField.setEnabled(false);
            this.shakeField.setBackground(this.getBackground());
        } else if (n == SHAKE_SELECT) {
            this.shakeField.setText(gestureTekShakeEntry.getShake());
            this.gestureTekXField.setEnabled(false);
            this.gestureTekYField.setEnabled(false);
            this.qualityCombo.setEnabled(false);
            this.gestureTekXField.setBackground(this.getBackground());
            this.gestureTekYField.setBackground(this.getBackground());
            this.shakeField.setEnabled(true);
        }
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    static boolean checkRoll(String string) {
        try {
            int n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    static boolean checkShake(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return n >= 0 && n <= 511;
    }

    void set() {
        if (this.select == ROLL_SELECT) {
            this.rollSet();
        } else if (this.select == SHAKE_SELECT) {
            this.shakeSet();
        }
    }

    void rollSet() {
        boolean bl = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (GestureTekEditWindow.checkRoll(this.gestureTekXField.getText())) {
            string2 = this.gestureTekXField.getText();
        }
        if (GestureTekEditWindow.checkRoll(this.gestureTekYField.getText())) {
            string3 = this.gestureTekYField.getText();
        }
        string4 = qualityValues[this.qualityCombo.getSelectedIndex()];
        String string6 = "";
        try {
            if (string2 == null || string2.length() < 1) {
                throw new IllegalArgumentException(this.ILLEGAL_GESTURETEKX);
            }
            if (string3 == null || string3.length() < 1) {
                throw new IllegalArgumentException(this.ILLEGAL_GESTURETEKY);
            }
            string = string2 + "," + string3 + "," + string4;
            string5 = this.rollEntry.getEntryId() + ".ges";
            this.rollEntry.rollSave(string, string5, this.pFlag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().equals(this.ILLEGAL_GESTURETEKX)) {
                string6 = Resource.getString("GES_X_AXIS");
            } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_GESTURETEKY)) {
                string6 = Resource.getString("GES_Y_AXIS");
            }
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string6), this, 2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", string5));
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void shakeSet() {
        boolean bl = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (GestureTekEditWindow.checkShake(this.shakeField.getText())) {
            string2 = this.shakeField.getText();
        }
        String string4 = "";
        try {
            if (string2 == null || string2.length() < 1) {
                throw new IllegalArgumentException(this.ILLEGAL_SHAKE);
            }
            string = string2;
            string3 = this.shakeEntry.getEntryId() + ".ges";
            this.shakeEntry.shakeSave(string, string3, this.pFlag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().equals(this.ILLEGAL_SHAKE)) {
                string4 = Resource.getString("GES_SHAKE");
            }
            this.parent.showDialog(Resource.format("GES_SHAKE_WNG", string4), this, 2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", string3));
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

