/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class IniFileEntity {
    private String iniName = "";
    private Map sections = new TreeMap();
    private BufferedReader reader;
    private BufferedWriter writer;
    private File iniFile;

    public IniFileEntity(String string) {
        this.iniName = string;
        this.iniFile = new File(this.iniName);
    }

    public IniSection getSection(String string) {
        return (IniSection)this.sections.get(string);
    }

    public void addSection(IniSection iniSection) {
        this.sections.put(iniSection.getTitle(), iniSection);
    }

    public String getName() {
        return this.iniName;
    }

    public void setSectionAttribute(String string, String string2, String string3) {
        IniSection iniSection = this.getSection(string);
        if (iniSection == null) {
            iniSection = new IniSection(string);
            this.addSection(iniSection);
        }
        iniSection.setAttribute(string2, string3);
    }

    public String getSectionAttribute(String string, String string2) {
        IniSection iniSection = this.getSection(string);
        if (iniSection == null) {
            return null;
        }
        return iniSection.getAttribute(string2);
    }

    public boolean getSectionAttributeBool(String string, String string2, boolean bl) {
        IniSection iniSection = this.getSection(string);
        if (iniSection == null) {
            return bl;
        }
        return iniSection.getAttribute(string2, bl + "").equalsIgnoreCase("yes") || iniSection.getAttribute(string2, bl + "").equalsIgnoreCase("true");
    }

    public String getSectionAttributeStr(String string, String string2, String string3) {
        IniSection iniSection = this.getSection(string);
        if (iniSection == null) {
            return string3;
        }
        return iniSection.getAttribute(string2, string3);
    }

    public int getSectionAttributeInt(String string, String string2, int n) {
        IniSection iniSection = this.getSection(string);
        if (iniSection == null) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(iniSection.getAttribute(string2, n + ""));
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public String toString() {
        String string = "";
        Object[] objectArray = this.sections.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + this.getSection((String)objectArray[i]).toString() + "\n";
        }
        if (string.endsWith("\n\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        File file = new File(this.iniName);
        try {
            this.writer = new BufferedWriter(new FileWriter(file));
            this.writer.write(this.toString());
        }
        finally {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        String string = "";
        try {
            this.reader = new BufferedReader(new FileReader(this.iniFile));
            string = this.reader.readLine();
            IniSection iniSection = null;
            String string2 = "";
            while (string != null) {
                if (string.length() > 0) {
                    if (string.charAt(0) == '[') {
                        iniSection = new IniSection(string.substring(1, string.lastIndexOf("]")));
                        iniSection.setComment(string2);
                        this.addSection(iniSection);
                        string2 = "";
                    } else if (string.charAt(0) == ';' || string.charAt(0) == '#') {
                        string2 = string2 + string + "\n";
                    } else {
                        String string3 = string.substring(0, string.indexOf("="));
                        String string4 = string.substring(string.indexOf("=") + 1);
                        if (string4.length() > 0 && string4.charAt(0) == '{') {
                            string = this.reader.readLine();
                            string4 = "";
                            boolean bl = false;
                            if (string.length() != 0) {
                                boolean bl2 = bl = string.charAt(0) == '}';
                            }
                            while (!bl) {
                                if (!string4.equals("")) {
                                    string4 = string4 + "\n";
                                }
                                string4 = string4 + string;
                                string = this.reader.readLine();
                                if (string.length() == 0) continue;
                                bl = string.charAt(0) == '}';
                            }
                        }
                        iniSection.setAttribute(string3, string4, string2);
                        string2 = "";
                    }
                } else {
                    string2 = string2 + "\n";
                }
                string = this.reader.readLine();
            }
        }
        finally {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public class IniSection {
        private String title;
        private String comment;
        private Map attributes;
        private Map comments;

        public IniSection(String string) {
            this.title = string;
            this.attributes = new LinkedHashMap();
            this.comments = new LinkedHashMap();
            this.comment = "";
        }

        public String getTitle() {
            return this.title;
        }

        public String getAttribute(String string) {
            return (String)this.attributes.get(string);
        }

        public String getAttributeComment(String string) {
            String string2 = (String)this.comments.get(string);
            if (string2 == null) {
                return "";
            }
            return string2;
        }

        public void removeAttribute(String string) {
            this.attributes.remove(string);
        }

        public void removeAttributeComment(String string) {
            this.comments.remove(string);
        }

        public String[] findKeys(String string) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string2 : this.attributes.keySet()) {
                if (!this.getAttribute(string2).equals(string)) continue;
                linkedList.add(string2);
            }
            return linkedList.toArray(new String[0]);
        }

        public String getAttribute(String string, String string2) {
            if (this.attributes.get(string) == null) {
                return string2;
            }
            if (((String)this.attributes.get(string)).equals("")) {
                return string2;
            }
            return (String)this.attributes.get(string);
        }

        public int getAttribute(String string, int n) {
            try {
                return Integer.parseInt(this.getAttribute(string, n + ""));
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        public boolean getAttribute(String string, boolean bl) {
            return this.getAttribute(string, bl + "").equalsIgnoreCase("true");
        }

        public void setAttribute(String string, String string2) {
            this.setAttribute(string, string2, "");
        }

        public void setAttribute(String string, String string2, String string3) {
            this.attributes.remove(string);
            this.attributes.put(string, string2);
            if (!string3.equals("")) {
                this.comments.remove(string);
                this.comments.put(string, string3);
            }
        }

        public void setAttribute(String string, int n) {
            this.setAttribute(string, n + "");
        }

        public String toString() {
            String string = "";
            String[] stringArray = this.attributes.keySet().toArray(new String[0]);
            string = string + this.comment;
            string = string + "[" + this.title + "]" + "\n";
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = this.getAttribute(stringArray[i]);
                if (string2 == null) continue;
                string = string + this.getAttributeComment(stringArray[i]);
                string = string + stringArray[i] + "=" + this.formatAttribute(string2) + "\n";
            }
            return string;
        }

        private String formatAttribute(String string) {
            if (string.lastIndexOf("\n") != -1) {
                return "{\n" + string + "\n}";
            }
            return string;
        }

        public void setComment(String string) {
            this.comment = string;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

